/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.SymbolBase;
import com.xxdb.data.SymbolBaseCollection;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.util.List;

public class BasicSymbolVector
extends AbstractVector {
    private SymbolBase base;
    private int[] values;

    public BasicSymbolVector(int size) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.base = new SymbolBase(0);
        this.values = new int[size];
    }

    public BasicSymbolVector(SymbolBase base, int size) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.base = base;
        this.values = new int[size];
    }

    public BasicSymbolVector(List<String> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.base = new SymbolBase(0);
        this.values = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.values[i] = this.base.find(list.get(i), true);
        }
    }

    public BasicSymbolVector(SymbolBase base, int[] values, boolean copy) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.base = base;
        if (copy) {
            values = new int[values.length];
            System.arraycopy(this.values, 0, values, 0, values.length);
        } else {
            this.values = values;
        }
    }

    protected BasicSymbolVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int rows = in.readInt();
        int columns = in.readInt();
        int size = rows * columns;
        this.values = new int[size];
        this.base = new SymbolBase(in);
        for (int i = 0; i < size; ++i) {
            this.values[i] = in.readInt();
        }
    }

    protected BasicSymbolVector(Entity.DATA_FORM df, ExtendedDataInput in, SymbolBaseCollection collection) throws IOException {
        super(df);
        int rows = in.readInt();
        int columns = in.readInt();
        int size = rows * columns;
        this.values = new int[size];
        this.base = collection.add(in);
        for (int i = 0; i < size; ++i) {
            this.values[i] = in.readInt();
        }
    }

    @Override
    public Scalar get(int index) {
        return new BasicString(this.base.getSymbol(this.values[index]));
    }

    @Override
    public Vector getSubVector(int[] indices) {
        int length = indices.length;
        int[] sub = new int[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return new BasicSymbolVector(this.base, sub, false);
    }

    @Override
    public String getString(int index) {
        return this.base.getSymbol(this.values[index]);
    }

    @Override
    public void set(int index, Scalar value) throws Exception {
        this.values[index] = this.base.find(value.getString(), true);
    }

    public void setString(int index, String value) {
        this.values[index] = this.base.find(value, true);
    }

    @Override
    public int hashBucket(int index, int buckets) {
        return BasicString.hashBucket(this.base.getSymbol(this.values[index]), buckets);
    }

    @Override
    public Vector combine(Vector vector) {
        BasicSymbolVector v = (BasicSymbolVector)vector;
        int newSize = this.rows() + v.rows();
        int[] newValue = new int[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        if (v.base == this.base) {
            System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        } else {
            SymbolBase vBase = v.base;
            int length = vBase.size();
            int[] mapper = new int[length];
            for (int i = 0; i < length; ++i) {
                mapper[i] = this.base.find(vBase.getSymbol(i), true);
            }
            length = v.rows();
            int[] vValues = v.values;
            int baseRow = this.rows();
            for (int i = 0; i < length; ++i) {
                newValue[baseRow + i] = mapper[vValues[i]];
            }
        }
        return new BasicSymbolVector(this.base, newValue, false);
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index] == 0;
    }

    @Override
    public void setNull(int index) {
        this.values[index] = 0;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.LITERAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_SYMBOL;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicString.class;
    }

    @Override
    public int rows() {
        return this.values.length;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        this.base.write(out);
        out.writeIntArray(this.values);
    }

    public void write(ExtendedDataOutput out, SymbolBaseCollection collection) throws IOException {
        int dataType = this.getDataType().getValue() + 128;
        int flag = (Entity.DATA_FORM.DF_VECTOR.ordinal() << 8) + dataType;
        out.writeShort(flag);
        out.writeInt(this.rows());
        out.writeInt(this.columns());
        collection.write(out, this.base);
        out.writeIntArray(this.values);
    }

    @Override
    public int asof(Scalar value) {
        String target = value.getString();
        int start = 0;
        int end = this.values.length - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            if (this.base.getSymbol(this.values[mid]).compareTo(target) <= 0) {
                start = mid + 1;
                continue;
            }
            end = mid - 1;
        }
        return end;
    }
}

