/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.streaming.client;

import com.xxdb.streaming.client.AbstractClient;
import com.xxdb.streaming.client.MessageDispatcher;
import com.xxdb.streaming.client.MessageParser;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class Daemon
implements Runnable {
    private int listeningPort = 0;
    private MessageDispatcher dispatcher;
    private static final int KEEPALIVE_IDLE = 1000;
    private static final int KEEPALIVE_INTERVAL = 1000;
    private static final int KEEPALIVE_COUNT = 5;
    private Thread runningThread_ = null;

    public Daemon(int port, MessageDispatcher dispatcher) {
        this.listeningPort = port;
        this.dispatcher = dispatcher;
    }

    public void setRunningThread(Thread runningThread) {
        this.runningThread_ = runningThread;
    }

    @Override
    public void run() {
        ServerSocket ssocket = null;
        try {
            ssocket = new ServerSocket(this.listeningPort);
            ssocket.setSoTimeout(1000);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ReconnectDetector rcDetector = new ReconnectDetector(this.dispatcher);
        Thread rcThread = new Thread(rcDetector);
        rcDetector.setRunningThread(rcThread);
        rcThread.start();
        HashSet<Socket> threadSet = new HashSet<Socket>();
        while (!this.runningThread_.isInterrupted()) {
            try {
                Socket socket = ssocket.accept();
                socket.setKeepAlive(true);
                MessageParser listener = new MessageParser(socket, this.dispatcher);
                Thread listeningThread = new Thread(listener);
                threadSet.add(socket);
                listeningThread.start();
                if (System.getProperty("os.name").equalsIgnoreCase("linux")) continue;
                new Thread(new ConnectionDetector(socket)).start();
            }
            catch (IOException ex) {
                try {
                    if (this.runningThread_.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    Thread.sleep(100L);
                }
                catch (InterruptedException iEx) {
                    break;
                }
            }
        }
        try {
            assert (ssocket != null);
            ssocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        rcThread.interrupt();
        try {
            ssocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Iterator it = threadSet.iterator();
        while (it.hasNext()) {
            try {
                ((Socket)it.next()).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class ConnectionDetector
    implements Runnable {
        Socket socket = null;

        public ConnectionDetector(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    this.socket.sendUrgentData(255);
                }
                catch (Exception ex) {
                    int failCount = 0;
                    for (int i = 0; i < 5; ++i) {
                        try {
                            this.socket.sendUrgentData(255);
                        }
                        catch (Exception ex0) {
                            ++failCount;
                        }
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (Exception ex1) {
                            ex.printStackTrace();
                        }
                    }
                    if (failCount != 5) continue;
                    try {
                        System.out.println("Connection closed!!");
                        this.socket.close();
                        return;
                    }
                    catch (Exception e) {
                        return;
                    }
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class ReconnectDetector
    implements Runnable {
        MessageDispatcher dispatcher = null;
        private Thread pThread = null;

        public ReconnectDetector(MessageDispatcher d) {
            this.dispatcher = d;
        }

        public void setRunningThread(Thread runningThread) {
            this.pThread = runningThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.pThread.isInterrupted()) {
                Set<String> waitReconnectTopic;
                for (String string : this.dispatcher.getAllReconnectSites()) {
                    if (this.dispatcher.getNeedReconnect(string) == 1) {
                        AbstractClient.Site s = this.dispatcher.getSiteByName(string);
                        this.dispatcher.activeCloseConnection(s);
                        String lastTopic = "";
                        for (String topic : this.dispatcher.getAllTopicsBySite(string)) {
                            System.out.println("try to reconnect topic " + topic);
                            this.dispatcher.tryReconnect(topic);
                            lastTopic = topic;
                        }
                        this.dispatcher.setNeedReconnect(lastTopic, 2);
                        continue;
                    }
                    long ts = this.dispatcher.getReconnectTimestamp(string);
                    if (System.currentTimeMillis() < ts + 3000L) continue;
                    AbstractClient.Site s = this.dispatcher.getSiteByName(string);
                    this.dispatcher.activeCloseConnection(s);
                    for (String topic : this.dispatcher.getAllTopicsBySite(string)) {
                        System.out.println("try to reconnect topic " + topic);
                        this.dispatcher.tryReconnect(topic);
                    }
                    this.dispatcher.setReconnectTimestamp(string, System.currentTimeMillis());
                }
                Set<String> set = waitReconnectTopic = this.dispatcher.getAllReconnectTopic();
                synchronized (set) {
                    for (String topic : waitReconnectTopic) {
                        this.dispatcher.tryReconnect(topic);
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    break;
                }
            }
        }
    }
}

