/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.streaming.client;

import com.xxdb.streaming.client.IMessage;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class TopicPoller {
    BlockingQueue<List<IMessage>> queue;
    ArrayList<IMessage> cache = null;

    public TopicPoller(BlockingQueue<List<IMessage>> queue) {
        this.queue = queue;
    }

    public void setQueue(BlockingQueue<List<IMessage>> queue) {
        this.queue = queue;
    }

    private void fillCache(long timeout) {
        assert (this.cache == null);
        List<IMessage> list = null;
        if (this.cache == null) {
            try {
                list = timeout >= 0L ? this.queue.poll(timeout, TimeUnit.MILLISECONDS) : this.queue.take();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private void fillCache(long timeout, int size) {
        assert (this.cache == null);
        List list = null;
        LocalTime end = LocalTime.now().plusNanos(timeout * 1000000L);
        while ((list == null || list.size() < size) && LocalTime.now().isBefore(end)) {
            List tmp = (List)this.queue.poll();
            if (tmp == null) continue;
            if (list == null) {
                list = tmp;
                continue;
            }
            list.addAll(tmp);
        }
        if (list != null) {
            this.cache = new ArrayList(list.size());
            this.cache.addAll(list);
        }
    }

    public ArrayList<IMessage> poll(long timeout) {
        if (this.cache == null) {
            this.fillCache(timeout);
        }
        ArrayList<IMessage> cachedMessages = this.cache;
        this.cache = null;
        return cachedMessages;
    }

    public ArrayList<IMessage> poll(long timeout, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be greater than zero");
        }
        this.fillCache(timeout, size);
        ArrayList<IMessage> cachedMessages = this.cache;
        this.cache = null;
        return cachedMessages;
    }

    public IMessage take() {
        if (this.cache == null) {
            this.fillCache(-1L);
        }
        return this.cache.remove(0);
    }
}

