/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb;

import com.xxdb.RSAUtils;
import com.xxdb.data.BasicBoolean;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.BasicString;
import com.xxdb.data.Entity;
import com.xxdb.data.EntityFactory;
import com.xxdb.data.Void;
import com.xxdb.io.AbstractExtendedDataOutputStream;
import com.xxdb.io.BigEndianDataInputStream;
import com.xxdb.io.BigEndianDataOutputStream;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import com.xxdb.io.LittleEndianDataInputStream;
import com.xxdb.io.LittleEndianDataOutputStream;
import com.xxdb.io.ProgressListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class DBConnection {
    private static final int MAX_FORM_VALUE = Entity.DATA_FORM.values().length - 1;
    private static final int MAX_TYPE_VALUE = Entity.DATA_TYPE.values().length - 1;
    private ReentrantLock mutex;
    private String sessionID = "";
    private Socket socket;
    private boolean remoteLittleEndian;
    private ExtendedDataOutput out;
    private ExtendedDataInput in;
    private EntityFactory factory = new BasicEntityFactory();
    private String hostName;
    private int port;
    private String userId;
    private String password;
    private boolean encrypted;

    public DBConnection() {
        this.mutex = new ReentrantLock();
    }

    public boolean isBusy() {
        if (!this.mutex.tryLock()) {
            return true;
        }
        this.mutex.unlock();
        return false;
    }

    public boolean connect(String hostName, int port) throws IOException {
        return this.connect(hostName, port, "", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(String hostName, int port, String userId, String password) throws IOException {
        this.mutex.lock();
        try {
            if (!this.sessionID.isEmpty()) {
                this.mutex.unlock();
                boolean bl = true;
                return bl;
            }
            this.hostName = hostName;
            this.port = port;
            this.userId = userId;
            this.password = password;
            this.encrypted = true;
            boolean bl = this.connect();
            return bl;
        }
        finally {
            this.mutex.unlock();
        }
    }

    private boolean connect() throws IOException {
        this.socket = new Socket(this.hostName, this.port);
        this.socket.setKeepAlive(true);
        this.socket.setTcpNoDelay(true);
        this.out = new LittleEndianDataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        LittleEndianDataInputStream input = new LittleEndianDataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        String body = "connect\n";
        this.out.writeBytes("API 0 ");
        this.out.writeBytes(String.valueOf(body.length()));
        this.out.writeByte(10);
        this.out.writeBytes(body);
        this.out.flush();
        String line = input.readLine();
        int endPos = line.indexOf(32);
        if (endPos <= 0) {
            this.close();
            return false;
        }
        this.sessionID = line.substring(0, endPos);
        int startPos = endPos + 1;
        if ((endPos = line.indexOf(32, startPos)) != line.length() - 2) {
            this.close();
            return false;
        }
        if (line.charAt(endPos + 1) == '0') {
            this.remoteLittleEndian = false;
            this.out = new BigEndianDataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        } else {
            this.remoteLittleEndian = true;
        }
        ExtendedDataInput extendedDataInput = this.in = this.remoteLittleEndian ? new LittleEndianDataInputStream(new BufferedInputStream(this.socket.getInputStream())) : new BigEndianDataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        if (!this.userId.isEmpty() && !this.password.isEmpty()) {
            this.login();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(String userId, String password, boolean enableEncryption) throws IOException {
        this.mutex.lock();
        try {
            this.userId = userId;
            this.password = password;
            this.encrypted = enableEncryption;
            this.login();
        }
        finally {
            this.mutex.unlock();
        }
    }

    private void login() throws IOException {
        ArrayList<Entity> args = new ArrayList<Entity>();
        if (this.encrypted) {
            BasicString keyCode = (BasicString)this.run("getDynamicPublicKey()");
            PublicKey key = RSAUtils.getPublicKey(keyCode.getString());
            byte[] usr = RSAUtils.encryptByPublicKey(this.userId.getBytes(), key);
            byte[] pass = RSAUtils.encryptByPublicKey(this.password.getBytes(), key);
            args.add(new BasicString(Base64.getMimeEncoder().encodeToString(usr)));
            args.add(new BasicString(Base64.getMimeEncoder().encodeToString(pass)));
            args.add(new BasicBoolean(true));
        } else {
            args.add(new BasicString(this.userId));
            args.add(new BasicString(this.password));
        }
        this.run("login", args);
    }

    public boolean getRemoteLittleEndian() {
        return this.remoteLittleEndian;
    }

    public Entity tryRun(String script) throws IOException {
        if (!this.mutex.tryLock()) {
            return null;
        }
        try {
            Entity entity = this.run(script);
            return entity;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public Entity run(String script) throws IOException {
        return this.run(script, (ProgressListener)null);
    }

    public Entity run(String script, ProgressListener listener) throws IOException {
        this.mutex.lock();
        try {
            boolean reconnect = false;
            if (this.socket == null || !this.socket.isConnected() || this.socket.isClosed()) {
                if (this.sessionID.isEmpty()) {
                    throw new IOException("Database connection is not established yet.");
                }
                this.socket = new Socket(this.hostName, this.port);
                this.out = new LittleEndianDataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            }
            String body = "script\n" + script;
            String header = null;
            try {
                this.out.writeBytes((listener != null ? "API2 " : "API ") + this.sessionID + " ");
                this.out.writeBytes(String.valueOf(AbstractExtendedDataOutputStream.getUTFlength(body, 0, 0)));
                this.out.writeByte(10);
                this.out.writeBytes(body);
                this.out.flush();
                header = this.in.readLine();
            }
            catch (IOException ex) {
                if (reconnect) {
                    this.socket = null;
                    throw ex;
                }
                try {
                    this.connect();
                    this.out.writeBytes((listener != null ? "API2 " : "API ") + this.sessionID + " ");
                    this.out.writeBytes(String.valueOf(AbstractExtendedDataOutputStream.getUTFlength(body, 0, 0)));
                    this.out.writeByte(10);
                    this.out.writeBytes(body);
                    this.out.flush();
                    header = this.in.readLine();
                    reconnect = true;
                }
                catch (Exception e) {
                    this.socket = null;
                    throw e;
                }
            }
            while (header.equals("MSG")) {
                String msg = this.in.readString();
                if (listener != null) {
                    listener.progress(msg);
                }
                header = this.in.readLine();
            }
            String[] headers = header.split(" ");
            if (headers.length != 3) {
                this.socket = null;
                throw new IOException("Received invalid header: " + header);
            }
            if (reconnect) {
                this.sessionID = headers[0];
            }
            int numObject = Integer.parseInt(headers[1]);
            String msg = this.in.readLine();
            if (!msg.equals("OK")) {
                throw new IOException(msg);
            }
            if (numObject == 0) {
                Void void_ = new Void();
                return void_;
            }
            short flag = this.in.readShort();
            int form = flag >> 8;
            int type = flag & 0xFF;
            if (form < 0 || form > MAX_FORM_VALUE) {
                throw new IOException("Invalid form value: " + form);
            }
            if (type < 0 || type > MAX_TYPE_VALUE) {
                throw new IOException("Invalid type value: " + type);
            }
            Entity.DATA_FORM df = Entity.DATA_FORM.values()[form];
            Entity.DATA_TYPE dt = Entity.DATA_TYPE.values()[type];
            Entity entity = this.factory.createEntity(df, dt, this.in);
            return entity;
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity tryRun(String function, List<Entity> arguments) throws IOException {
        if (!this.mutex.tryLock()) {
            return null;
        }
        try {
            Entity entity = this.run(function, arguments);
            return entity;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public Entity run(String function, List<Entity> arguments) throws IOException {
        this.mutex.lock();
        try {
            boolean reconnect = false;
            if (this.socket == null || !this.socket.isConnected() || this.socket.isClosed()) {
                if (this.sessionID.isEmpty()) {
                    throw new IOException("Database connection is not established yet.");
                }
                this.socket = new Socket(this.hostName, this.port);
                this.out = new LittleEndianDataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                this.in = this.remoteLittleEndian ? new LittleEndianDataInputStream(new BufferedInputStream(this.socket.getInputStream())) : new BigEndianDataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            }
            String body = "function\n" + function;
            body = body + "\n" + arguments.size() + "\n";
            body = body + (this.remoteLittleEndian ? "1" : "0");
            String[] headers = null;
            try {
                this.out.writeBytes("API " + this.sessionID + " ");
                this.out.writeBytes(String.valueOf(body.length()));
                this.out.writeByte(10);
                this.out.writeBytes(body);
                for (int i = 0; i < arguments.size(); ++i) {
                    arguments.get(i).write(this.out);
                }
                this.out.flush();
                headers = this.in.readLine().split(" ");
            }
            catch (IOException ex) {
                if (reconnect) {
                    this.socket = null;
                    throw ex;
                }
                try {
                    this.connect();
                    this.out = new LittleEndianDataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                    this.out.writeBytes("API " + this.sessionID + " ");
                    this.out.writeBytes(String.valueOf(body.length()));
                    this.out.writeByte(10);
                    this.out.writeBytes(body);
                    for (int i = 0; i < arguments.size(); ++i) {
                        arguments.get(i).write(this.out);
                    }
                    this.out.flush();
                    this.in = this.remoteLittleEndian ? new LittleEndianDataInputStream(new BufferedInputStream(this.socket.getInputStream())) : new BigEndianDataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                    headers = this.in.readLine().split(" ");
                    reconnect = true;
                }
                catch (Exception e) {
                    this.socket = null;
                    throw e;
                }
            }
            if (headers.length != 3) {
                this.socket = null;
                throw new IOException("Received invalid header.");
            }
            if (reconnect) {
                this.sessionID = headers[0];
            }
            int numObject = Integer.parseInt(headers[1]);
            String msg = this.in.readLine();
            if (!msg.equals("OK")) {
                throw new IOException(msg);
            }
            if (numObject == 0) {
                Void void_ = new Void();
                return void_;
            }
            short flag = this.in.readShort();
            int form = flag >> 8;
            int type = flag & 0xFF;
            if (form < 0 || form > MAX_FORM_VALUE) {
                throw new IOException("Invalid form value: " + form);
            }
            if (type < 0 || type > MAX_TYPE_VALUE) {
                throw new IOException("Invalid type value: " + type);
            }
            Entity.DATA_FORM df = Entity.DATA_FORM.values()[form];
            Entity.DATA_TYPE dt = Entity.DATA_TYPE.values()[type];
            Entity entity = this.factory.createEntity(df, dt, this.in);
            return entity;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public void tryUpload(Map<String, Entity> variableObjectMap) throws IOException {
        if (!this.mutex.tryLock()) {
            throw new IOException("The connection is in use.");
        }
        try {
            this.upload(variableObjectMap);
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(Map<String, Entity> variableObjectMap) throws IOException {
        if (variableObjectMap == null || variableObjectMap.isEmpty()) {
            return;
        }
        this.mutex.lock();
        try {
            String msg;
            boolean reconnect = false;
            if (this.socket == null || !this.socket.isConnected() || this.socket.isClosed()) {
                if (this.sessionID.isEmpty()) {
                    throw new IOException("Database connection is not established yet.");
                }
                reconnect = true;
                this.socket = new Socket(this.hostName, this.port);
                this.out = new LittleEndianDataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                this.in = this.remoteLittleEndian ? new LittleEndianDataInputStream(new BufferedInputStream(this.socket.getInputStream())) : new BigEndianDataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            }
            ArrayList<Entity> objects = new ArrayList<Entity>();
            String body = "variable\n";
            for (String key : variableObjectMap.keySet()) {
                if (!this.isVariableCandidate(key)) {
                    throw new IllegalArgumentException("'" + key + "' is not a good variable name.");
                }
                body = body + key + ",";
                objects.add(variableObjectMap.get(key));
            }
            body = body.substring(0, body.length() - 1);
            body = body + "\n" + objects.size() + "\n";
            body = body + (this.remoteLittleEndian ? "1" : "0");
            try {
                this.out.writeBytes("API " + this.sessionID + " ");
                this.out.writeBytes(String.valueOf(body.length()));
                this.out.writeByte(10);
                this.out.writeBytes(body);
                for (int i = 0; i < objects.size(); ++i) {
                    ((Entity)objects.get(i)).write(this.out);
                }
                this.out.flush();
            }
            catch (IOException ex) {
                if (reconnect) {
                    this.socket = null;
                    throw ex;
                }
                try {
                    this.socket = new Socket(this.hostName, this.port);
                    this.out = new LittleEndianDataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                    this.out.writeBytes("API " + this.sessionID + " ");
                    this.out.writeBytes(String.valueOf(body.length()));
                    this.out.writeByte(10);
                    this.out.writeBytes(body);
                    for (int i = 0; i < objects.size(); ++i) {
                        ((Entity)objects.get(i)).write(this.out);
                    }
                    this.out.flush();
                    reconnect = true;
                }
                catch (Exception e) {
                    this.socket = null;
                    throw e;
                }
            }
            String[] headers = this.in.readLine().split(" ");
            if (headers.length != 3) {
                this.socket = null;
                throw new IOException("Received invalid header.");
            }
            if (reconnect) {
                this.sessionID = headers[0];
            }
            if (!(msg = this.in.readLine()).equals("OK")) {
                throw new IOException(msg);
            }
        }
        finally {
            this.mutex.unlock();
        }
    }

    public void close() {
        this.mutex.lock();
        try {
            if (this.socket != null) {
                this.socket.close();
                this.sessionID = "";
                this.socket = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.mutex.unlock();
        }
    }

    private boolean isVariableCandidate(String word) {
        char cur = word.charAt(0);
        if (!(cur >= 'a' && cur <= 'z' || cur >= 'A' && cur <= 'Z')) {
            return false;
        }
        for (int i = 1; i < word.length(); ++i) {
            cur = word.charAt(i);
            if (cur >= 'a' && cur <= 'z' || cur >= 'A' && cur <= 'Z' || cur >= '0' && cur <= '9' || cur == '_') continue;
            return false;
        }
        return true;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }
}

