/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractEntity;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.Entity;
import com.xxdb.data.Matrix;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;

public abstract class AbstractMatrix
extends AbstractEntity
implements Matrix {
    private Vector rowLabels = null;
    private Vector columnLabels = null;
    protected int rows;
    protected int columns;
    protected static final int BUF_SIZE = 4096;
    protected byte[] buf = new byte[4096];

    protected abstract void readMatrixFromInputStream(int var1, int var2, ExtendedDataInput var3) throws IOException;

    protected abstract void writeVectorToOutputStream(ExtendedDataOutput var1) throws IOException;

    protected AbstractMatrix(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
    }

    protected AbstractMatrix(ExtendedDataInput in) throws IOException {
        int type;
        int type2;
        int form;
        short flag;
        byte hasLabels = in.readByte();
        BasicEntityFactory factory = null;
        Entity.DATA_TYPE[] types = Entity.DATA_TYPE.values();
        if (hasLabels > 0) {
            factory = new BasicEntityFactory();
        }
        if ((hasLabels & 1) == 1) {
            flag = in.readShort();
            form = flag >> 8;
            type2 = flag & 0xFF;
            if (form != Entity.DATA_FORM.DF_VECTOR.ordinal()) {
                throw new IOException("The form of matrix row labels must be vector");
            }
            if (type2 < 0 || type2 >= types.length) {
                throw new IOException("Invalid data type for matrix row labels: " + type2);
            }
            this.rowLabels = (Vector)factory.createEntity(Entity.DATA_FORM.DF_VECTOR, types[type2], in);
        }
        if ((hasLabels & 2) == 2) {
            flag = in.readShort();
            form = flag >> 8;
            type2 = flag & 0xFF;
            if (form != Entity.DATA_FORM.DF_VECTOR.ordinal()) {
                throw new IOException("The form of matrix columns labels must be vector");
            }
            if (type2 < 0 || type2 >= types.length) {
                throw new IOException("Invalid data type for matrix column labels: " + type2);
            }
            this.columnLabels = (Vector)factory.createEntity(Entity.DATA_FORM.DF_VECTOR, types[type2], in);
        }
        if ((type = (flag = in.readShort()) & 0xFF) < 0 || type >= types.length) {
            throw new IOException("Invalid data type for matrix: " + type);
        }
        this.rows = in.readInt();
        this.columns = in.readInt();
        this.readMatrixFromInputStream(this.rows, this.columns, in);
    }

    protected int getIndex(int row, int column) {
        return column * this.rows + row;
    }

    @Override
    public boolean hasRowLabel() {
        return this.rowLabels != null;
    }

    @Override
    public boolean hasColumnLabel() {
        return this.columnLabels != null;
    }

    @Override
    public Scalar getRowLabel(int index) {
        return this.rowLabels.get(index);
    }

    @Override
    public Scalar getColumnLabel(int index) {
        return this.columnLabels.get(index);
    }

    @Override
    public Vector getRowLabels() {
        return this.rowLabels;
    }

    public void setRowLabels(Vector vector) {
        if (vector.rows() != this.rows) {
            throw new IllegalArgumentException("the row label size doesn't equal to the row number of the matrix.");
        }
        this.rowLabels = vector;
    }

    @Override
    public Vector getColumnLabels() {
        return this.columnLabels;
    }

    public void setColumnLabels(Vector vector) {
        if (vector.rows() != this.columns) {
            throw new IllegalArgumentException("the column label size doesn't equal to the column number of the matrix.");
        }
        this.columnLabels = vector;
    }

    @Override
    public String getString() {
        int j;
        int curSize;
        int maxColWidth;
        int i;
        int rows = Math.min(20, this.rows());
        int limitColMaxWidth = 25;
        int length = 0;
        int curCol = 0;
        StringBuilder[] list = new StringBuilder[rows + 1];
        String[] listTmp = new String[rows + 1];
        for (i = 0; i < list.length; ++i) {
            list[i] = new StringBuilder();
        }
        if (this.rowLabels != null) {
            listTmp[0] = "";
            maxColWidth = 0;
            for (i = 0; i < rows; ++i) {
                listTmp[i + 1] = this.rowLabels.get(i).getString();
                if (listTmp[i + 1].length() <= maxColWidth) continue;
                maxColWidth = listTmp[i + 1].length();
            }
            ++maxColWidth;
            for (i = 0; i <= rows; ++i) {
                curSize = listTmp[i].length();
                if (curSize <= maxColWidth) {
                    list[i].append(listTmp[i]);
                    if (curSize >= maxColWidth) continue;
                    for (j = 0; j < maxColWidth - curSize; ++j) {
                        list[i].append(' ');
                    }
                    continue;
                }
                if (maxColWidth > 3) {
                    list[i].append(listTmp[i].substring(0, maxColWidth - 3));
                }
                list[i].append("...");
            }
            length += maxColWidth;
        }
        while (length < 100 && curCol < this.columns()) {
            listTmp[0] = this.columnLabels == null ? "#" + curCol : this.columnLabels.get(curCol).getString();
            maxColWidth = 0;
            for (i = 0; i < rows; ++i) {
                listTmp[i + 1] = this.get(i, curCol).getString();
                if (listTmp[i + 1].length() <= maxColWidth) continue;
                maxColWidth = listTmp[i + 1].length();
            }
            if (maxColWidth > limitColMaxWidth) {
                maxColWidth = limitColMaxWidth;
            }
            if (listTmp[0].length() > maxColWidth) {
                maxColWidth = Math.min(limitColMaxWidth, listTmp[0].length());
            }
            if (curCol < this.columns() - 1) {
                ++maxColWidth;
            }
            if (length + maxColWidth > 100 && curCol + 1 < this.columns()) break;
            for (i = 0; i <= rows; ++i) {
                curSize = listTmp[i].length();
                if (curSize <= maxColWidth) {
                    list[i].append(listTmp[i]);
                    if (curSize >= maxColWidth) continue;
                    for (j = 0; j < maxColWidth - curSize; ++j) {
                        list[i].append(' ');
                    }
                    continue;
                }
                if (maxColWidth > 3) {
                    list[i].append(listTmp[i].substring(0, maxColWidth - 3));
                }
                list[i].append("...");
            }
            length += maxColWidth;
            ++curCol;
        }
        if (curCol < this.columns) {
            for (i = 0; i <= rows; ++i) {
                list[i].append("...");
            }
        }
        StringBuilder resultStr = new StringBuilder();
        for (i = 0; i <= rows; ++i) {
            resultStr.append((CharSequence)list[i]);
            resultStr.append("\n");
        }
        if (rows < this.rows()) {
            resultStr.append("...\n");
        }
        return resultStr.toString();
    }

    @Override
    public Entity.DATA_FORM getDataForm() {
        return Entity.DATA_FORM.DF_MATRIX;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public int columns() {
        return this.columns;
    }

    @Override
    public void write(ExtendedDataOutput out) throws IOException {
        int flag = (Entity.DATA_FORM.DF_MATRIX.ordinal() << 8) + this.getDataType().ordinal();
        out.writeShort(flag);
        byte labelFlag = (byte)((this.hasRowLabel() ? 1 : 0) + (this.hasColumnLabel() ? 2 : 0));
        out.writeByte(labelFlag);
        if (this.hasRowLabel()) {
            this.rowLabels.write(out);
        }
        if (this.hasColumnLabel()) {
            this.columnLabels.write(out);
        }
        out.writeShort(flag);
        out.writeInt(this.rows());
        out.writeInt(this.columns());
        this.writeVectorToOutputStream(out);
    }
}

