/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.route;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicAnyVector;
import com.xxdb.data.Entity;
import com.xxdb.route.IntegralListPartitionedTableRouter;
import com.xxdb.route.IntegralRangePartitionedTableRouter;
import com.xxdb.route.IntegralValuePartitionedTableRouter;
import com.xxdb.route.LiteralListPartitionedTableRouter;
import com.xxdb.route.LiteralRangePartitionedTableRouter;
import com.xxdb.route.LiteralValuePartitionedTableRouter;
import com.xxdb.route.TableRouter;

public class TableRouterFacotry {
    public static TableRouter createRouter(Entity.PARTITION_TYPE type, AbstractVector values, BasicAnyVector locations) {
        if (type == Entity.PARTITION_TYPE.RANGE) {
            if (values.getDataCategory() == Entity.DATA_CATEGORY.INTEGRAL) {
                return new IntegralRangePartitionedTableRouter(values, locations);
            }
            if (values.getDataCategory() == Entity.DATA_CATEGORY.LITERAL) {
                return new LiteralRangePartitionedTableRouter(values, locations);
            }
        } else if (type == Entity.PARTITION_TYPE.VALUE) {
            if (values.getDataCategory() == Entity.DATA_CATEGORY.INTEGRAL) {
                return new IntegralValuePartitionedTableRouter(values, locations);
            }
            if (values.getDataCategory() == Entity.DATA_CATEGORY.LITERAL) {
                return new LiteralValuePartitionedTableRouter(values, locations);
            }
        } else if (type == Entity.PARTITION_TYPE.LIST) {
            BasicAnyVector schema = (BasicAnyVector)values;
            if (schema.getEntity(0).getDataCategory() == Entity.DATA_CATEGORY.INTEGRAL) {
                return new IntegralListPartitionedTableRouter(values, locations);
            }
            if (schema.getEntity(0).getDataCategory() == Entity.DATA_CATEGORY.LITERAL) {
                return new LiteralListPartitionedTableRouter(values, locations);
            }
        }
        throw new RuntimeException("Unsupported partition type " + type.toString());
    }
}

