/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractMatrix;
import com.xxdb.data.BasicInt;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class BasicIntMatrix
extends AbstractMatrix {
    private int[] values;

    public BasicIntMatrix(int rows, int columns) {
        super(rows, columns);
        this.values = new int[rows * columns];
    }

    public BasicIntMatrix(int rows, int columns, List<int[]> list) throws Exception {
        super(rows, columns);
        this.values = new int[rows * columns];
        if (list == null || list.size() != columns) {
            throw new Exception("input list of arrays does not have " + columns + " columns");
        }
        for (int i = 0; i < columns; ++i) {
            int[] array = list.get(i);
            if (array == null || array.length != rows) {
                throw new Exception("The length of array " + (i + 1) + " doesn't have " + rows + " elements");
            }
            System.arraycopy(array, 0, this.values, i * rows, rows);
        }
    }

    public BasicIntMatrix(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public void setInt(int row, int column, int value) {
        this.values[this.getIndex((int)row, (int)column)] = value;
    }

    public int getInt(int row, int column) {
        return this.values[this.getIndex(row, column)];
    }

    @Override
    public boolean isNull(int row, int column) {
        return this.values[this.getIndex(row, column)] == Integer.MIN_VALUE;
    }

    @Override
    public void setNull(int row, int column) {
        this.values[this.getIndex((int)row, (int)column)] = Integer.MIN_VALUE;
    }

    @Override
    public Scalar get(int row, int column) {
        return new BasicInt(this.values[this.getIndex(row, column)]);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.INTEGRAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_INT;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicInt.class;
    }

    @Override
    protected void readMatrixFromInputStream(int rows, int columns, ExtendedDataInput in) throws IOException {
        int len;
        ByteOrder bo;
        int size = rows * columns;
        this.values = new int[size];
        int totalBytes = size * 4;
        ByteOrder byteOrder = bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        for (int off = 0; off < totalBytes; off += len) {
            len = Math.min(4096, totalBytes - off);
            in.readFully(this.buf, 0, len);
            int start = off / 4;
            int end = len / 4;
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getInt(i * 4);
            }
        }
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        for (int value : this.values) {
            out.writeInt(value);
        }
    }
}

