/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicInt;
import com.xxdb.data.Entity;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.Month;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;

public class BasicMonth
extends BasicInt {
    private static DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy.MM'M'");

    public BasicMonth(int year, Month month) {
        super(year * 12 + month.getValue());
    }

    public BasicMonth(YearMonth value) {
        super(value.getYear() * 12 + value.getMonthValue() - 1);
    }

    public BasicMonth(ExtendedDataInput in) throws IOException {
        super(in);
    }

    protected BasicMonth(int value) {
        super(value);
    }

    public YearMonth getMonth() {
        if (this.isNull()) {
            return null;
        }
        return Utils.parseMonth(this.getInt());
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_MONTH;
    }

    @Override
    public Temporal getTemporal() throws Exception {
        return this.getMonth();
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        return this.getMonth().format(format);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BasicMonth) || o == null) {
            return false;
        }
        return this.getInt() == ((BasicMonth)o).getInt();
    }
}

