/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.streaming.client;

import com.xxdb.streaming.client.MessageDispatcher;
import com.xxdb.streaming.client.MessageParser;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

class Daemon
implements Runnable {
    private int listeningPort = 0;
    private MessageDispatcher dispatcher;
    private static final int KEEPALIVE_IDLE = 30000;
    private static final int KEEPALIVE_INTERVAL = 5000;
    private static final int KEEPALIVE_COUNT = 3;

    public Daemon(int port, MessageDispatcher dispatcher) {
        this.listeningPort = port;
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ServerSocket ssocket = null;
        try {
            try {
                ssocket = new ServerSocket(this.listeningPort);
                while (true) {
                    Socket socket = ssocket.accept();
                    socket.setKeepAlive(true);
                    MessageParser listener = new MessageParser(socket, this.dispatcher);
                    Thread listeningThread = new Thread(listener);
                    listeningThread.start();
                    if (System.getProperty("os.name").equalsIgnoreCase("linux")) continue;
                    new Thread(new ConnectionDetector(socket)).start();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (ssocket != null) {
                    try {
                        ssocket.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (ssocket != null) {
                try {
                    ssocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            throw throwable;
        }
    }

    class ConnectionDetector
    implements Runnable {
        Socket socket = null;

        public ConnectionDetector(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    this.socket.sendUrgentData(255);
                }
                catch (Exception ex) {
                    int failCount = 0;
                    for (int i = 0; i < 3; ++i) {
                        try {
                            this.socket.sendUrgentData(255);
                        }
                        catch (Exception ex0) {
                            ++failCount;
                        }
                        try {
                            Thread.sleep(5000L);
                            continue;
                        }
                        catch (Exception ex1) {
                            ex.printStackTrace();
                        }
                    }
                    if (failCount != 3) continue;
                    try {
                        this.socket.close();
                        return;
                    }
                    catch (Exception e) {
                        return;
                    }
                }
                try {
                    Thread.sleep(30000L);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

