/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.streaming.client;

import com.xxdb.streaming.client.IMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class TopicPoller {
    BlockingQueue<List<IMessage>> queue;
    ArrayList<IMessage> cache = null;

    public TopicPoller(BlockingQueue<List<IMessage>> queue) {
        this.queue = queue;
    }

    public void setQueue(BlockingQueue<List<IMessage>> queue) {
        this.queue = queue;
    }

    private void fillCache(long timeout) {
        assert (this.cache == null);
        List<IMessage> list = null;
        if (this.cache == null) {
            try {
                list = timeout >= 0L ? this.queue.poll(timeout, TimeUnit.MILLISECONDS) : this.queue.take();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (list != null) {
            this.cache = new ArrayList(list.size());
            this.cache.addAll(list);
        }
    }

    public ArrayList<IMessage> poll(long timeout) {
        if (this.cache == null) {
            this.fillCache(timeout);
        }
        ArrayList<IMessage> cachedMessages = this.cache;
        this.cache = null;
        return cachedMessages;
    }

    public IMessage take() {
        if (this.cache == null) {
            this.fillCache(-1L);
        }
        return this.cache.remove(0);
    }
}

