/*
 * Decompiled with CFR 0.152.
 */
package com.dream.struct.factory;

import com.dream.antlr.smt.DeleteStatement;
import com.dream.antlr.smt.InsertStatement;
import com.dream.antlr.smt.QueryStatement;
import com.dream.antlr.smt.Statement;
import com.dream.antlr.smt.UpdateStatement;
import com.dream.struct.command.Delete;
import com.dream.struct.command.Insert;
import com.dream.struct.command.Query;
import com.dream.struct.command.Update;
import com.dream.system.config.Command;
import com.dream.system.config.MappedStatement;
import com.dream.system.config.MethodInfo;

public interface StructFactory {
    default public MappedStatement compile(Query query, MethodInfo methodInfo) {
        return this.compile(Command.QUERY, (Statement)query.statement(), methodInfo);
    }

    default public MappedStatement compile(Update update, MethodInfo methodInfo) {
        return this.compile(Command.UPDATE, (Statement)update.statement(), methodInfo);
    }

    default public MappedStatement compile(Insert insert, MethodInfo methodInfo) {
        return this.compile(Command.INSERT, (Statement)insert.statement(), methodInfo);
    }

    default public MappedStatement compile(Delete delete, MethodInfo methodInfo) {
        return this.compile(Command.DELETE, (Statement)delete.statement(), methodInfo);
    }

    default public MappedStatement compile(Statement statement, MethodInfo methodInfo) {
        if (statement instanceof QueryStatement) {
            return this.compile(Command.QUERY, statement, methodInfo);
        }
        if (statement instanceof UpdateStatement) {
            return this.compile(Command.UPDATE, statement, methodInfo);
        }
        if (statement instanceof InsertStatement) {
            return this.compile(Command.INSERT, statement, methodInfo);
        }
        if (statement instanceof DeleteStatement) {
            return this.compile(Command.DELETE, statement, methodInfo);
        }
        return this.compile(Command.NONE, statement, methodInfo);
    }

    public MappedStatement compile(Command var1, Statement var2, MethodInfo var3);
}

