/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.context;

import com.dynamic.sql.context.properties.SchemaProperties;
import com.dynamic.sql.context.properties.SqlContextProperties;
import com.dynamic.sql.core.SqlContext;
import com.dynamic.sql.datasource.DataSourceUtils;
import com.dynamic.sql.mapper.MapperScanner;
import com.dynamic.sql.table.TableUtils;
import com.dynamic.sql.utils.CollectionUtils;
import com.dynamic.sql.utils.StringUtils;
import java.util.List;

public class SqlContextConfigurer {
    private final SqlContextProperties sqlContextProperties;
    private final SqlContext sqlContext;

    protected SqlContextConfigurer(SqlContextProperties sqlContextProperties, SqlContext sqlContext) {
        this.sqlContextProperties = sqlContextProperties;
        this.sqlContext = sqlContext;
    }

    protected SqlContextConfigurer(SqlContext sqlContext) {
        this.sqlContextProperties = SqlContextProperties.defaultSqlContextProperties();
        this.sqlContext = sqlContext;
    }

    protected void initializeContext() {
        this.validateProperty();
        DataSourceUtils.scanAndInitDataSource(this.sqlContextProperties);
        TableUtils.scanAndInitTable(this.sqlContextProperties.getScanTablePackage());
        TableUtils.scanAndInitCTETableInfo(this.sqlContextProperties.getScanTablePackage());
        TableUtils.scanAndInitViewInfo(this.sqlContextProperties.getScanTablePackage());
        MapperScanner.scanAndInitMapper(this.sqlContextProperties.getScanMapperPackage(), this.getSqlContext());
    }

    private void validateProperty() {
        if (this.sqlContextProperties == null) {
            throw new IllegalArgumentException("sqlContextProperties must not null");
        }
        if (this.sqlContext == null) {
            throw new IllegalArgumentException("sqlContext must not null");
        }
        List<SchemaProperties> schemaProperties = this.sqlContextProperties.getSchemaProperties();
        if (CollectionUtils.isNotEmpty(schemaProperties)) {
            for (SchemaProperties schemaProperty : schemaProperties) {
                if (!StringUtils.isEmpty(schemaProperty.getDataSourceName())) continue;
                throw new IllegalArgumentException("When setting a specific named data source configuration, you need to specify the data source name");
            }
        }
    }

    public SqlContext getSqlContext() {
        return this.sqlContext;
    }

    public SqlContextProperties getSqlContextProperties() {
        return this.sqlContextProperties;
    }
}

