/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.context.properties;

import com.dynamic.sql.context.properties.SchemaProperties;
import com.dynamic.sql.interceptor.SqlInterceptor;
import com.dynamic.sql.plugins.schema.DbSchemaMatcher;
import com.dynamic.sql.plugins.schema.impl.MysqlSchemaMatcher;
import com.dynamic.sql.plugins.schema.impl.OracleSchemaMatcher;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class SqlContextProperties {
    private String[] scanDatabasePackage;
    private String[] scanTablePackage;
    private String[] scanMapperPackage;
    private Set<DbSchemaMatcher> schemaMatchers = new LinkedHashSet<DbSchemaMatcher>();
    private List<SchemaProperties> schemaProperties = new ArrayList<SchemaProperties>();
    private List<SqlInterceptor> interceptors = new ArrayList<SqlInterceptor>();
    private boolean allowDataSourceDefinitionOverriding;

    public static SqlContextProperties defaultSqlContextProperties() {
        SqlContextProperties sqlContextProperties = new SqlContextProperties();
        LinkedHashSet<DbSchemaMatcher> dbSchemaMatchers = new LinkedHashSet<DbSchemaMatcher>();
        dbSchemaMatchers.add(new MysqlSchemaMatcher());
        dbSchemaMatchers.add(new OracleSchemaMatcher());
        sqlContextProperties.setSchemaMatchers(dbSchemaMatchers);
        return sqlContextProperties;
    }

    public String[] getScanDatabasePackage() {
        return this.scanDatabasePackage;
    }

    public void setScanDatabasePackage(String ... scanDatabasePackage) {
        this.scanDatabasePackage = scanDatabasePackage;
    }

    public String[] getScanTablePackage() {
        return this.scanTablePackage;
    }

    public void setScanTablePackage(String ... scanTablePackage) {
        this.scanTablePackage = scanTablePackage;
    }

    public String[] getScanMapperPackage() {
        return this.scanMapperPackage;
    }

    public void setScanMapperPackage(String ... scanMapperPackage) {
        this.scanMapperPackage = scanMapperPackage;
    }

    public Set<DbSchemaMatcher> getSchemaMatchers() {
        return this.schemaMatchers;
    }

    public void setSchemaMatchers(Set<DbSchemaMatcher> schemaMatchers) {
        this.schemaMatchers = schemaMatchers;
    }

    public List<SchemaProperties> getSchemaProperties() {
        return this.schemaProperties;
    }

    public void addSchemaProperties(SchemaProperties schemaProperties) {
        this.schemaProperties.add(schemaProperties);
    }

    public List<SqlInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public boolean isAllowDataSourceDefinitionOverriding() {
        return this.allowDataSourceDefinitionOverriding;
    }

    public void setAllowDataSourceDefinitionOverriding(boolean allowDataSourceDefinitionOverriding) {
        this.allowDataSourceDefinitionOverriding = allowDataSourceDefinitionOverriding;
    }

    public void addInterceptor(SqlInterceptor interceptor) {
        if (this.interceptors.contains(interceptor)) {
            return;
        }
        this.interceptors.add(interceptor);
    }
}

