/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.condition.impl.dialect;

import com.dynamic.sql.core.Fn;
import com.dynamic.sql.core.Version;
import com.dynamic.sql.core.column.function.ColumFunction;
import com.dynamic.sql.core.condition.impl.dialect.GenericWhereCondition;
import com.dynamic.sql.enums.LogicalOperatorType;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.model.TableAliasMapping;
import com.dynamic.sql.utils.SqlUtils;
import java.util.Map;

public class OracleWhereCondition
extends GenericWhereCondition {
    public OracleWhereCondition(Version version, Map<String, TableAliasMapping> aliasTableMap, String dataSourceName) {
        super(version, aliasTableMap, dataSourceName);
    }

    @Override
    protected SqlDialect sqlDialect() {
        return SqlDialect.ORACLE;
    }

    @Override
    public <T, F> GenericWhereCondition andMatches(Fn<T, F> fn, String regex) {
        return this.matches(LogicalOperatorType.AND, fn, regex);
    }

    @Override
    public <T, F> GenericWhereCondition orMatches(Fn<T, F> fn, String regex) {
        return this.matches(LogicalOperatorType.OR, fn, regex);
    }

    public <T, F> GenericWhereCondition matches(LogicalOperatorType logicalOperatorType, Fn<T, F> fn, String regex) {
        String column = SqlUtils.extractQualifiedAlias(fn, (Map<String, TableAliasMapping>)this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append((Object)logicalOperatorType);
        this.condition.append(" REGEXP_LIKE(").append(column).append(", ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, regex)).append(")");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andMatches(Fn<T, F> fn, ColumFunction columFunction) {
        return this.matchesFunction(LogicalOperatorType.AND, fn, columFunction);
    }

    @Override
    public <T, F> GenericWhereCondition orMatches(Fn<T, F> fn, ColumFunction columFunction) {
        return this.matchesFunction(LogicalOperatorType.OR, fn, columFunction);
    }

    public <T, F> GenericWhereCondition matchesFunction(LogicalOperatorType logicalOperatorType, Fn<T, F> fn, ColumFunction columFunction) {
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        String column = SqlUtils.extractQualifiedAlias(fn, (Map<String, TableAliasMapping>)this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append((Object)logicalOperatorType);
        this.condition.append(" REGEXP_LIKE(").append(column).append(", ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, columFunction.getFunctionToString(this.sqlDialect(), this.version, this.aliasTableMap))).append(")");
        return this;
    }
}

