/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.dml.select.build;

import com.dynamic.sql.context.SchemaContextHolder;
import com.dynamic.sql.context.properties.SchemaProperties;
import com.dynamic.sql.core.Fn;
import com.dynamic.sql.core.Version;
import com.dynamic.sql.core.column.function.ColumFunction;
import com.dynamic.sql.core.condition.WhereCondition;
import com.dynamic.sql.core.condition.impl.dialect.GenericWhereCondition;
import com.dynamic.sql.core.dml.select.HavingCondition;
import com.dynamic.sql.core.dml.select.NestedMeta;
import com.dynamic.sql.core.dml.select.build.SelectSpecification;
import com.dynamic.sql.core.dml.select.build.SqlStatementSelectWrapper;
import com.dynamic.sql.core.dml.select.build.join.FromNestedJoin;
import com.dynamic.sql.core.dml.select.build.join.JoinTable;
import com.dynamic.sql.core.dml.select.build.join.NestedJoin;
import com.dynamic.sql.core.dml.select.build.join.TableFunctionJoin;
import com.dynamic.sql.core.dml.select.order.NullsFirst;
import com.dynamic.sql.core.dml.select.order.NullsLast;
import com.dynamic.sql.core.dml.select.order.OrderBy;
import com.dynamic.sql.core.placeholder.ParameterBinder;
import com.dynamic.sql.datasource.DataSourceProvider;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.model.TableAliasMapping;
import com.dynamic.sql.table.TableMeta;
import com.dynamic.sql.table.TableProvider;
import com.dynamic.sql.utils.CollectionUtils;
import com.dynamic.sql.utils.SqlUtils;
import com.dynamic.sql.utils.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public abstract class SqlSelectBuilder {
    protected final StringBuilder sqlBuilder = new StringBuilder();
    protected final SelectSpecification selectSpecification;
    protected final Version version;
    protected final SqlDialect sqlDialect;
    protected final String dataSourceName;
    protected final ParameterBinder parameterBinder = new ParameterBinder();
    protected final Map<String, TableAliasMapping> aliasTableMap = new HashMap<String, TableAliasMapping>();
    private Boolean isFromNestedSelect;

    protected <C extends WhereCondition<C>> SqlSelectBuilder(SelectSpecification selectSpecification) {
        SchemaProperties schemaProperties;
        this.selectSpecification = selectSpecification;
        NestedMeta nestedMeta = selectSpecification.getNestedMeta();
        if (nestedMeta != null) {
            this.version = nestedMeta.getVersion();
            this.sqlDialect = nestedMeta.getSqlDialect();
            this.dataSourceName = nestedMeta.getDataSourceName();
            return;
        }
        JoinTable joinTable = selectSpecification.getJoinTables().get(0);
        if (joinTable instanceof FromNestedJoin) {
            FromNestedJoin fromNestedJoin = (FromNestedJoin)joinTable;
            SqlStatementSelectWrapper sqlStatementWrapper = fromNestedJoin.getNestedJoin().getSqlStatementWrapper();
            String dataSourceName1 = sqlStatementWrapper.getDataSourceName();
            schemaProperties = SchemaContextHolder.getSchemaProperties(dataSourceName1);
        } else {
            Class<?> tableClass = joinTable.getTableClass();
            TableMeta tableMeta = TableProvider.getTableMeta(tableClass);
            schemaProperties = SchemaContextHolder.getSchemaProperties(tableMeta.getBindDataSourceName());
        }
        this.version = this.getVersion(schemaProperties);
        this.sqlDialect = schemaProperties.getSqlDialect();
        this.dataSourceName = schemaProperties.getDataSourceName();
    }

    protected abstract void parseColumnFunction();

    protected abstract boolean parseFormTables();

    protected abstract void parseLimit();

    public final SqlStatementSelectWrapper build(Class<?> returnClass) {
        List<JoinTable> joinTables = this.selectSpecification.getJoinTables();
        joinTables.forEach(joinTable -> {
            String key;
            if (joinTable instanceof FromNestedJoin || joinTable instanceof NestedJoin || joinTable instanceof TableFunctionJoin || joinTable.getTableFunction() != null) {
                key = joinTable.getTableAlias();
                this.isFromNestedSelect = Boolean.TRUE;
            } else {
                key = joinTable.getTableClass().getCanonicalName();
            }
            TableAliasMapping alias = this.aliasTableMap.get(key);
            if (alias == null) {
                TableAliasMapping aliasMapping = new TableAliasMapping();
                aliasMapping.setAlias(joinTable.getTableAlias());
                aliasMapping.setIsNestedJoin(joinTable instanceof NestedJoin || joinTable instanceof FromNestedJoin);
                this.aliasTableMap.put(key, aliasMapping);
            }
        });
        this.parseColumnFunction();
        this.sqlBuilder.append(" ");
        this.sqlBuilder.append(SqlUtils.getSyntaxFrom(this.sqlDialect)).append(" ");
        if (this.parseFormTables()) {
            JoinTable guessTheTarget;
            if (returnClass == null && (guessTheTarget = (JoinTable)joinTables.stream().filter(joinTable -> joinTable.getTableClass() != null).findFirst().orElse(null)) != null) {
                returnClass = guessTheTarget.getTableClass();
            }
            this.continueParsingSql(returnClass);
        }
        return new SqlStatementSelectWrapper(this.dataSourceName, this.sqlBuilder, this.parameterBinder, returnClass);
    }

    protected void continueParsingSql(Class<?> returnClass) {
        if (this.selectSpecification.getWhereCondition() != null) {
            Consumer<GenericWhereCondition> whereCondition = this.selectSpecification.getWhereCondition();
            this.parseWhere(whereCondition);
        }
        if (CollectionUtils.isNotEmpty(this.selectSpecification.getGroupByObject().getGroupByList())) {
            this.parseGroupBy(this.selectSpecification.getGroupByObject().getGroupByList());
        }
        if (this.selectSpecification.getHavingCondition() != null) {
            this.parseHaving(this.selectSpecification.getHavingCondition());
        }
        if (CollectionUtils.isNotEmpty(this.selectSpecification.getOrderBys())) {
            this.sqlBuilder.append(this.parseOrderBy(this.selectSpecification.getOrderBys(), returnClass));
        }
        if (this.selectSpecification.getLimitInfo() != null) {
            this.parseLimit();
        }
    }

    private void parseGroupBy(List<Object> groupByFields) {
        this.sqlBuilder.append(" ").append(SqlUtils.getSyntaxGroupBy(this.sqlDialect));
        for (int i = 0; i < groupByFields.size(); ++i) {
            Object group;
            if (i == 0) {
                this.sqlBuilder.append(" ");
            }
            if ((group = groupByFields.get(i)) instanceof Fn) {
                this.sqlBuilder.append(SqlUtils.extractQualifiedAlias((Fn)group, this.aliasTableMap, this.dataSourceName));
            }
            if (group instanceof ColumFunction) {
                ColumFunction columFunction = (ColumFunction)group;
                this.sqlBuilder.append(columFunction.getFunctionToString(this.sqlDialect, this.version, this.aliasTableMap));
                ParameterBinder whereParameterBinder = columFunction.getParameterBinder();
                this.parameterBinder.addParameterBinder(whereParameterBinder);
            }
            if (i >= groupByFields.size() - 1) continue;
            this.sqlBuilder.append(", ");
        }
    }

    private void parseHaving(Consumer<HavingCondition<GenericWhereCondition>> havingCondition) {
        Object whereCondition = SqlUtils.matchDialectCondition(this.sqlDialect, this.version, this.aliasTableMap, this.dataSourceName);
        havingCondition.accept((HavingCondition<GenericWhereCondition>)whereCondition);
        this.sqlBuilder.append(" ").append(SqlUtils.getSyntaxHaving(this.sqlDialect)).append(" ").append(((GenericWhereCondition)whereCondition).getWhereConditionSyntax());
        ParameterBinder whereParameterBinder = ((GenericWhereCondition)whereCondition).getParameterBinder();
        this.parameterBinder.addParameterBinder(whereParameterBinder);
    }

    protected String parseOrderBy(List<OrderBy> orderBys, Class<?> returnClass) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" ").append(SqlUtils.getSyntaxOrderBy(this.sqlDialect));
        for (int i = 0; i < orderBys.size(); ++i) {
            OrderBy orderBy = orderBys.get(i);
            String columnSeparator = "";
            if (orderBys.size() - 1 != i) {
                columnSeparator = ",";
            }
            String sort = orderBy.getSortOrder() != null ? orderBy.getSortOrder().toSqlString(this.sqlDialect) : "";
            String aliasOrderBy = SqlUtils.extractQualifiedAliasOrderBy(orderBy, this.aliasTableMap, this.dataSourceName, this.version, this.parameterBinder, this.isFromNestedSelect, returnClass);
            stringBuilder.append(aliasOrderBy).append(" ");
            if (i < orderBys.size() - 1) {
                OrderBy nextOrderBy = orderBys.get(i + 1);
                if (nextOrderBy instanceof NullsFirst) {
                    stringBuilder.append(" is not null, ").append(aliasOrderBy).append(" ");
                    ++i;
                }
                if (nextOrderBy instanceof NullsLast) {
                    stringBuilder.append(" is null, ").append(aliasOrderBy).append(" ");
                    ++i;
                }
            }
            stringBuilder.append(sort);
            if (i >= orderBys.size() - 1) continue;
            stringBuilder.append(columnSeparator);
        }
        return stringBuilder.toString();
    }

    private void parseWhere(Consumer<GenericWhereCondition> whereConditionConsumer) {
        Object whereCondition = SqlUtils.matchDialectCondition(this.sqlDialect, this.version, this.aliasTableMap, this.dataSourceName);
        whereConditionConsumer.accept((GenericWhereCondition)whereCondition);
        String whereConditionSyntax = ((GenericWhereCondition)whereCondition).getWhereConditionSyntax();
        if (StringUtils.isNotEmpty(whereConditionSyntax) && !whereConditionSyntax.trim().startsWith("limit")) {
            this.sqlBuilder.append(" ").append(SqlUtils.getSyntaxWhere(this.sqlDialect));
        }
        this.sqlBuilder.append(" ").append(whereConditionSyntax);
        ParameterBinder whereParameterBinder = ((GenericWhereCondition)whereCondition).getParameterBinder();
        this.parameterBinder.addParameterBinder(whereParameterBinder);
    }

    private Version getVersion(SchemaProperties schemaProperties) {
        return new Version(schemaProperties.getMajorVersionNumber(), schemaProperties.getMinorVersionNumber(), schemaProperties.getPatchVersionNumber());
    }

    protected String getSchemaTableFullName(TableMeta tableMeta) {
        SchemaProperties schemaProperties = SchemaContextHolder.getSchemaProperties(tableMeta.getBindDataSourceName());
        if (schemaProperties.isUseSchemaInQuery()) {
            String schema = StringUtils.isEmpty(tableMeta.getSchema()) ? DataSourceProvider.getDataSourceMeta(tableMeta.getBindDataSourceName()).getSchema() : tableMeta.getSchema();
            return SqlUtils.quoteIdentifier(this.sqlDialect, schema) + "." + SqlUtils.quoteIdentifier(this.sqlDialect, tableMeta.getTableName());
        }
        return SqlUtils.quoteIdentifier(this.sqlDialect, tableMeta.getTableName());
    }

    protected String syntaxAs() {
        SchemaProperties schemaProperties = SchemaContextHolder.getSchemaProperties(this.dataSourceName);
        return schemaProperties.isUseAsInQuery() ? " " + SqlUtils.getSyntaxAs(this.sqlDialect) + " " : " ";
    }

    protected String syntaxColumnAlias(String columnAlias) {
        if (this.sqlDialect == SqlDialect.ORACLE) {
            return "\"" + columnAlias + "\"";
        }
        return columnAlias;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }
}

