/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.mapper;

import com.dynamic.sql.core.SqlContext;
import com.dynamic.sql.mapper.EntityMapper;
import com.dynamic.sql.mapper.EntityMapperProxy;
import com.dynamic.sql.mapper.MapperRegistry;
import com.dynamic.sql.utils.ReflectUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MapperProxyFactory {
    private static final Map<String, Method> SQL_CONTEXT_METHOD_CACHE = new ConcurrentHashMap<String, Method>();
    private static final LinkedHashSet<String> ENTITY_MAPPER_METHOD_NAME = new LinkedHashSet();
    private static final Map<Class<EntityMapper<?>>, MapperRegistry<?>> ENTITY_MAPPER_CLASS_CACHE = new ConcurrentHashMap();
    private static SqlContext sqlContext;

    private MapperProxyFactory() {
    }

    public static <T> MapperRegistry<T> getMapperRegistry(Class<EntityMapper<?>> entityMapperClass) {
        return ENTITY_MAPPER_CLASS_CACHE.get(entityMapperClass);
    }

    public static List<MapperRegistry<?>> getMapperRegistrys() {
        return new ArrayList(ENTITY_MAPPER_CLASS_CACHE.values());
    }

    public static <T, M extends EntityMapper<T>> M loadMapper(Class<M> mapperClass) {
        MapperRegistry<?> mapperRegistry = ENTITY_MAPPER_CLASS_CACHE.get(mapperClass);
        if (mapperRegistry != null) {
            return (M)mapperRegistry.getProxyMapper();
        }
        List<Class<?>> genericTypes = ReflectUtils.getGenericTypes(mapperClass, EntityMapper.class);
        if (genericTypes.isEmpty()) {
            throw new IllegalArgumentException("Entity type must be specified in Mapper generics.");
        }
        Class<?> entityClass = genericTypes.get(0);
        EntityMapper<T> entityMapper = MapperProxyFactory.createMapper(mapperClass);
        ENTITY_MAPPER_CLASS_CACHE.put(mapperClass, new MapperRegistry<T>(entityMapper, entityClass));
        return (M)entityMapper;
    }

    public static <T, M extends EntityMapper<T>> EntityMapper<T> createMapper(Class<M> mapperClass) {
        return (EntityMapper)Proxy.newProxyInstance(mapperClass.getClassLoader(), new Class[]{mapperClass}, (InvocationHandler)new EntityMapperProxy());
    }

    public static SqlContext getSqlContext() {
        return sqlContext;
    }

    public static Method getSqlContextMethod(String methodSignature) {
        return SQL_CONTEXT_METHOD_CACHE.get(methodSignature);
    }

    public static void setSqlContext(SqlContext sqlContext) {
        if (!SQL_CONTEXT_METHOD_CACHE.isEmpty()) {
            return;
        }
        MapperProxyFactory.sqlContext = sqlContext;
        Method[] methods = sqlContext.getClass().getMethods();
        List<String> methodTypes = Arrays.asList("delete", "insert", "upsert", "update", "select");
        for (Method m : methods) {
            for (String methodType : methodTypes) {
                if (!m.getName().startsWith(methodType)) continue;
                SQL_CONTEXT_METHOD_CACHE.put(MapperProxyFactory.getMethodSignature(m, null), m);
            }
        }
    }

    public static void initEntityMapperMethod() {
        if (!ENTITY_MAPPER_METHOD_NAME.isEmpty()) {
            return;
        }
        Method[] methods = EntityMapper.class.getMethods();
        List<String> methodTypes = Arrays.asList("delete", "insert", "upsert", "update", "select");
        for (Method m : methods) {
            for (String methodType : methodTypes) {
                if (!m.getName().startsWith(methodType)) continue;
                ENTITY_MAPPER_METHOD_NAME.add(m.getName());
            }
        }
    }

    public static LinkedHashSet<String> getEntityMapperMethodNames() {
        return ENTITY_MAPPER_METHOD_NAME;
    }

    public static String getMethodSignature(Method method, String paramClassType) {
        StringBuilder signature = new StringBuilder(method.getName());
        if (paramClassType != null) {
            signature.append("#").append(paramClassType);
        }
        for (Class<?> paramType : method.getParameterTypes()) {
            signature.append("#").append(paramType.getName());
        }
        return signature.toString();
    }
}

