/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.mapper;

import com.dynamic.sql.core.SqlContext;
import com.dynamic.sql.mapper.EntityMapper;
import com.dynamic.sql.mapper.MapperProxyFactory;
import java.util.Set;
import java.util.function.Predicate;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperScanner {
    private static final Logger log = LoggerFactory.getLogger(MapperScanner.class);

    private MapperScanner() {
    }

    public static void scanAndInitMapper(String[] scanMapperPackage, SqlContext sqlContext) {
        if (scanMapperPackage == null) {
            return;
        }
        for (String forPackage : scanMapperPackage) {
            log.debug("Find the mapper based on the provided '{}' path. ", (Object)forPackage);
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)forPackage, (ClassLoader[])new ClassLoader[0])).filterInputsBy((Predicate)new FilterBuilder().includePackage(forPackage)).setScanners(new Scanner[]{Scanners.SubTypes}));
            Set allClasses = reflections.getSubTypesOf(EntityMapper.class);
            for (Class mapperClass : allClasses) {
                MapperProxyFactory.loadMapper(mapperClass);
            }
        }
        MapperProxyFactory.setSqlContext(sqlContext);
        MapperProxyFactory.initEntityMapperMethod();
    }
}

