/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.plugins.exception;

import com.dynamic.sql.core.database.PreparedSql;
import com.dynamic.sql.core.dml.SqlStatementWrapper;
import com.dynamic.sql.interceptor.ExecutionControl;
import com.dynamic.sql.interceptor.SqlInterceptor;
import com.dynamic.sql.plugins.exception.SqlErrorHint;
import com.dynamic.sql.utils.MapUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionPlugin
implements SqlInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ExceptionPlugin.class);
    private final SqlErrorHint sqlErrorHint;

    public ExceptionPlugin(SqlErrorHint sqlErrorHint) {
        this.sqlErrorHint = sqlErrorHint;
    }

    @Override
    public ExecutionControl beforeExecution(SqlStatementWrapper sqlStatementWrapper, Connection connection) {
        return ExecutionControl.PROCEED;
    }

    @Override
    public void afterExecution(PreparedSql preparedSql, Object applyResult, Exception exception) {
        String sql;
        if (exception == null) {
            return;
        }
        String string = sql = preparedSql == null ? null : preparedSql.getSql();
        if (exception instanceof SQLException) {
            this.fillSqlExceptionDescription(sql, (SQLException)exception);
            return;
        }
        for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof SQLException)) continue;
            this.fillSqlExceptionDescription(sql, (SQLException)cause);
            return;
        }
    }

    private void fillSqlExceptionDescription(String sql, SQLException sqlException) {
        Map<String, String> errorHints = this.sqlErrorHint.getErrorHints();
        if (MapUtils.isEmpty(errorHints)) {
            return;
        }
        String sqlState = sqlException.getSQLState();
        int errorCode = sqlException.getErrorCode();
        String errorHintMsg = errorHints.get(sqlState);
        if (errorHintMsg != null) {
            if (sql != null) {
                log.error("{}, \u539f\u56e0\uff1a{}\uff0c\u53c2\u8003SQL: {}", new Object[]{errorHintMsg, sqlException.getMessage(), sql});
            } else {
                log.error("{}, \u539f\u56e0\uff1a{}", (Object)errorHintMsg, (Object)sqlException.getMessage());
            }
            return;
        }
        if (sql != null) {
            log.error("SQL\u6267\u884c\u5931\u8d25\uff01errorCode: {}, \u539f\u56e0\uff1a{}\uff0c\u53c2\u8003SQL: {}", new Object[]{errorCode, sqlException.getMessage(), sql});
        } else {
            log.error("SQL\u6267\u884c\u5931\u8d25\uff01errorCode: {}, \u539f\u56e0\uff1a{}", (Object)errorCode, (Object)sqlException.getMessage());
        }
    }

    @Override
    public int getOrder() {
        return -666;
    }
}

