/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.plugins.pagination.impl;

import com.dynamic.sql.core.Version;
import com.dynamic.sql.core.dml.SqlStatementWrapper;
import com.dynamic.sql.core.placeholder.ParameterBinder;
import com.dynamic.sql.plugins.pagination.AbstractPage;
import com.dynamic.sql.plugins.pagination.DialectPagination;
import com.dynamic.sql.utils.SqlUtils;

public class OracleDialectPagination
implements DialectPagination {
    @Override
    public StringBuilder selectCountSql(Version version, SqlStatementWrapper sqlStatementWrapper, AbstractPage abstractPage) {
        StringBuilder selectCountSql = new StringBuilder(sqlStatementWrapper.getRawSql());
        selectCountSql.insert(0, "SELECT COUNT(1) FROM (");
        selectCountSql.append(") COUNT_PAGE_TEMP ");
        return selectCountSql;
    }

    @Override
    public void modifyPagingSql(Version version, SqlStatementWrapper sqlStatementWrapper, AbstractPage abstractPage) {
        if (version.isGreaterThanOrEqual(new Version(12, 0, 0))) {
            this.offsetAndFetch(sqlStatementWrapper, abstractPage.getPageIndex(), abstractPage.getPageSize());
            return;
        }
        this.rowNumPage(sqlStatementWrapper, abstractPage.getPageIndex(), abstractPage.getPageSize());
    }

    private void offsetAndFetch(SqlStatementWrapper sqlStatementWrapper, int pageIndex, int pageSize) {
        int offset = (pageIndex - 1) * pageSize;
        ParameterBinder parameterBinder = sqlStatementWrapper.getParameterBinder();
        String offsetKey = SqlUtils.registerValueWithKey(parameterBinder, offset);
        String pageSizeKey = SqlUtils.registerValueWithKey(parameterBinder, pageSize);
        StringBuilder pagingSql = sqlStatementWrapper.getRawSql();
        pagingSql.insert(0, "SELECT * FROM (");
        pagingSql.append(") OFFSET ").append(offsetKey).append(" ROWS FETCH NEXT ").append(pageSizeKey).append(" ROWS ONLY");
    }

    private void rowNumPage(SqlStatementWrapper sqlStatementWrapper, int pageIndex, int pageSize) {
        int rowNum = pageIndex * pageSize;
        int rn = (pageIndex - 1) * pageSize;
        ParameterBinder parameterBinder = sqlStatementWrapper.getParameterBinder();
        String offsetKey = SqlUtils.registerValueWithKey(parameterBinder, rowNum);
        String pageSizeKey = SqlUtils.registerValueWithKey(parameterBinder, rn);
        StringBuilder pagingSql = sqlStatementWrapper.getRawSql();
        pagingSql.insert(0, "SELECT * FROM (SELECT PAGE_TEMP.*, ROWNUM RN FROM (");
        pagingSql.append(") PAGE_TEMP ");
        pagingSql.append("WHERE ROWNUM <= ").append(offsetKey);
        pagingSql.append(") WHERE RN > ").append(pageSizeKey);
    }
}

