/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.plugins.resolve;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValueResolver {
    private final Map<String, String> config;
    public static final Pattern VALUE_PATTERN = Pattern.compile("\\$\\{([^:{}]+)(?::([^{}]*))?}");

    public ValueResolver(Map<String, String> config) {
        this.config = config;
    }

    public String resolve(String text) {
        Matcher matcher = VALUE_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String defaultValue;
            String key = matcher.group(1);
            String value = this.config.getOrDefault(key, defaultValue = matcher.group(2));
            if (value == null) {
                throw new IllegalArgumentException("Missing config key: " + key);
            }
            value = this.resolve(value);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public Map<String, String> getConfig() {
        return this.config;
    }
}

