/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.utils;

import com.dynamic.sql.core.Fn;
import java.beans.Introspector;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectUtils {
    public static final Pattern GET_PATTERN = Pattern.compile("^get[A-Z].*");
    public static final Pattern START_UPPER_PATTERN = Pattern.compile("^[A-Z].*");
    public static final Pattern IS_PATTERN = Pattern.compile("^is[A-Z].*");
    private static final Logger log = LoggerFactory.getLogger(ReflectUtils.class);

    private ReflectUtils() {
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        return ReflectUtils.getAllFields(clazz, null);
    }

    public static List<Field> getAllFields(Class<?> clazz, Function<Field, Boolean> filterRules) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ReflectUtils.collectFields(clazz, fields, filterRules);
        return fields;
    }

    private static void collectFields(Class<?> clazz, List<Field> fields, Function<Field, Boolean> filterRules) {
        Field[] declaredFields;
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            if (filterRules == null) {
                fields.add(field);
                continue;
            }
            if (!Boolean.TRUE.equals(filterRules.apply(field))) continue;
            fields.add(field);
        }
        ReflectUtils.collectFields(clazz.getSuperclass(), fields, filterRules);
    }

    public static String fnToFieldName(Fn fn) {
        SerializedLambda serializedLambda = ReflectUtils.serializedLambda(fn);
        String getter = serializedLambda.getImplMethodName();
        if (GET_PATTERN.matcher(getter).matches()) {
            getter = getter.substring(3);
        } else if (IS_PATTERN.matcher(getter).matches()) {
            getter = getter.substring(2);
        } else if (getter.startsWith("get")) {
            getter = getter.substring(3);
        }
        getter = Introspector.decapitalize(getter);
        if (START_UPPER_PATTERN.matcher(getter).matches()) {
            String begin = getter.substring(0, 1).toLowerCase();
            String end = getter.substring(1);
            getter = begin + end;
        }
        return getter;
    }

    public static String getOriginalClassCanonicalName(Fn fn) {
        SerializedLambda serializedLambda = ReflectUtils.serializedLambda(fn);
        String implClass = ReflectUtils.extractInstantiatedClass(serializedLambda);
        if (implClass == null || implClass.isEmpty()) {
            throw new IllegalStateException("Unable to obtain the implementation class");
        }
        return implClass.replace("/", ".");
    }

    public static String getOriginalClassShortCanonicalName(Fn fn) {
        String originalClassCanonicalName = ReflectUtils.getOriginalClassCanonicalName(fn);
        if (originalClassCanonicalName.contains(".")) {
            return originalClassCanonicalName.substring(originalClassCanonicalName.lastIndexOf(".") + 1);
        }
        return originalClassCanonicalName;
    }

    public static String extractInstantiatedClass(SerializedLambda lambda) {
        String sig = lambda.getInstantiatedMethodType();
        int start = sig.indexOf(76);
        int end = sig.indexOf(59);
        if (start >= 0 && end > start) {
            return sig.substring(start + 1, end);
        }
        return lambda.getImplClass();
    }

    public static <C> Class<C> getReturnTypeFromSignature(Fn fn) {
        SerializedLambda serializedLambda = ReflectUtils.serializedLambda(fn);
        String implMethodSignature = serializedLambda.getImplMethodSignature();
        String returnTypeDescriptor = implMethodSignature.substring(implMethodSignature.indexOf(41) + 1);
        String className = ReflectUtils.descriptorToClassName(returnTypeDescriptor);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find class for name: " + className, e);
        }
    }

    private static String descriptorToClassName(String descriptor) {
        if (descriptor.startsWith("L") && descriptor.endsWith(";")) {
            return descriptor.substring(1, descriptor.length() - 1).replace('/', '.');
        }
        throw new IllegalArgumentException("Unsupported descriptor: " + descriptor);
    }

    private static SerializedLambda serializedLambda(Fn fn) {
        try {
            Method method = fn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(Boolean.TRUE);
            return (SerializedLambda)method.invoke((Object)fn, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            log.warn(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public static List<Class<?>> getGenericTypes(Class<?> clazz) {
        return ReflectUtils.getGenericTypes(clazz, new Class[]{null});
    }

    public static List<Class<?>> getGenericTypes(Class<?> clazz, Class<?> ... filterRawType) {
        Type[] genericInterfaces = clazz.getGenericInterfaces();
        ArrayList types = new ArrayList();
        ArrayList filterRawTypeList = new ArrayList();
        if (filterRawType != null && filterRawType.length > 0) {
            filterRawTypeList.addAll(Arrays.asList(filterRawType));
        }
        for (Type type : genericInterfaces) {
            Type[] actualTypeArguments;
            if (!(type instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            for (Type actualTypeArgument : actualTypeArguments = parameterizedType.getActualTypeArguments()) {
                if (filterRawTypeList.isEmpty()) {
                    types.add((Class)actualTypeArgument);
                    continue;
                }
                if (!filterRawTypeList.contains((Class)parameterizedType.getRawType())) continue;
                types.add((Class)actualTypeArgument);
            }
        }
        return types;
    }

    public static Class<?> getUserGenericClassByField(Field field) {
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            throw new IllegalStateException("\u5c5e\u6027 " + field.getName() + " \u4e0d\u662f\u6cdb\u578b\u96c6\u5408\uff0c\u65e0\u6cd5\u83b7\u53d6\u5143\u7d20\u7c7b\u578b");
        }
        ParameterizedType pt = (ParameterizedType)genericType;
        Type actualType = pt.getActualTypeArguments()[0];
        if (!(actualType instanceof Class)) {
            throw new IllegalStateException("\u96c6\u5408\u5143\u7d20\u7c7b\u578b\u4e0d\u662f Class\uff0c\u65e0\u6cd5\u5904\u7406\uff1a" + actualType);
        }
        return (Class)actualType;
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static void setFieldValue(Object target, Field field, Object value) {
        try {
            if (!Modifier.isPublic(field.getModifiers())) {
                ReflectUtils.makeAccessible(field);
            }
            field.set(target, value);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object getFieldValue(Object target, Field field) {
        try {
            if (!Modifier.isPublic(field.getModifiers())) {
                ReflectUtils.makeAccessible(field);
            }
            return field.get(target);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Class<?> loadClass(String classCanonicalName) {
        try {
            return Class.forName(classCanonicalName);
        }
        catch (ClassNotFoundException e) {
            try {
                ClassLoader.getSystemClassLoader().loadClass(classCanonicalName);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            throw new RuntimeException(new ClassNotFoundException(classCanonicalName));
        }
    }

    public static <T> T instance(Class<T> clazz, Object ... args) {
        try {
            Constructor<?>[] constructors = clazz.getDeclaredConstructors();
            Constructor<?> matchedConstructor = null;
            Object[] adjustedArgs = null;
            for (Constructor<?> constructor : constructors) {
                Class<?>[] paramTypes = constructor.getParameterTypes();
                if (!ReflectUtils.isMatchingConstructor(paramTypes, args)) continue;
                matchedConstructor = constructor;
                adjustedArgs = ReflectUtils.adjustArguments(paramTypes, args);
                break;
            }
            if (matchedConstructor == null) {
                throw new NoSuchMethodException("No matching constructor found for " + clazz.getName() + " with args: " + Arrays.toString(args));
            }
            matchedConstructor.setAccessible(true);
            return matchedConstructor.newInstance(adjustedArgs);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Constructor not found for class: " + clazz.getName(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create instance of class: " + clazz.getName(), e);
        }
    }

    private static boolean isMatchingConstructor(Class<?>[] paramTypes, Object[] args) {
        int fixedParamCount;
        if (paramTypes.length == 0 && args.length == 0) {
            return true;
        }
        boolean isVarArgs = paramTypes.length > 0 && paramTypes[paramTypes.length - 1].isArray();
        int n = fixedParamCount = isVarArgs ? paramTypes.length - 1 : paramTypes.length;
        if (!isVarArgs && paramTypes.length != args.length) {
            return false;
        }
        if (isVarArgs && args.length < fixedParamCount) {
            return false;
        }
        for (int i = 0; i < fixedParamCount; ++i) {
            if (ReflectUtils.isAssignable(paramTypes[i], args[i])) continue;
            return false;
        }
        if (isVarArgs) {
            Class<?> varArgType = paramTypes[paramTypes.length - 1].getComponentType();
            for (int i = fixedParamCount; i < args.length; ++i) {
                if (ReflectUtils.isAssignable(varArgType, args[i])) continue;
                return false;
            }
        }
        return true;
    }

    private static Object[] adjustArguments(Class<?>[] paramTypes, Object[] args) {
        boolean isVarArgs;
        boolean bl = isVarArgs = paramTypes.length > 0 && paramTypes[paramTypes.length - 1].isArray();
        if (!isVarArgs || args.length <= paramTypes.length) {
            return args;
        }
        int fixedParamCount = paramTypes.length - 1;
        Class<?> varArgType = paramTypes[paramTypes.length - 1].getComponentType();
        Object[] adjustedArgs = new Object[paramTypes.length];
        System.arraycopy(args, 0, adjustedArgs, 0, fixedParamCount);
        int varArgLength = args.length - fixedParamCount;
        Object varArgArray = Array.newInstance(varArgType, varArgLength);
        for (int i = 0; i < varArgLength; ++i) {
            Array.set(varArgArray, i, args[fixedParamCount + i]);
        }
        adjustedArgs[fixedParamCount] = varArgArray;
        return adjustedArgs;
    }

    public static boolean isAssignable(Class<?> paramType, Object arg) {
        if (arg == null) {
            return !paramType.isPrimitive();
        }
        Class<?> argType = arg.getClass();
        if (paramType.isAssignableFrom(argType)) {
            return true;
        }
        if (paramType.isPrimitive()) {
            if (paramType == Integer.TYPE && argType == Integer.class) {
                return true;
            }
            if (paramType == Double.TYPE && argType == Double.class) {
                return true;
            }
            if (paramType == Boolean.TYPE && argType == Boolean.class) {
                return true;
            }
            if (paramType == Long.TYPE && argType == Long.class) {
                return true;
            }
            if (paramType == Float.TYPE && argType == Float.class) {
                return true;
            }
            if (paramType == Short.TYPE && argType == Short.class) {
                return true;
            }
            if (paramType == Byte.TYPE && argType == Byte.class) {
                return true;
            }
            if (paramType == Character.TYPE && argType == Character.class) {
                return true;
            }
        }
        return false;
    }

    public static Field findField(Class<?> clazz, String name) {
        return ReflectUtils.findField(clazz, name, null);
    }

    public static Field findField(Class<?> clazz, String name, Class<?> type) {
        Objects.requireNonNull(clazz, "Class must not be null");
        Objects.requireNonNull(name, "Field name must not be null");
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            List<Field> fields = ReflectUtils.getAllFields(searchType);
            for (Field field : fields) {
                if (!name.equalsIgnoreCase(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return field;
            }
        }
        return null;
    }
}

