/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.utils;

import com.dynamic.sql.enums.WKBType;
import com.dynamic.sql.model.Point;
import com.dynamic.sql.model.Polygon;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class WKBUtils {
    private WKBUtils() {
    }

    public static byte[] writeWkbBytesFromPoint(Point point) {
        ByteOrder order = point.getByteOrder() == null ? ByteOrder.LITTLE_ENDIAN : point.getByteOrder();
        ByteBuffer buffer = ByteBuffer.allocate(25);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(point.getSrid());
        buffer.order(order);
        buffer.put((byte)(order != ByteOrder.BIG_ENDIAN ? 1 : 0));
        buffer.putInt(WKBType.POINT.getType());
        buffer.putDouble(point.getLongitude());
        buffer.putDouble(point.getLatitude());
        return buffer.array();
    }

    public static Point readPointFromWkbBytes(byte[] wkbBytes) {
        if (wkbBytes.length == 21) {
            ByteOrder byteOrder = WKBUtils.readIsBigOrLittle(wkbBytes[0]);
            double x = WKBUtils.readDoubleFromBytes(wkbBytes, 5, byteOrder);
            double y = WKBUtils.readDoubleFromBytes(wkbBytes, 13, byteOrder);
            return new Point(x, y, 0, byteOrder);
        }
        if (wkbBytes.length == 25) {
            int srid = ByteBuffer.wrap(wkbBytes, 0, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
            ByteOrder byteOrder = WKBUtils.readIsBigOrLittle(wkbBytes[4]);
            double x = WKBUtils.readDoubleFromBytes(wkbBytes, 9, byteOrder);
            double y = WKBUtils.readDoubleFromBytes(wkbBytes, 17, byteOrder);
            return new Point(x, y, srid, byteOrder);
        }
        throw new IllegalArgumentException("Invalid WKB point length: " + wkbBytes.length);
    }

    public static byte[] writeWkbBytesFromPolygon(Polygon polygon) {
        if (polygon == null || polygon.getPoints().isEmpty()) {
            throw new IllegalArgumentException("Polygon must contain at least four point");
        }
        List<Point> points = polygon.getPoints();
        Point p = points.get(0);
        int srid = p.getSrid();
        ByteOrder byteOrder = p.getByteOrder();
        int numPoints = points.size();
        int bufferSize = 17 + numPoints * 16;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        buffer.putInt(srid);
        buffer.order(byteOrder);
        buffer.put((byte)(byteOrder != ByteOrder.BIG_ENDIAN ? 1 : 0));
        buffer.putInt(WKBType.POLYGON.getType());
        buffer.putInt(1);
        buffer.putInt(numPoints);
        for (Point point : points) {
            buffer.putDouble(point.getLongitude());
            buffer.putDouble(point.getLatitude());
        }
        return buffer.array();
    }

    public static Polygon readPolygonFromWkbBytes(byte[] wkbBytes) {
        if (wkbBytes == null || wkbBytes.length < 5) {
            throw new IllegalArgumentException("Invalid WKB byte array");
        }
        ByteBuffer buffer = ByteBuffer.wrap(wkbBytes);
        int srid = buffer.getInt();
        ByteOrder byteOrder = buffer.get() == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        buffer.order(byteOrder);
        int geometryType = buffer.getInt();
        if (geometryType != WKBType.POLYGON.getType()) {
            throw new IllegalArgumentException("Only POLYGON geometry type is supported");
        }
        int numRings = buffer.getInt();
        if (numRings != 1) {
            throw new IllegalArgumentException("Only single-ring polygons are supported");
        }
        int numPoints = buffer.getInt();
        ArrayList<Point> points = new ArrayList<Point>(numPoints);
        for (int i = 0; i < numPoints; ++i) {
            double longitude = buffer.getDouble();
            double latitude = buffer.getDouble();
            points.add(new Point(latitude, longitude, srid, byteOrder));
        }
        return new Polygon(points);
    }

    private static ByteOrder readIsBigOrLittle(byte b) {
        boolean BIG_ENDIAN = false;
        return b == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    private static double readDoubleFromBytes(byte[] buf, int offset, ByteOrder byteOrder) {
        ByteBuffer buffer = ByteBuffer.wrap(buf, offset, 8);
        buffer.order(byteOrder);
        return buffer.getDouble();
    }
}

