/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.lambda.visitor;

import com.easy.query.api.lambda.db.DbType;
import com.easy.query.core.lambda.exception.IllegalExpressionException;
import com.easy.query.core.lambda.util.ExpressionUtil;
import com.easy.query.core.lambda.util.SqlUtil;
import com.easy.query.core.lambda.visitor.BaseVisitor;
import io.github.kiryu1223.expressionTree.expressions.BinaryExpression;
import io.github.kiryu1223.expressionTree.expressions.ConditionalExpression;
import io.github.kiryu1223.expressionTree.expressions.ConstantExpression;
import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.FieldSelectExpression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import io.github.kiryu1223.expressionTree.expressions.MethodCallExpression;
import io.github.kiryu1223.expressionTree.expressions.OperatorType;
import io.github.kiryu1223.expressionTree.expressions.ParameterExpression;
import io.github.kiryu1223.expressionTree.expressions.ParensExpression;
import io.github.kiryu1223.expressionTree.expressions.ReferenceExpression;
import io.github.kiryu1223.expressionTree.expressions.UnaryExpression;
import java.util.List;

public class WhereVisitor
extends BaseVisitor {
    public WhereVisitor(List<ParameterExpression> parameters, DbType dbType) {
        super(parameters, dbType);
    }

    public void visit(ParensExpression parensExpression) {
        this.data.append("(");
        this.visit(parensExpression.getExpr());
        this.data.append(")");
    }

    public void visit(UnaryExpression unary) {
        Expression operand = unary.getOperand();
        OperatorType operatorType = unary.getOperatorType();
        String sqlOp = SqlUtil.toSqlOp(operatorType);
        this.data.append(operand.getKind() == Kind.Parens ? sqlOp : sqlOp + "(");
        this.visit(operand);
        if (operand.getKind() != Kind.Parens) {
            this.data.append(")");
        }
    }

    public void visit(BinaryExpression binary) {
        this.visit(binary.getLeft());
        this.data.append(" ").append(SqlUtil.toSqlOp(binary.getOperatorType())).append(" ");
        this.visit(binary.getRight());
    }

    public void visit(ConstantExpression constant) {
        this.putValue(constant.getValue());
    }

    public void visit(ReferenceExpression reference) {
        this.putValue(reference.getValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visit(MethodCallExpression methodCall) {
        if (methodCall.getExpr().getKind() == Kind.Parameter) {
            ParameterExpression parameter = (ParameterExpression)methodCall.getExpr();
            if (!this.parameters.contains(parameter) || ExpressionUtil.isVoid(methodCall.getMethod().getReturnType())) throw new IllegalExpressionException(methodCall);
            int index = this.parameters.indexOf(parameter);
            this.putField(index, SqlUtil.fieldName(methodCall.getMethod()));
            return;
        } else {
            this.methodCallVisitor(methodCall);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visit(FieldSelectExpression fieldSelect) {
        if (fieldSelect.getExpr().getKind() == Kind.Parameter) {
            ParameterExpression parameter = (ParameterExpression)fieldSelect.getExpr();
            if (!this.parameters.contains(parameter) || ExpressionUtil.isVoid(fieldSelect.getField().getType())) throw new IllegalExpressionException(fieldSelect);
            int index = this.parameters.indexOf(parameter);
            this.putField(index, SqlUtil.fieldName(fieldSelect.getField()));
            return;
        } else {
            this.tryPutExprValue(fieldSelect);
        }
    }

    public void visit(ConditionalExpression conditional) {
        Expression condition = conditional.getCondition();
        Expression truePart = conditional.getTruePart();
        Expression falsePart = conditional.getFalsePart();
        Object value = condition.getValue();
        if (value != null) {
            if (((Boolean)value).booleanValue()) {
                this.visit(truePart);
            } else {
                this.visit(falsePart);
            }
        } else {
            this.data.append("IF(");
            this.visit(condition);
            this.data.append(",");
            this.visit(truePart);
            this.data.append(",");
            this.visit(falsePart);
            this.data.append(")");
        }
    }
}

