/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.lambda.visitor;

import com.easy.query.api.lambda.crud.read.QueryData;
import com.easy.query.api.lambda.crud.read.group.GroupExtData;
import com.easy.query.api.lambda.crud.read.group.IAggregation;
import com.easy.query.api.lambda.crud.read.group.IGroup;
import com.easy.query.core.lambda.exception.IllegalExpressionException;
import com.easy.query.core.lambda.util.ExpressionUtil;
import com.easy.query.core.lambda.util.SqlUtil;
import com.easy.query.core.lambda.visitor.BaseVisitor;
import com.easy.query.core.lambda.visitor.SqlValue;
import io.github.kiryu1223.expressionTree.expressions.BlockExpression;
import io.github.kiryu1223.expressionTree.expressions.ConstantExpression;
import io.github.kiryu1223.expressionTree.expressions.DeepFindVisitor;
import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.FieldSelectExpression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import io.github.kiryu1223.expressionTree.expressions.LambdaExpression;
import io.github.kiryu1223.expressionTree.expressions.MethodCallExpression;
import io.github.kiryu1223.expressionTree.expressions.NewExpression;
import io.github.kiryu1223.expressionTree.expressions.ParameterExpression;
import io.github.kiryu1223.expressionTree.expressions.ReferenceExpression;
import io.github.kiryu1223.expressionTree.expressions.ReturnExpression;
import io.github.kiryu1223.expressionTree.expressions.VariableExpression;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SelectVisitor
extends BaseVisitor {
    private String temp = "";
    private int parIndex = 0;
    private final QueryData queryData;
    private ParameterExpression curParameter;

    public SelectVisitor(List<ParameterExpression> parameters, QueryData queryData) {
        super(parameters, queryData.getDbType());
        this.queryData = queryData;
    }

    public int getParIndex() {
        return this.parIndex;
    }

    public void visit(NewExpression newExpression) {
        BlockExpression classBody = newExpression.getClassBody();
        if (classBody == null) {
            return;
        }
        List expressions = classBody.getExpressions();
        for (int i = 0; i < expressions.size(); ++i) {
            Expression expression = (Expression)expressions.get(i);
            if (expression.getKind() != Kind.Variable) continue;
            VariableExpression variable = (VariableExpression)expression;
            this.visit(variable.getInit());
            String name = variable.getParameter().getName();
            if (!name.equals(this.temp)) {
                this.data.append(" AS ").append(name);
            }
            if (i >= expressions.size() - 1) continue;
            this.data.append(",");
        }
    }

    public void visit(LambdaExpression<?> lambda) {
        List parameters = lambda.getParameters();
        SelectVisitor selectVisitor = new SelectVisitor((List<ParameterExpression>)parameters, this.queryData);
        selectVisitor.mesIndex = this.mesIndex;
        lambda.getBody().accept((DeepFindVisitor)selectVisitor);
        this.data.append(selectVisitor.getData());
        this.sqlValue.addAll(selectVisitor.getSqlValue());
        this.mesIndex = selectVisitor.mesIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visit(MethodCallExpression methodCall) {
        if (methodCall.getExpr().getKind() == Kind.Parameter) {
            ParameterExpression parameter = (ParameterExpression)methodCall.getExpr();
            if (IAggregation.class.isAssignableFrom(methodCall.getMethod().getDeclaringClass())) {
                Method method = methodCall.getMethod();
                List args = methodCall.getArgs();
                String methodName = method.getName();
                this.data.append(methodName).append("(");
                if (args.isEmpty()) {
                    this.data.append("*");
                } else {
                    for (Expression arg : args) {
                        this.visit(arg);
                    }
                }
                this.data.append(")");
                this.temp = methodName + "()";
                return;
            } else if (this.parameters.contains(parameter) && !ExpressionUtil.isVoid(methodCall.getMethod().getReturnType())) {
                int index = this.parameters.indexOf(parameter);
                String fieldName = SqlUtil.fieldName(methodCall.getMethod());
                this.putField(index, fieldName);
                this.temp = fieldName;
                return;
            } else {
                if (this.curParameter != parameter) throw new IllegalExpressionException(methodCall);
                for (Expression arg : methodCall.getArgs()) {
                    this.visit(arg);
                }
                String name = SqlUtil.fieldName(methodCall.getMethod());
                if (!name.equals(this.temp)) {
                    this.data.append(" AS ").append(name);
                }
                this.data.append(",");
            }
            return;
        } else {
            this.methodCallVisitor(methodCall);
            this.temp = "";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visit(FieldSelectExpression fieldSelect) {
        if (fieldSelect.getExpr().getKind() == Kind.Parameter) {
            ParameterExpression parameter = (ParameterExpression)fieldSelect.getExpr();
            Field field = fieldSelect.getField();
            if (!this.parameters.contains(parameter)) throw new IllegalExpressionException(fieldSelect);
            if (IGroup.class.isAssignableFrom(field.getDeclaringClass()) && field.getName().equals("key")) {
                GroupExtData groupExtData = this.queryData.getGroupExtDataMap().get("key");
                this.temp = this.putGroupValue(groupExtData);
                return;
            } else {
                int index = this.parameters.indexOf(parameter);
                String fieldName = SqlUtil.fieldName(field);
                this.putField(index, fieldName);
                this.temp = fieldName;
            }
            return;
        } else if (ExpressionUtil.isGroupKey(this.parameters, fieldSelect.getExpr())) {
            Map<String, GroupExtData> gmap = this.queryData.getGroupExtDataMap();
            String fieldName = SqlUtil.fieldName(fieldSelect.getField());
            GroupExtData groupExtData = gmap.get(fieldName);
            this.temp = this.putGroupValue(groupExtData);
            return;
        } else {
            this.tryPutExprValue(fieldSelect);
        }
    }

    public void visit(VariableExpression variableExpression) {
        this.curParameter = variableExpression.getParameter();
    }

    public void visit(ParameterExpression parameter) {
        if (this.parameters.contains(parameter)) {
            this.parIndex = this.parameters.indexOf(parameter);
        }
    }

    public void visit(ConstantExpression constant) {
        this.addValue(constant.getValue());
    }

    public void visit(ReferenceExpression reference) {
        this.addValue(reference.getValue());
    }

    public void visit(ReturnExpression returnExpression) {
        int index = this.data.length() - 1;
        if (this.data.charAt(index) == ',') {
            this.data.deleteCharAt(index);
        }
    }

    private void addValue(Object value) {
        if (value == null) {
            this.data.append("NULL");
        } else {
            this.data.append(this.indexBlock());
            this.sqlValue.add(new SqlValue(value));
        }
    }

    private String putGroupValue(GroupExtData groupExtData) {
        String input = groupExtData.exprData.toString();
        Pattern pattern = Pattern.compile("\\{}");
        Matcher matcher = pattern.matcher(input);
        StringBuilder sb = new StringBuilder(input.length());
        int prevEnd = 0;
        while (matcher.find()) {
            sb.append(input.substring(prevEnd, matcher.start()));
            sb.append(this.indexBlock());
            prevEnd = matcher.end();
        }
        if (prevEnd < input.length()) {
            sb.append(input.substring(prevEnd));
        }
        this.data.append((CharSequence)sb);
        this.sqlValue.addAll(groupExtData.sqlValues);
        return sb.toString();
    }
}

