/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.entity;

import com.easy.query.core.common.bean.FastBean;
import com.easy.query.core.common.cache.Cache;
import com.easy.query.core.common.cache.DefaultMemoryCache;
import com.easy.query.core.proxy.ProxyEntity;
import com.easy.query.core.proxy.ProxyEntityAvailable;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyObjectUtil;
import java.util.function.Supplier;

public class EntityQueryProxyManager {
    private static final Cache<Class<?>, Supplier<Object>> proxyConstructorCache = new DefaultMemoryCache();

    public static <TEntityProxy extends ProxyEntity<TEntityProxy, TEntity>, TEntity extends ProxyEntityAvailable<TEntity, TEntityProxy>> TEntityProxy create(Class<TEntity> entityClass) {
        if (entityClass == null) {
            throw new IllegalArgumentException("entityClass is null");
        }
        Supplier creator = (Supplier)proxyConstructorCache.get(entityClass);
        if (creator != null) {
            Object proxy = creator.get();
            return (TEntityProxy)((ProxyEntity)EasyObjectUtil.typeCast(proxy));
        }
        ProxyEntityAvailable tEntity = (ProxyEntityAvailable)EasyClassUtil.newInstance(entityClass);
        Class proxyTableClass = tEntity.proxyTableClass();
        FastBean fastBean = new FastBean(proxyTableClass);
        Supplier beanConstructorCreator = fastBean.getBeanConstructorCreator();
        Supplier objectSupplier = (Supplier)proxyConstructorCache.computeIfAbsent(entityClass, arg_0 -> EntityQueryProxyManager.lambda$create$0((Supplier)beanConstructorCreator, arg_0));
        Object proxy = objectSupplier.get();
        return (TEntityProxy)((ProxyEntity)EasyObjectUtil.typeCast(proxy));
    }

    private static /* synthetic */ Supplier lambda$create$0(Supplier beanConstructorCreator, Class key) {
        return beanConstructorCreator;
    }
}

