/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy.core.draft;

import com.easy.query.core.basic.jdbc.executor.internal.enumerable.Draft;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.builder.AsSelector;
import com.easy.query.core.expression.builder.GroupSelector;
import com.easy.query.core.expression.builder.Selector;
import com.easy.query.core.proxy.PropTypeColumn;
import com.easy.query.core.proxy.ProxyEntity;
import com.easy.query.core.proxy.ProxyEntityAvailable;
import com.easy.query.core.proxy.SQLSelectAsExpression;
import com.easy.query.core.proxy.TablePropColumn;
import com.easy.query.core.proxy.ValueObjectProxyEntity;
import com.easy.query.core.proxy.core.draft.DraftFetcher;

public class DraftFetcherImpl<T extends ProxyEntityAvailable<T, TProxy> & Draft, TProxy extends ProxyEntity<TProxy, T>>
implements DraftFetcher<T, TProxy> {
    private final T draft;
    private final TProxy draftProxy;
    private SQLSelectAsExpression sqlSelectAsExpression = SQLSelectAsExpression.empty;
    private final Class<?>[] propTypes;

    public DraftFetcherImpl(T draft, TProxy draftProxy) {
        this.draft = draft;
        this.draftProxy = draftProxy;
        this.propTypes = new Class[((Draft)draft).capacity()];
    }

    @Override
    public <TProperty> void fetch(int index, PropTypeColumn<TProperty> column, TablePropColumn tablePropColumn) {
        SQLSelectAsExpression sqlSelectAsExpression = column.as(tablePropColumn);
        if (sqlSelectAsExpression instanceof ValueObjectProxyEntity) {
            throw new EasyQueryInvalidOperationException("draft result not support value object columns");
        }
        this.propTypes[index] = column.getPropertyType();
        this.sqlSelectAsExpression = this.sqlSelectAsExpression._concat(sqlSelectAsExpression);
    }

    @Override
    public void accept(GroupSelector s) {
        this.sqlSelectAsExpression.accept(s);
    }

    @Override
    public void accept(AsSelector s) {
        this.sqlSelectAsExpression.accept(s);
    }

    @Override
    public void accept(Selector s) {
        this.sqlSelectAsExpression.accept(s);
    }

    @Override
    public T getDraft() {
        return this.draft;
    }

    @Override
    public TProxy getDraftProxy() {
        return this.draftProxy;
    }

    @Override
    public Class<?>[] getDraftPropTypes() {
        return this.propTypes;
    }
}

