/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.entity;

import com.easy.query.core.common.bean.FastBean;
import com.easy.query.core.common.cache.Cache;
import com.easy.query.core.common.cache.DefaultMemoryCache;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.proxy.ProxyEntity;
import com.easy.query.core.proxy.ProxyEntityAvailable;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyObjectUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class EntityQueryProxyManager {
    private static final Cache<Class<?>, Supplier<Object>> proxyConstructorCache = new DefaultMemoryCache();

    public static <TEntityProxy extends ProxyEntity<TEntityProxy, TEntity>, TEntity extends ProxyEntityAvailable<TEntity, TEntityProxy>> TEntityProxy create(Class<TEntity> entityClass) {
        if (entityClass == null) {
            throw new IllegalArgumentException("entityClass is null");
        }
        Supplier creator = (Supplier)proxyConstructorCache.get(entityClass);
        if (creator != null) {
            Object proxy = creator.get();
            return (TEntityProxy)((ProxyEntity)EasyObjectUtil.typeCast(proxy));
        }
        if (!ProxyEntityAvailable.class.isAssignableFrom(entityClass)) {
            throw new EasyQueryInvalidOperationException(String.format("%s is not implements ProxyEntityAvailable", EasyClassUtil.getSimpleName(entityClass)));
        }
        Class<?> proxyTableClass = Arrays.stream(entityClass.getGenericInterfaces()).map(t -> {
            Type actualTypeArgument;
            Type[] actualTypeArguments;
            ParameterizedType parameterizedType;
            Type rawType;
            if (t instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)t).getRawType()) instanceof Class && ProxyEntityAvailable.class.isAssignableFrom((Class)rawType) && (actualTypeArguments = parameterizedType.getActualTypeArguments()).length == 2 && (actualTypeArgument = actualTypeArguments[1]) instanceof Class) {
                return (Class)actualTypeArgument;
            }
            return null;
        }).filter(t -> t != null).findFirst().orElse(null);
        if (proxyTableClass == null && (proxyTableClass = EntityQueryProxyManager.getProxyGenericType(entityClass, ProxyEntityAvailable.class)) == null) {
            throw new EasyQueryInvalidOperationException(String.format("Cannot find the ProxyEntityAvailable proxy type for %s", EasyClassUtil.getSimpleName(entityClass)));
        }
        FastBean fastBean = new FastBean(proxyTableClass);
        Supplier beanConstructorCreator = fastBean.getBeanConstructorCreator();
        Supplier objectSupplier = (Supplier)proxyConstructorCache.computeIfAbsent(entityClass, arg_0 -> EntityQueryProxyManager.lambda$create$2((Supplier)beanConstructorCreator, arg_0));
        Object proxy = objectSupplier.get();
        return (TEntityProxy)((ProxyEntity)EasyObjectUtil.typeCast(proxy));
    }

    public static Class<?> getProxyGenericType(Class<?> clazz, Class<?> targetInterface) {
        HashMap typeMap = new HashMap();
        return EntityQueryProxyManager.getGenericType(clazz, targetInterface, typeMap);
    }

    private static Class<?> getGenericType(Class<?> clazz, Class<?> targetInterface, Map<TypeVariable<?>, Type> typeMap) {
        Type[] genericInterfaces;
        Type superClass = clazz.getGenericSuperclass();
        if (superClass instanceof ParameterizedType) {
            EntityQueryProxyManager.resolveTypeArguments((ParameterizedType)superClass, typeMap);
        }
        for (Type genericInterface : genericInterfaces = clazz.getGenericInterfaces()) {
            if (!(genericInterface instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)genericInterface;
            if (parameterizedType.getRawType().equals(targetInterface)) {
                return EntityQueryProxyManager.getClassForType(parameterizedType.getActualTypeArguments()[1], typeMap);
            }
            EntityQueryProxyManager.resolveTypeArguments(parameterizedType, typeMap);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && !superclass.equals(Object.class)) {
            return EntityQueryProxyManager.getGenericType(superclass, targetInterface, typeMap);
        }
        return null;
    }

    private static void resolveTypeArguments(ParameterizedType parameterizedType, Map<TypeVariable<?>, Type> typeMap) {
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        TypeVariable<Class<T>>[] typeVariables = ((Class)parameterizedType.getRawType()).getTypeParameters();
        for (int i = 0; i < typeVariables.length; ++i) {
            typeMap.put(typeVariables[i], actualTypeArguments[i]);
        }
    }

    private static Class<?> getClassForType(Type type, Map<TypeVariable<?>, Type> typeMap) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof TypeVariable) {
            Type resolvedType = typeMap.get(type);
            if (resolvedType instanceof Class) {
                return (Class)resolvedType;
            }
            return EntityQueryProxyManager.getClassForType(resolvedType, typeMap);
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return null;
    }

    private static /* synthetic */ Supplier lambda$create$2(Supplier beanConstructorCreator, Class key) {
        return beanConstructorCreator;
    }
}

