/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy.predicate;

import com.easy.query.core.enums.SQLPredicateCompare;
import com.easy.query.core.enums.SQLPredicateCompareEnum;
import com.easy.query.core.enums.SQLRangeEnum;
import com.easy.query.core.expression.builder.Filter;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.SQLFunc;
import com.easy.query.core.proxy.PropTypeColumn;
import com.easy.query.core.proxy.SQLColumn;
import com.easy.query.core.proxy.TablePropColumn;
import com.easy.query.core.proxy.available.EntitySQLContextAvailable;
import com.easy.query.core.proxy.core.EntitySQLContext;
import com.easy.query.core.proxy.impl.SQLPredicateImpl;
import com.easy.query.core.proxy.predicate.aggregate.DSLSQLFunctionAvailable;
import com.easy.query.core.util.EasyClassUtil;

public interface DSLRangeColumnFunctionPredicate<TProperty>
extends TablePropColumn,
EntitySQLContextAvailable {
    default public void rangeOpenClosed(PropTypeColumn<TProperty> valLeft, PropTypeColumn<TProperty> valRight) {
        this.rangeOpenClosed(true, valLeft, true, valRight);
    }

    default public void rangeOpenClosed(boolean conditionLeft, PropTypeColumn<TProperty> valLeft, boolean conditionRight, PropTypeColumn<TProperty> valRight) {
        DSLRangeColumnFunctionPredicate.range(this.getEntitySQLContext(), this.getTable(), this.getValue(), conditionLeft, valLeft, conditionRight, valRight, SQLRangeEnum.OPEN_CLOSED);
    }

    default public void rangeOpen(PropTypeColumn<TProperty> valLeft, PropTypeColumn<TProperty> valRight) {
        this.rangeOpen(true, valLeft, true, valRight);
    }

    default public void rangeOpen(boolean conditionLeft, PropTypeColumn<TProperty> valLeft, boolean conditionRight, PropTypeColumn<TProperty> valRight) {
        DSLRangeColumnFunctionPredicate.range(this.getEntitySQLContext(), this.getTable(), this.getValue(), conditionLeft, valLeft, conditionRight, valRight, SQLRangeEnum.OPEN);
    }

    default public void rangeClosedOpen(PropTypeColumn<TProperty> valLeft, PropTypeColumn<TProperty> valRight) {
        this.rangeClosedOpen(true, valLeft, true, valRight);
    }

    default public void rangeClosedOpen(boolean conditionLeft, PropTypeColumn<TProperty> valLeft, boolean conditionRight, PropTypeColumn<TProperty> valRight) {
        DSLRangeColumnFunctionPredicate.range(this.getEntitySQLContext(), this.getTable(), this.getValue(), conditionLeft, valLeft, conditionRight, valRight, SQLRangeEnum.CLOSED_OPEN);
    }

    default public void rangeClosed(PropTypeColumn<TProperty> valLeft, PropTypeColumn<TProperty> valRight) {
        this.rangeClosed(true, valLeft, true, valRight);
    }

    default public void rangeClosed(boolean conditionLeft, PropTypeColumn<TProperty> valLeft, boolean conditionRight, PropTypeColumn<TProperty> valRight) {
        DSLRangeColumnFunctionPredicate.range(this.getEntitySQLContext(), this.getTable(), this.getValue(), conditionLeft, valLeft, conditionRight, valRight, SQLRangeEnum.CLOSED);
    }

    public static <TProp> void range(EntitySQLContext entitySQLContext, TableAvailable table, String property, boolean conditionLeft, PropTypeColumn<TProp> valLeft, boolean conditionRight, PropTypeColumn<TProp> valRight, SQLRangeEnum sqlRange) {
        if (conditionLeft && conditionRight) {
            entitySQLContext._whereAnd(() -> entitySQLContext.accept(new SQLPredicateImpl(filter -> {
                boolean openFirst = SQLRangeEnum.openFirst((SQLRangeEnum)sqlRange);
                DSLRangeColumnFunctionPredicate.rangeCompare(filter, table, property, openFirst ? SQLPredicateCompareEnum.GT : SQLPredicateCompareEnum.GE, valLeft);
                boolean openEnd = SQLRangeEnum.openEnd((SQLRangeEnum)sqlRange);
                DSLRangeColumnFunctionPredicate.rangeCompare(filter, table, property, openEnd ? SQLPredicateCompareEnum.LT : SQLPredicateCompareEnum.LE, valRight);
            })));
        } else {
            if (conditionLeft) {
                entitySQLContext.accept(new SQLPredicateImpl(filter -> {
                    boolean openFirst = SQLRangeEnum.openFirst((SQLRangeEnum)sqlRange);
                    DSLRangeColumnFunctionPredicate.rangeCompare(filter, table, property, openFirst ? SQLPredicateCompareEnum.GT : SQLPredicateCompareEnum.GE, valLeft);
                }));
            }
            if (conditionRight) {
                entitySQLContext.accept(new SQLPredicateImpl(filter -> {
                    boolean openEnd = SQLRangeEnum.openEnd((SQLRangeEnum)sqlRange);
                    DSLRangeColumnFunctionPredicate.rangeCompare(filter, table, property, openEnd ? SQLPredicateCompareEnum.LT : SQLPredicateCompareEnum.LE, valRight);
                }));
            }
        }
    }

    public static <TProp> void rangeCompare(Filter filter, TableAvailable table, String property, SQLPredicateCompareEnum sqlPredicateCompare, PropTypeColumn<TProp> val) {
        if (val instanceof SQLColumn) {
            filter.valueColumnFilter(table, property, val.getTable(), val.getValue(), (SQLPredicateCompare)sqlPredicateCompare);
        } else if (val instanceof DSLSQLFunctionAvailable) {
            DSLSQLFunctionAvailable valLeftFunc = (DSLSQLFunctionAvailable)((Object)val);
            SQLFunc fx = filter.getRuntimeContext().fx();
            filter.valueFuncFilter(table, property, valLeftFunc.getTable(), valLeftFunc.func().apply(fx), (SQLPredicateCompare)sqlPredicateCompare);
        } else {
            throw new UnsupportedOperationException(EasyClassUtil.getInstanceSimpleName(val));
        }
    }
}

