/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy.partition.metadata;

import com.easy.query.core.basic.jdbc.types.handler.JdbcTypeHandler;
import com.easy.query.core.enums.EntityMetadataTypeEnum;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.ColumnOption;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.proxy.partition.Partition1;
import com.easy.query.core.proxy.partition.metadata.PartitionColumnMetadata;
import com.easy.query.core.util.EasyClassUtil;
import java.io.Serializable;

public class Partition1EntityMetadata
extends EntityMetadata {
    private final EntityMetadata entityMetadata;
    private final JdbcTypeHandler jdbcTypeHandler;

    public Partition1EntityMetadata(Class<?> entityClass, EntityMetadata entityMetadata, JdbcTypeHandler jdbcTypeHandler) {
        super(entityClass);
        this.entityMetadata = entityMetadata;
        this.jdbcTypeHandler = jdbcTypeHandler;
        this.entityMetadataType = EntityMetadataTypeEnum.PARTITION_BY;
        this.beanConstructorCreator = () -> {
            Partition1 r = new Partition1();
            Object entity = entityMetadata.getBeanConstructorCreator().get();
            r.setEntity(entity);
            return r;
        };
    }

    public ColumnMetadata getColumnNotNull(String propertyName) {
        ColumnMetadata columnMetadata = this.getColumnOrNull(propertyName);
        if (columnMetadata == null) {
            throw new EasyQueryException(String.format("%s not found property:[%s] mapping column name", EasyClassUtil.getSimpleName((Class)this.getEntityClass()), propertyName));
        }
        return columnMetadata;
    }

    public ColumnMetadata getColumnOrNull(String propertyName) {
        ColumnMetadata partitionByColumn = this.getPartitionByColumn(propertyName);
        if (partitionByColumn != null) {
            return partitionByColumn;
        }
        return this.entityMetadata.getColumnOrNull(propertyName);
    }

    protected ColumnMetadata getPartitionByColumn(String propertyName) {
        if (this.isPartitionByColumn(propertyName)) {
            ColumnOption columnOption = new ColumnOption(false, (EntityMetadata)this, propertyName);
            columnOption.setGetterCaller((Property & Serializable)obj -> ((Partition1)obj).getPartitionColumn1());
            columnOption.setSetterCaller((obj, value) -> ((Partition1)obj).setPartitionColumn1(value));
            columnOption.setJdbcTypeHandler(this.getPartitionJdbcTypeHandler(propertyName));
            return new PartitionColumnMetadata(columnOption, propertyName);
        }
        return null;
    }

    protected boolean isPartitionByColumn(String propertyName) {
        return "__partition__column1".equals(propertyName);
    }

    protected JdbcTypeHandler getPartitionJdbcTypeHandler(String propertyName) {
        if ("__partition__column1".equals(propertyName)) {
            return this.jdbcTypeHandler;
        }
        throw new EasyQueryInvalidOperationException("unknown propertyName:[" + propertyName + "]");
    }

    public String getPropertyNameOrNull(String columnName, String def) {
        ColumnMetadata columnMetadata = this.getColumnMetadataOrNull(columnName);
        if (columnMetadata == null) {
            return def;
        }
        return columnMetadata.getPropertyName();
    }

    public ColumnMetadata getColumnMetadataOrNull(String columnName) {
        ColumnMetadata partitionByColumn = this.getPartitionByColumn(columnName);
        if (partitionByColumn != null) {
            return partitionByColumn;
        }
        return this.entityMetadata.getColumnMetadataOrNull(columnName);
    }
}

