/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy;

import com.easy.query.api.proxy.util.EasyPropertyLambdaUtil;
import com.easy.query.core.annotation.Nullable;
import com.easy.query.core.expression.builder.AsSelector;
import com.easy.query.core.expression.builder.OnlySelector;
import com.easy.query.core.expression.builder.Selector;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.SQLFunc;
import com.easy.query.core.func.SQLFunction;
import com.easy.query.core.func.def.enums.OrderByModeEnum;
import com.easy.query.core.proxy.PropTypeColumn;
import com.easy.query.core.proxy.PropTypeSetColumn;
import com.easy.query.core.proxy.SQLSelectAsExpression;
import com.easy.query.core.proxy.TablePropColumn;
import com.easy.query.core.proxy.impl.SQLOrderSelectImpl;
import com.easy.query.core.proxy.impl.SQLSelectAsImpl;
import com.easy.query.core.proxy.impl.SQLSelectImpl;
import com.easy.query.core.proxy.impl.draft.SelectToDraftColumn;
import com.easy.query.core.proxy.sql.Select;
import com.easy.query.core.util.EasyObjectUtil;

public interface SQLSelectExpression
extends TablePropColumn {
    public static final SQLSelectExpression empty = new SQLSelectImpl(x -> {});

    default public void orderBy(boolean asc) {
        this.orderBy(asc, null);
    }

    default public void orderBy(boolean asc, @Nullable OrderByModeEnum nullsModeEnum) {
        this.orderBy(true, asc, nullsModeEnum);
    }

    default public void orderBy(boolean condition, boolean asc, @Nullable OrderByModeEnum nullsModeEnum) {
        if (condition) {
            if (asc) {
                this.asc(nullsModeEnum);
            } else {
                this.desc(nullsModeEnum);
            }
        }
    }

    default public void asc() {
        this.asc(true);
    }

    default public void asc(boolean condition) {
        this.asc(condition, null);
    }

    default public void asc(@Nullable OrderByModeEnum nullsModeEnum) {
        this.asc(true, nullsModeEnum);
    }

    default public void asc(boolean condition, @Nullable OrderByModeEnum nullsModeEnum) {
        if (condition) {
            this.getCurrentEntitySQLContext().accept(new SQLOrderSelectImpl(s -> {
                s.setAsc(true);
                if (nullsModeEnum != null) {
                    SQLFunc fx = this.getEntitySQLContext().getRuntimeContext().fx();
                    SQLFunction orderByNullsModeFunction = fx.orderByNullsMode(this.getTable(), this.getValue(), true, nullsModeEnum);
                    s.func(this.getTable(), orderByNullsModeFunction, false);
                } else {
                    s.column(this.getTable(), this.getValue());
                }
            }));
        }
    }

    default public void desc() {
        this.desc(true);
    }

    default public void desc(boolean condition) {
        this.desc(condition, null);
    }

    default public void desc(OrderByModeEnum nullsModeEnum) {
        this.desc(true, nullsModeEnum);
    }

    default public void desc(boolean condition, OrderByModeEnum nullsModeEnum) {
        if (condition) {
            this.getCurrentEntitySQLContext().accept(new SQLOrderSelectImpl(s -> {
                s.setAsc(false);
                if (nullsModeEnum != null) {
                    SQLFunc fx = this.getEntitySQLContext().getRuntimeContext().fx();
                    SQLFunction orderByNullsModeFunction = fx.orderByNullsMode(this.getTable(), this.getValue(), false, nullsModeEnum);
                    s.func(this.getTable(), orderByNullsModeFunction, false);
                } else {
                    s.column(this.getTable(), this.getValue());
                }
            }));
        }
    }

    default public SQLSelectAsExpression as(TablePropColumn propColumn) {
        return this.as(propColumn.getValue());
    }

    default public SQLSelectAsExpression as(String propertyAlias) {
        return new SQLSelectAsImpl(s -> s.columnAs(this.getTable(), this.getValue(), propertyAlias), s -> s.columnAs(this.getTable(), this.getValue(), propertyAlias), s -> {
            throw new UnsupportedOperationException();
        });
    }

    default public <TEntity, TR> SQLSelectAsExpression as(Property<TEntity, TR> propertyAlias) {
        return this.as(EasyPropertyLambdaUtil.getPropertyName(propertyAlias));
    }

    default public SQLSelectExpression _concat(SQLSelectExpression ... sqlSelectAses) {
        return this._concat(true, sqlSelectAses);
    }

    default public SQLSelectExpression _concat(boolean condition, SQLSelectExpression ... sqlSelectAs) {
        if (condition) {
            SQLSelectExpression expression = Select.of(sqlSelectAs);
            return new SQLSelectImpl(x -> {
                this.accept((Selector)x);
                expression.accept((Selector)x);
            });
        }
        return empty;
    }

    default public void accept(Selector s) {
        TableAvailable table = this.getTable();
        String value = this.getValue();
        if (table != null && value != null) {
            s.column(table, value);
        }
    }

    default public void accept(AsSelector s) {
        TableAvailable table = this.getTable();
        String value = this.getValue();
        if (table != null && value != null) {
            s.column(table, value);
        }
    }

    default public void accept(OnlySelector s) {
        s.column(this.getTable(), this.getValue());
    }

    default public <TProperty> PropTypeColumn<TProperty> toDraft(Class<TProperty> propType) {
        if (PropTypeColumn.class.isAssignableFrom(this.getClass())) {
            PropTypeSetColumn propTypeColumn = ((PropTypeColumn)this).asAnyType(propType);
            return (PropTypeColumn)EasyObjectUtil.typeCastNullable((Object)propTypeColumn);
        }
        return new SelectToDraftColumn<TProperty>(this, propType);
    }
}

