/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy.fetcher;

import com.easy.query.core.expression.builder.AsSelector;
import com.easy.query.core.expression.builder.GroupSelector;
import com.easy.query.core.expression.builder.OnlySelector;
import com.easy.query.core.expression.builder.Selector;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.proxy.AbstractBaseProxyEntity;
import com.easy.query.core.proxy.AbstractProxyEntity;
import com.easy.query.core.proxy.ProxyEntity;
import com.easy.query.core.proxy.SQLColumn;
import com.easy.query.core.proxy.SQLSelectAsExpression;
import com.easy.query.core.proxy.TablePropColumn;
import com.easy.query.core.proxy.core.ColumnSelectSQLContext;
import com.easy.query.core.proxy.core.EntitySQLContext;
import com.easy.query.core.proxy.fetcher.EntityFetcher;
import com.easy.query.core.proxy.impl.SQLSelectAllImpl;
import java.util.Collection;

public abstract class AbstractFetcher<TProxy extends AbstractProxyEntity<TProxy, TEntity>, TEntity, TChain extends AbstractFetcher<TProxy, TEntity, TChain>>
implements EntityFetcher<TProxy, TEntity, TChain>,
ProxyEntity<TChain, TEntity> {
    private final TProxy tProxy;
    private final AbstractFetcher<TProxy, TEntity, TChain> prev;
    private SQLSelectAsExpression sqlSelectAsExpression;

    public AbstractFetcher(TProxy tProxy, AbstractFetcher<TProxy, TEntity, TChain> prev, SQLSelectAsExpression sqlSelectAsExpression) {
        this.tProxy = tProxy;
        this.prev = prev;
        this.sqlSelectAsExpression = sqlSelectAsExpression;
    }

    @Override
    public TProxy getProxy() {
        return this.tProxy;
    }

    public TableAvailable getTable() {
        return ((AbstractBaseProxyEntity)this.tProxy).getTable();
    }

    @Override
    public EntitySQLContext getEntitySQLContext() {
        return ((AbstractBaseProxyEntity)this.tProxy).getEntitySQLContext();
    }

    @Override
    public String getValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TChain allFields() {
        SQLSelectAllImpl sqlSelectAsExpression = new SQLSelectAllImpl(((AbstractBaseProxyEntity)this.tProxy).getEntitySQLContext(), ((AbstractBaseProxyEntity)this.tProxy).getTable(), null);
        return this.createFetcher(this.tProxy, this, sqlSelectAsExpression);
    }

    @Override
    public TChain allFieldsExclude(Collection<SQLColumn<TProxy, ?>> ignoreColumns) {
        SQLSelectAllImpl sqlSelectAsExpression = new SQLSelectAllImpl(((AbstractBaseProxyEntity)this.tProxy).getEntitySQLContext(), ((AbstractBaseProxyEntity)this.tProxy).getTable(), (TablePropColumn[])ignoreColumns.stream().toArray(SQLColumn[]::new));
        return this.createFetcher(this.tProxy, this, sqlSelectAsExpression);
    }

    @Override
    public TChain valueObjectColumnExclude(SQLColumn<TProxy, ?> column, Collection<SQLColumn<TProxy, ?>> ignoreColumns) {
        SQLSelectAsExpression columnWithout = SQLSelectAsExpression.createColumnExclude(column, ignoreColumns);
        return this.createFetcher(this.tProxy, this, columnWithout);
    }

    protected abstract TChain createFetcher(TProxy var1, AbstractFetcher<TProxy, TEntity, TChain> var2, SQLSelectAsExpression var3);

    protected TChain add(SQLColumn<TProxy, ?> sqlColumn) {
        SQLSelectAsExpression selectAsExpression = SQLSelectAsExpression.createDefault(((AbstractBaseProxyEntity)this.getProxy()).getEntitySQLContext(), ((AbstractBaseProxyEntity)this.getProxy()).getTable(), sqlColumn.getValue());
        return this.createFetcher(this.tProxy, this, selectAsExpression);
    }

    public TChain columnKeys() {
        SQLSelectAsExpression keys = ((AbstractProxyEntity)this.tProxy).columnKeys();
        return this.createFetcher(this.tProxy, this, keys);
    }

    @Override
    public void accept(AsSelector s) {
        this.acceptAsSelector(s);
    }

    protected void acceptAsSelector(AsSelector s) {
        if (this.prev != null) {
            this.prev.acceptAsSelector(s);
            this.sqlSelectAsExpression.accept(s);
        }
    }

    @Override
    public void accept(Selector s) {
        this.acceptSelector(s);
    }

    protected void acceptSelector(Selector s) {
        if (this.prev != null) {
            this.prev.acceptSelector(s);
            this.sqlSelectAsExpression.accept(s);
        }
    }

    @Override
    public void accept(GroupSelector s) {
        this.acceptGroupSelector(s);
    }

    protected void acceptGroupSelector(GroupSelector s) {
        if (this.prev != null) {
            this.prev.acceptGroupSelector(s);
            this.sqlSelectAsExpression.accept(s);
        }
    }

    @Override
    public void accept(OnlySelector s) {
        this.acceptOnlySelector(s);
    }

    protected void acceptOnlySelector(OnlySelector s) {
        if (this.prev != null) {
            this.prev.acceptOnlySelector(s);
            this.sqlSelectAsExpression.accept(s);
        }
    }

    @Override
    public TChain as(String propertyAlias) {
        this.sqlSelectAsExpression = this.sqlSelectAsExpression.as(propertyAlias);
        return (TChain)this;
    }

    @Override
    public <TEntity, TR> TChain as(Property<TEntity, TR> propertyAlias) {
        this.sqlSelectAsExpression = this.sqlSelectAsExpression.as(propertyAlias);
        return (TChain)this;
    }

    @Override
    public TProxy fetchProxy() {
        AbstractProxyEntity proxy = (AbstractProxyEntity)((AbstractBaseProxyEntity)this.tProxy).create(((AbstractBaseProxyEntity)this.tProxy).getTable(), new ColumnSelectSQLContext());
        proxy.selectExpression(this);
        return (TProxy)proxy;
    }

    @Override
    public TableAvailable getTableOrNull() {
        return null;
    }

    @Override
    public Class<TEntity> getEntityClass() {
        return this.tProxy.getEntityClass();
    }

    @Override
    public TChain create(TableAvailable table, EntitySQLContext entitySQLContext) {
        throw new UnsupportedOperationException("FETCHER is only allowed as the last level in a chain. If further chaining is needed, please convert FETCHER to a Proxy. The specific method is [FETCHER.id().name().fetchProxy()].");
    }
}

