/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy.part.metadata;

import com.easy.query.core.enums.EntityMetadataTypeEnum;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.ColumnOption;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.proxy.part.metadata.PartColumn;
import com.easy.query.core.proxy.part.metadata.PartColumnMetadata;
import com.easy.query.core.util.EasyClassUtil;
import java.util.Map;
import java.util.function.Supplier;

public class PartEntityMetadata
extends EntityMetadata {
    private final EntityMetadata entityMetadata;
    private final Map<String, PartColumn> partColumnMap;

    public PartEntityMetadata(Class<?> entityClass, EntityMetadata entityMetadata, Supplier<Object> beanConstructorCreator, Map<String, PartColumn> partColumnMap) {
        super(entityClass);
        this.entityMetadata = entityMetadata;
        this.partColumnMap = partColumnMap;
        this.entityMetadataType = EntityMetadataTypeEnum.PART;
        this.beanConstructorCreator = beanConstructorCreator;
    }

    public ColumnMetadata getColumnNotNull(String propertyName) {
        ColumnMetadata columnMetadata = this.getColumnOrNull(propertyName);
        if (columnMetadata == null) {
            throw new EasyQueryException(String.format("%s not found property:[%s] mapping column name", EasyClassUtil.getSimpleName((Class)this.getEntityClass()), propertyName));
        }
        return columnMetadata;
    }

    public ColumnMetadata getColumnOrNull(String propertyName) {
        ColumnMetadata partitionByColumn = this.getPartitionByColumn(propertyName);
        if (partitionByColumn != null) {
            return partitionByColumn;
        }
        return this.entityMetadata.getColumnOrNull(propertyName);
    }

    protected ColumnMetadata getPartitionByColumn(String propertyName) {
        PartColumn partColumn = this.partColumnMap.get(propertyName);
        if (partColumn != null) {
            ColumnOption columnOption = new ColumnOption(false, (EntityMetadata)this, propertyName, propertyName, propertyName);
            columnOption.setGetterCaller(partColumn.getGetterCaller());
            columnOption.setSetterCaller(partColumn.getSetterCaller());
            columnOption.setJdbcTypeHandler(partColumn.getJdbcTypeHandler());
            return new PartColumnMetadata(columnOption, propertyName);
        }
        return null;
    }

    public String getPropertyNameOrNull(String columnName, String def) {
        ColumnMetadata columnMetadata = this.getColumnMetadataOrNull(columnName);
        if (columnMetadata == null) {
            return def;
        }
        return columnMetadata.getPropertyName();
    }

    public ColumnMetadata getColumnMetadataOrNull(String columnName) {
        ColumnMetadata partitionByColumn = this.getPartitionByColumn(columnName);
        if (partitionByColumn != null) {
            return partitionByColumn;
        }
        return this.entityMetadata.getColumnMetadataOrNull(columnName);
    }

    public NavigateMetadata getNavigateOrNull(String propertyName) {
        return this.entityMetadata.getNavigateOrNull(propertyName);
    }
}

