/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy.extension.functions;

import com.easy.query.core.expression.lambda.SQLActionExpression1;
import com.easy.query.core.expression.lambda.SQLFuncExpression2;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.SQLFunc;
import com.easy.query.core.func.SQLFunction;
import com.easy.query.core.func.def.enums.DateTimeUnitEnum;
import com.easy.query.core.func.def.enums.TimeUnitEnum;
import com.easy.query.core.proxy.PropTypeColumn;
import com.easy.query.core.proxy.core.EntitySQLContext;
import com.easy.query.core.proxy.core.Expression;
import com.easy.query.core.proxy.extension.functions.ColumnAggregateFilterFunctionAvailable;
import com.easy.query.core.proxy.extension.functions.ColumnObjectFunctionAvailable;
import com.easy.query.core.proxy.extension.functions.cast.ColumnFunctionCastDateTimeAvailable;
import com.easy.query.core.proxy.extension.functions.cast.ColumnFunctionCastStringAvailable;
import com.easy.query.core.proxy.extension.functions.type.BooleanTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.DateTimeTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.NumberTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.StringTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.filter.DateTimeFilterTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.filter.impl.DateTimeFilterTypeExpressionImpl;
import com.easy.query.core.proxy.extension.functions.type.impl.BooleanTypeExpressionImpl;
import com.easy.query.core.proxy.extension.functions.type.impl.DateTimeTypeExpressionImpl;
import com.easy.query.core.proxy.extension.functions.type.impl.NumberTypeExpressionImpl;
import com.easy.query.core.proxy.extension.functions.type.impl.StringTypeExpressionImpl;
import com.easy.query.core.proxy.func.column.ProxyColumnFuncSelector;
import com.easy.query.core.proxy.impl.duration.DurationExpression;
import com.easy.query.core.proxy.predicate.aggregate.DSLSQLFunctionAvailable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.function.Function;

public interface ColumnDateTimeFunctionAvailable<TProperty>
extends ColumnObjectFunctionAvailable<TProperty, DateTimeTypeExpression<TProperty>>,
ColumnAggregateFilterFunctionAvailable<TProperty, DateTimeFilterTypeExpression<TProperty>>,
ColumnFunctionCastStringAvailable<TProperty>,
ColumnFunctionCastDateTimeAvailable<TProperty> {
    @Override
    default public DateTimeFilterTypeExpression<TProperty> max() {
        return this.createFilterChainExpression(this.getCurrentEntitySQLContext(), (PropTypeColumn)this, this.getTable(), this.getValue(), (self, fx) -> fx.max(x -> PropTypeColumn.columnFuncSelector(x, self)), this.getPropertyType());
    }

    @Override
    default public DateTimeFilterTypeExpression<TProperty> min() {
        return this.createFilterChainExpression(this.getCurrentEntitySQLContext(), (PropTypeColumn)this, this.getTable(), this.getValue(), (self, fx) -> fx.min(x -> PropTypeColumn.columnFuncSelector(x, self)), this.getPropertyType());
    }

    default public StringTypeExpression<String> format(String javaFormat) {
        return new StringTypeExpressionImpl<String>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> {
            if (this instanceof DSLSQLFunctionAvailable) {
                SQLFunction sqlFunction = ((DSLSQLFunctionAvailable)((Object)this)).func().apply((SQLFunc)fx);
                return fx.dateTimeFormat(x -> x.sqlFunc(sqlFunction), javaFormat);
            }
            return fx.dateTimeFormat(this.getValue(), javaFormat);
        }, String.class);
    }

    default public DateTimeTypeExpression<TProperty> plus(long duration, TimeUnitEnum timeUnit) {
        return new DateTimeTypeExpressionImpl(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.plusDateTime2(selector -> {
            PropTypeColumn.columnFuncSelector(selector, this);
            selector.value((Object)duration);
        }, timeUnit), this.getPropertyType());
    }

    default public <T extends Number> DateTimeTypeExpression<TProperty> plus(PropTypeColumn<T> durationColumn, TimeUnitEnum timeUnit) {
        return new DateTimeTypeExpressionImpl(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.plusDateTime2(selector -> {
            PropTypeColumn.columnFuncSelector(selector, this);
            PropTypeColumn.columnFuncSelector(selector, durationColumn);
        }, timeUnit), this.getPropertyType());
    }

    default public DateTimeTypeExpression<TProperty> plusDays(long day) {
        return this.plus(day, TimeUnitEnum.DAYS);
    }

    default public <T extends Number> DateTimeTypeExpression<TProperty> plusDays(PropTypeColumn<T> day) {
        return this.plus(day, TimeUnitEnum.DAYS);
    }

    default public DateTimeTypeExpression<TProperty> plusMonths(long month) {
        return this.plus(month, TimeUnitEnum.MONTHS);
    }

    default public <T extends Number> DateTimeTypeExpression<TProperty> plusMonths(PropTypeColumn<T> month) {
        return this.plus(month, TimeUnitEnum.MONTHS);
    }

    default public DateTimeTypeExpression<TProperty> plusYears(long year) {
        return this.plus(year, TimeUnitEnum.YEARS);
    }

    default public <T extends Number> DateTimeTypeExpression<TProperty> plusYears(PropTypeColumn<T> year) {
        return this.plus(year, TimeUnitEnum.YEARS);
    }

    default public DateTimeTypeExpression<TProperty> plusSeconds(long seconds) {
        return this.plus(seconds, TimeUnitEnum.SECONDS);
    }

    default public <T extends Number> DateTimeTypeExpression<TProperty> plusSeconds(PropTypeColumn<T> seconds) {
        return this.plus(seconds, TimeUnitEnum.SECONDS);
    }

    default public DateTimeTypeExpression<TProperty> plusMinutes(long minutes) {
        return this.plus(minutes, TimeUnitEnum.MINUTES);
    }

    default public <T extends Number> DateTimeTypeExpression<TProperty> plusMinutes(PropTypeColumn<T> minutes) {
        return this.plus(minutes, TimeUnitEnum.MINUTES);
    }

    default public DateTimeTypeExpression<TProperty> plusHours(long hours) {
        return this.plus(hours, TimeUnitEnum.HOURS);
    }

    default public <T extends Number> DateTimeTypeExpression<TProperty> plusHours(PropTypeColumn<T> hours) {
        return this.plus(hours, TimeUnitEnum.HOURS);
    }

    default public NumberTypeExpression<Integer> dayOfYear() {
        return this.dateTimeProp(DateTimeUnitEnum.DayOfYear);
    }

    default public NumberTypeExpression<Integer> dayOfWeek() {
        return this.dateTimeProp(DateTimeUnitEnum.DayOfWeek);
    }

    default public NumberTypeExpression<Integer> dayOfWeekSunDayIsLastDay() {
        return this.dateTimeProp(DateTimeUnitEnum.DayOfWeekSunDayLastDay);
    }

    default public NumberTypeExpression<Integer> year() {
        return this.dateTimeProp(DateTimeUnitEnum.Year);
    }

    default public NumberTypeExpression<Integer> month() {
        return this.dateTimeProp(DateTimeUnitEnum.Month);
    }

    default public NumberTypeExpression<Integer> day() {
        return this.dateTimeProp(DateTimeUnitEnum.Day);
    }

    default public NumberTypeExpression<Integer> hour() {
        return this.dateTimeProp(DateTimeUnitEnum.Hour);
    }

    default public NumberTypeExpression<Integer> minute() {
        return this.dateTimeProp(DateTimeUnitEnum.Minute);
    }

    default public NumberTypeExpression<Integer> second() {
        return this.dateTimeProp(DateTimeUnitEnum.Second);
    }

    default public NumberTypeExpression<Integer> dateTimeProp(DateTimeUnitEnum dateTimeUnitEnum) {
        ColumnDateTimeFunctionAvailable propColumn = this;
        return new NumberTypeExpressionImpl<Integer>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> {
            if (propColumn instanceof DSLSQLFunctionAvailable) {
                SQLFunction sqlFunction = ((DSLSQLFunctionAvailable)((Object)propColumn)).func().apply((SQLFunc)fx);
                return fx.dateTimeProperty(sqlFunction, dateTimeUnitEnum);
            }
            return fx.dateTimeProperty(propColumn.getValue(), dateTimeUnitEnum);
        }, Integer.class);
    }

    default public DurationExpression duration(ColumnDateTimeFunctionAvailable<TProperty> after) {
        return new DurationExpression(this, after);
    }

    default public DurationExpression duration(LocalDateTime after) {
        return new DurationExpression(this, Expression.of(this.getEntitySQLContext()).constant(after));
    }

    default public DurationExpression duration(LocalDate after) {
        return new DurationExpression(this, Expression.of(this.getEntitySQLContext()).constant(after));
    }

    default public DurationExpression duration(Date after) {
        return new DurationExpression(this, Expression.of(this.getEntitySQLContext()).constant(after));
    }

    default public <T extends Temporal> void isBefore(T time) {
        BooleanTypeExpression<Boolean> isAfterValue = ColumnDateTimeFunctionAvailable.dateTimeCompareExpression(time, this, this.getCurrentEntitySQLContext(), false);
        Expression.of(this.getCurrentEntitySQLContext()).sql("{0}", (SQLActionExpression1<ProxyColumnFuncSelector>)((SQLActionExpression1)c -> c.expression(isAfterValue)));
    }

    default public <T> void isBefore(ColumnDateTimeFunctionAvailable<T> time) {
        BooleanTypeExpression<Boolean> isAfterValue = ColumnDateTimeFunctionAvailable.dateTimeCompareExpression(time, this, this.getCurrentEntitySQLContext(), false);
        Expression.of(this.getCurrentEntitySQLContext()).sql("{0}", (SQLActionExpression1<ProxyColumnFuncSelector>)((SQLActionExpression1)c -> c.expression(isAfterValue)));
    }

    default public void isBefore(PropTypeColumn<Date> time) {
        BooleanTypeExpression<Boolean> isAfterValue = ColumnDateTimeFunctionAvailable.dateTimeCompareExpression(time, this, this.getCurrentEntitySQLContext(), false);
        Expression.of(this.getCurrentEntitySQLContext()).sql("{0}", (SQLActionExpression1<ProxyColumnFuncSelector>)((SQLActionExpression1)c -> c.expression(isAfterValue)));
    }

    default public <T extends Temporal> void isAfter(T time) {
        BooleanTypeExpression<Boolean> isAfterValue = ColumnDateTimeFunctionAvailable.dateTimeCompareExpression(time, this, this.getCurrentEntitySQLContext(), true);
        Expression.of(this.getCurrentEntitySQLContext()).sql("{0}", (SQLActionExpression1<ProxyColumnFuncSelector>)((SQLActionExpression1)c -> c.expression(isAfterValue)));
    }

    default public <T> void isAfter(ColumnDateTimeFunctionAvailable<T> time) {
        BooleanTypeExpression<Boolean> isAfterValue = ColumnDateTimeFunctionAvailable.dateTimeCompareExpression(time, this, this.getCurrentEntitySQLContext(), true);
        Expression.of(this.getCurrentEntitySQLContext()).sql("{0}", (SQLActionExpression1<ProxyColumnFuncSelector>)((SQLActionExpression1)c -> c.expression(isAfterValue)));
    }

    default public void isAfter(Date time) {
        BooleanTypeExpression<Boolean> isAfterValue = ColumnDateTimeFunctionAvailable.dateTimeCompareExpression(time, this, this.getCurrentEntitySQLContext(), true);
        Expression.of(this.getCurrentEntitySQLContext()).sql("{0}", (SQLActionExpression1<ProxyColumnFuncSelector>)((SQLActionExpression1)c -> c.expression(isAfterValue)));
    }

    public static <TProp> BooleanTypeExpression<Boolean> dateTimeCompareExpression(TProp time, PropTypeColumn<?> propTypeColumn, EntitySQLContext entitySQLContext, boolean isAfter) {
        String operate = isAfter ? ">" : "<";
        return new BooleanTypeExpressionImpl<Boolean>(entitySQLContext, propTypeColumn.getTable(), propTypeColumn.getValue(), fx -> {
            if (propTypeColumn instanceof DSLSQLFunctionAvailable) {
                SQLFunction sqlFunction = ((DSLSQLFunctionAvailable)((Object)propTypeColumn)).func().apply((SQLFunc)fx);
                return fx.anySQLFunction("{0} " + operate + " {1}", s -> {
                    s.sqlFunc(sqlFunction);
                    PropTypeColumn.acceptAnyValue(s, time);
                });
            }
            return fx.anySQLFunction("{0} " + operate + " {1}", s -> {
                s.column(propTypeColumn.getValue());
                PropTypeColumn.acceptAnyValue(s, time);
            });
        }, Boolean.class);
    }

    @Override
    default public DateTimeTypeExpression<TProperty> createChainExpression(EntitySQLContext entitySQLContext, TableAvailable table, String property, Function<SQLFunc, SQLFunction> func, Class<?> propType) {
        return new DateTimeTypeExpressionImpl(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), func, this.getPropertyType());
    }

    @Override
    default public DateTimeFilterTypeExpression<TProperty> createFilterChainExpression(EntitySQLContext entitySQLContext, PropTypeColumn<?> self, TableAvailable table, String property, SQLFuncExpression2<PropTypeColumn<?>, SQLFunc, SQLFunction> func, Class<?> propType) {
        return new DateTimeFilterTypeExpressionImpl(this.getCurrentEntitySQLContext(), this, this.getTable(), this.getValue(), func, this.getPropertyType());
    }
}

