/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.entity.save.diff;

import com.easy.query.api.proxy.entity.save.diff.EntityDiffNode;
import com.easy.query.api.proxy.entity.save.diff.PropertyKey;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.NavigateMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyDiffNode {
    private final EntityMetadata entityMetadata;
    private final NavigateMetadata navigateMetadata;
    private final int deep;
    private final Map<PropertyKey, PropertyDiffNode> childrenMap;
    private final Set<EntityDiffNode> diffNodes;
    private final PropertyKey propertyKey;

    public PropertyDiffNode(@NotNull PropertyKey propertyKey, @NotNull EntityMetadata entityMetadata, @Nullable NavigateMetadata navigateMetadata, int deep) {
        this.entityMetadata = entityMetadata;
        this.navigateMetadata = navigateMetadata;
        this.deep = deep;
        this.childrenMap = new HashMap<PropertyKey, PropertyDiffNode>();
        this.diffNodes = new LinkedHashSet<EntityDiffNode>();
        this.propertyKey = propertyKey;
    }

    public EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    public NavigateMetadata getNavigateMetadata() {
        return this.navigateMetadata;
    }

    public List<PropertyDiffNode> getChildren() {
        return new ArrayList<PropertyDiffNode>(this.childrenMap.values());
    }

    public PropertyDiffNode addChild(PropertyDiffNode propertyDiffNode) {
        return this.childrenMap.computeIfAbsent(propertyDiffNode.propertyKey, propertyKey1 -> propertyDiffNode);
    }

    public Set<EntityDiffNode> getDiffNodes() {
        return this.diffNodes;
    }

    public int getDeep() {
        return this.deep;
    }

    public PropertyKey getNavigateKey() {
        return this.propertyKey;
    }
}

