/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.entity.save.provider;

import com.easy.query.api.proxy.entity.save.DatabaseEntityValues;
import com.easy.query.api.proxy.entity.save.MemoryAddressCompareValue;
import com.easy.query.api.proxy.entity.save.SavableContext;
import com.easy.query.api.proxy.entity.save.SaveBehavior;
import com.easy.query.api.proxy.entity.save.SaveBehaviorEnum;
import com.easy.query.api.proxy.entity.save.SaveNode;
import com.easy.query.api.proxy.entity.save.SaveNodeDbTypeEnum;
import com.easy.query.api.proxy.entity.save.TargetValueTypeEnum;
import com.easy.query.api.proxy.entity.save.command.EmptySaveCommand;
import com.easy.query.api.proxy.entity.save.command.SaveCommand;
import com.easy.query.api.proxy.entity.save.diff.EntityDiffNode;
import com.easy.query.api.proxy.entity.save.diff.PropertyDiffNode;
import com.easy.query.api.proxy.entity.save.diff.PropertyKey;
import com.easy.query.api.proxy.entity.save.provider.AbstractSaveProvider2;
import com.easy.query.api.proxy.entity.save.provider.DeleteValueObject;
import com.easy.query.core.api.client.EasyQueryClient;
import com.easy.query.core.basic.extension.track.EntityState;
import com.easy.query.core.basic.extension.track.EntityValueState;
import com.easy.query.core.basic.extension.track.TrackContext;
import com.easy.query.core.enums.CascadeTypeEnum;
import com.easy.query.core.enums.RelationTypeEnum;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.util.EasyArrayUtil;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyTrackUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoTrackSaveProvider2
extends AbstractSaveProvider2 {
    public AutoTrackSaveProvider2(TrackContext currentTrackContext, Class<?> entityClass, List<Object> entities, EasyQueryClient easyQueryClient, List<Set<String>> savePathLimit, SaveBehavior saveBehavior, boolean removeRoot) {
        super(currentTrackContext, entityClass, entities, easyQueryClient, savePathLimit, saveBehavior, removeRoot);
    }

    @Override
    public SaveCommand createCommand() {
        if (EasyCollectionUtil.isNotEmpty((Collection)this.entities)) {
            EntityMetadata entityMetadata = this.entityMetadataManager.getEntityMetadata(this.entityClass);
            PropertyKey propertyKey = new PropertyKey(null, entityMetadata.getEntityClass(), null);
            PropertyDiffNode propertyDiffNode = new PropertyDiffNode(propertyKey, entityMetadata, null, 0);
            for (Object entity : this.entities) {
                if (this.saveCommandContext.isProcessEntity(entity)) {
                    throw new EasyQueryInvalidOperationException("entity:" + entity + " has been added to the save command");
                }
                this.saveCommandContext.addProcessEntity(entity);
                EntityState entityState = this.currentTrackContext.getTrackEntityState(entity);
                this.processSaveDiffNode(propertyDiffNode, null, entity, entityState, entityMetadata, null);
                System.out.println(propertyDiffNode);
            }
            return EmptySaveCommand.INSTANCE;
        }
        return EmptySaveCommand.INSTANCE;
    }

    private void processSaveDiffNode(@NotNull PropertyDiffNode parentNode, Class<?> from, @Nullable Object after, @Nullable EntityState trackEntityState, EntityMetadata entityMetadata, NavigateMetadata entityNavigateMetadata) {
        if (after == null && trackEntityState == null) {
            return;
        }
        PropertyKey propertyKey = new PropertyKey(from, entityMetadata.getEntityClass(), entityNavigateMetadata);
        PropertyDiffNode diffNode = new PropertyDiffNode(propertyKey, entityMetadata, entityNavigateMetadata, parentNode.getDeep() + 1);
        PropertyDiffNode propertyDiffNode = parentNode.addChild(diffNode);
        Object before = this.getTrackBeforeEntity(trackEntityState);
        EntityDiffNode entityDiffNode = new EntityDiffNode(before, after, propertyDiffNode);
        propertyDiffNode.getDiffNodes().add(entityDiffNode);
        for (NavigateMetadata navigateMetadata : entityMetadata.getNavigateMetadatas()) {
            Object navigates;
            Object navigates2;
            Object targetEntity;
            Object collection;
            Property getter;
            if (EasyArrayUtil.isNotEmpty((Object[])navigateMetadata.getDirectMapping())) continue;
            EntityMetadata targetEntityMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getNavigatePropertyType());
            if (entityDiffNode.isInsert()) {
                getter = navigateMetadata.getGetter();
                Object navigates22 = getter.apply(entityDiffNode.getAfter());
                if (navigates22 == null) continue;
                if (navigates22 instanceof Collection) {
                    collection = (Collection)navigates22;
                    if (collection.isEmpty() && this.saveBehavior.hasBehavior(SaveBehaviorEnum.IGNORE_EMPTY)) continue;
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        targetEntity = iterator.next();
                        this.processSaveDiffNode(propertyDiffNode, entityMetadata.getEntityClass(), targetEntity, this.currentTrackContext.getTrackEntityState(targetEntity), targetEntityMetadata, navigateMetadata);
                    }
                    continue;
                }
                this.processSaveDiffNode(propertyDiffNode, entityMetadata.getEntityClass(), navigates22, this.currentTrackContext.getTrackEntityState(navigates22), targetEntityMetadata, navigateMetadata);
                continue;
            }
            if (entityDiffNode.isUpdate()) {
                if (trackEntityState == null) {
                    throw new EasyQueryInvalidOperationException("trackEntityState is null");
                }
                Set trackKeys = trackEntityState.getTrackKeys(navigateMetadata, new HashSet());
                if (!EasyCollectionUtil.isNotEmpty((Collection)trackKeys)) continue;
                DatabaseEntityValues databaseEntityValues = new DatabaseEntityValues(navigateMetadata, targetEntityMetadata, this.runtimeContext);
                for (String trackKey : trackKeys) {
                    EntityState entityState = this.currentTrackContext.getTrackEntityState(navigateMetadata.getNavigatePropertyType(), trackKey);
                    Objects.requireNonNull(entityState, "trackEntityState cant be null,trackKey:" + trackKey);
                    databaseEntityValues.put(trackKey, entityState.getCurrentValue());
                }
                Property getter2 = navigateMetadata.getGetter();
                navigates2 = getter2.apply(entityDiffNode.getAfter());
                if (navigates2 instanceof Collection) {
                    Collection collection2 = (Collection)navigates2;
                    if (!collection2.isEmpty() || !this.saveBehavior.hasBehavior(SaveBehaviorEnum.IGNORE_EMPTY)) {
                        Iterator iterator = collection2.iterator();
                        while (iterator.hasNext()) {
                            Object targetEntity2 = iterator.next();
                            databaseEntityValues.checkSaveKeyRepeat(targetEntity2);
                            this.mergeEntityIfUpdate(databaseEntityValues, targetEntity2, targetEntityMetadata);
                            this.processSaveDiffNode(propertyDiffNode, entityMetadata.getEntityClass(), targetEntity2, this.currentTrackContext.getTrackEntityState(targetEntity2), targetEntityMetadata, navigateMetadata);
                        }
                    }
                } else if (navigates2 != null) {
                    databaseEntityValues.checkSaveKeyRepeat(navigates2);
                    this.mergeEntityIfUpdate(databaseEntityValues, navigates2, targetEntityMetadata);
                    this.processSaveDiffNode(propertyDiffNode, entityMetadata.getEntityClass(), navigates2, this.currentTrackContext.getTrackEntityState(navigates2), targetEntityMetadata, navigateMetadata);
                }
                for (Object e : databaseEntityValues.values()) {
                    String trackKey = EasyTrackUtil.getTrackKey((EntityMetadata)targetEntityMetadata, e);
                    EntityState entityState = this.currentTrackContext.getTrackEntityState(targetEntityMetadata.getEntityClass(), trackKey);
                    this.processSaveDiffNode(propertyDiffNode, entityMetadata.getEntityClass(), null, entityState, targetEntityMetadata, navigateMetadata);
                }
                continue;
            }
            if (!entityDiffNode.isDelete() || (navigates = (getter = navigateMetadata.getGetter()).apply(entityDiffNode.getBefore())) == null) continue;
            if (navigates instanceof Collection) {
                collection = (Collection)navigates;
                if (collection.isEmpty() && this.saveBehavior.hasBehavior(SaveBehaviorEnum.IGNORE_EMPTY)) continue;
                navigates2 = collection.iterator();
                while (navigates2.hasNext()) {
                    targetEntity = navigates2.next();
                    String string = EasyTrackUtil.getTrackKey((EntityMetadata)targetEntityMetadata, targetEntity);
                    EntityState entityState = this.currentTrackContext.getTrackEntityState(targetEntityMetadata.getEntityClass(), string);
                    this.processSaveDiffNode(propertyDiffNode, entityMetadata.getEntityClass(), null, entityState, targetEntityMetadata, navigateMetadata);
                }
                continue;
            }
            String trackKey = EasyTrackUtil.getTrackKey((EntityMetadata)targetEntityMetadata, (Object)navigates);
            EntityState entityState = this.currentTrackContext.getTrackEntityState(targetEntityMetadata.getEntityClass(), trackKey);
            this.processSaveDiffNode(propertyDiffNode, entityMetadata.getEntityClass(), null, entityState, targetEntityMetadata, navigateMetadata);
        }
    }

    private Object getTrackBeforeEntity(@Nullable EntityState entityState) {
        if (entityState != null) {
            return entityState.getOriginalValue();
        }
        return null;
    }

    private void cleanNavigates(Object entity, EntityMetadata entityMetadata) {
        if (this.removeRoot) {
            Collection navigateMetadatas = entityMetadata.getNavigateMetadatas();
            for (NavigateMetadata navigateMetadata : navigateMetadatas) {
                navigateMetadata.getSetter().call(entity, null);
            }
        }
    }

    private void saveSelf(Object entity, EntityState entityState, EntityMetadata entityMetadata, int deep) {
        SavableContext savableContext = this.saveCommandContext.getCreateSavableContext(deep);
        Collection navigateMetadataList = entityState == null ? entityMetadata.getNavigateMetadatas() : entityState.getIncludes();
        List<NavigateMetadata> valueObjects = this.getNavigateSavableValueObjects(entityState, savableContext, entity, entityMetadata, navigateMetadataList, deep);
        for (NavigateMetadata navigateMetadata : valueObjects) {
            if (entityState == null) {
                this.valueObjectInsert(entity, entityMetadata, navigateMetadata, savableContext);
                continue;
            }
            Set trackKeys = entityState.getTrackKeys(navigateMetadata);
            this.valueObjectUpdate(entity, entityMetadata, navigateMetadata, savableContext, trackKeys == null ? new HashSet() : trackKeys);
        }
    }

    private void deleteSelf(Object entity, EntityMetadata entityMetadata, int deep) {
        EntityState entityState = this.currentTrackContext.getTrackEntityState(entity);
        if (entityState != null) {
            SavableContext savableContext = this.saveCommandContext.getCreateSavableContext(deep);
            List navigateMetadataList = entityState.getIncludes();
            List<NavigateMetadata> valueObjects = this.getNavigateSavableValueObjects(entityState, savableContext, entity, entityMetadata, navigateMetadataList, deep);
            Iterator<NavigateMetadata> iterator = valueObjects.iterator();
            while (iterator.hasNext()) {
                NavigateMetadata navigateMetadata;
                Set trackKeys = entityState.getTrackKeys(navigateMetadata = iterator.next());
                this.valueObjectDelete(entity, entityMetadata, navigateMetadata, savableContext, trackKeys == null ? new HashSet() : trackKeys);
            }
        }
    }

    private void valueObjectDelete(Object entity, EntityMetadata selfEntityMetadata, NavigateMetadata navigateMetadata, SavableContext savableContext, Set<String> trackKeys) {
        if (trackKeys != null) {
            if (EasyArrayUtil.isNotEmpty((Object[])navigateMetadata.getDirectMapping())) {
                return;
            }
            EntityMetadata targetEntityMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getNavigatePropertyType());
            SaveNode saveNode = savableContext.getSaveNode(navigateMetadata);
            if (saveNode == null) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "." + EasyClassUtil.getSimpleName((Class)navigateMetadata.getNavigatePropertyType()) + "] save node is null");
            }
            for (String trackKey : trackKeys) {
                EntityState trackEntityState = this.currentTrackContext.getTrackEntityState(navigateMetadata.getNavigatePropertyType(), trackKey);
                Objects.requireNonNull(trackEntityState, "trackEntityState cant be null,trackKey:" + trackKey);
                this.saveNodeDelete(entity, trackEntityState.getCurrentValue(), selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode, false);
                this.deleteSelf(trackEntityState.getCurrentValue(), targetEntityMetadata, saveNode.getIndex() + 1);
            }
        }
    }

    private void valueObjectInsert(Object entity, EntityMetadata selfEntityMetadata, NavigateMetadata navigateMetadata, SavableContext savableContext) {
        if (EasyArrayUtil.isNotEmpty((Object[])navigateMetadata.getDirectMapping())) {
            throw new EasyQueryInvalidOperationException("save not support direct mapping");
        }
        EntityMetadata targetEntityMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getNavigatePropertyType());
        SaveNode saveNode = savableContext.getSaveNode(navigateMetadata);
        DatabaseEntityValues databaseEntityValues = new DatabaseEntityValues(navigateMetadata, targetEntityMetadata, this.runtimeContext);
        Property getter = navigateMetadata.getGetter();
        Object navigates = getter.apply(entity);
        if (navigates instanceof Collection) {
            Collection collection = (Collection)navigates;
            if (collection.isEmpty() && this.saveBehavior.hasBehavior(SaveBehaviorEnum.IGNORE_EMPTY)) {
                return;
            }
            for (Object targetEntity : collection) {
                databaseEntityValues.checkSaveKeyRepeat(targetEntity);
                this.valueObjectEntityInsert(entity, targetEntity, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
            }
        } else if (navigates != null) {
            databaseEntityValues.checkSaveKeyRepeat(navigates);
            this.valueObjectEntityInsert(entity, navigates, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
        }
    }

    private void valueObjectEntityInsert(Object selfEntity, Object targetEntity, EntityMetadata selfEntityMetadata, EntityMetadata targetEntityMetadata, NavigateMetadata navigateMetadata, SaveNode saveNode) {
        this.saveNodeInsert(selfEntity, targetEntity, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
        if (navigateMetadata.getRelationType() != RelationTypeEnum.ManyToMany && navigateMetadata.getCascade() == CascadeTypeEnum.DELETE) {
            EntityState entityState = this.currentTrackContext.getTrackEntityState(targetEntity);
            this.saveSelf(targetEntity, entityState, targetEntityMetadata, saveNode.getIndex() + 1);
        }
    }

    private void valueObjectUpdate(Object entity, EntityMetadata selfEntityMetadata, NavigateMetadata navigateMetadata, SavableContext savableContext, Set<String> trackKeys) {
        if (trackKeys != null) {
            if (EasyArrayUtil.isNotEmpty((Object[])navigateMetadata.getDirectMapping())) {
                throw new EasyQueryInvalidOperationException("save not support direct mapping");
            }
            EntityMetadata targetEntityMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getNavigatePropertyType());
            SaveNode saveNode = savableContext.getSaveNode(navigateMetadata);
            if (saveNode == null) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "." + EasyClassUtil.getSimpleName((Class)navigateMetadata.getNavigatePropertyType()) + "] save node is null");
            }
            DatabaseEntityValues databaseEntityValues = new DatabaseEntityValues(navigateMetadata, targetEntityMetadata, this.runtimeContext);
            for (String trackKey : trackKeys) {
                EntityState trackEntityState = this.currentTrackContext.getTrackEntityState(navigateMetadata.getNavigatePropertyType(), trackKey);
                Objects.requireNonNull(trackEntityState, "trackEntityState cant be null,trackKey:" + trackKey);
                databaseEntityValues.put(trackKey, trackEntityState.getCurrentValue());
            }
            Property getter = navigateMetadata.getGetter();
            Object navigates = getter.apply(entity);
            if (navigates instanceof Collection) {
                Collection collection = (Collection)navigates;
                if (collection.isEmpty() && this.saveBehavior.hasBehavior(SaveBehaviorEnum.IGNORE_EMPTY)) {
                    return;
                }
                for (Object targetEntity : collection) {
                    databaseEntityValues.checkSaveKeyRepeat(targetEntity);
                    this.valueObjectEntityInsertUpdate(databaseEntityValues, entity, targetEntity, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
                }
            } else if (navigates != null) {
                databaseEntityValues.checkSaveKeyRepeat(navigates);
                this.valueObjectEntityInsertUpdate(databaseEntityValues, entity, navigates, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
            } else if (this.saveBehavior.hasBehavior(SaveBehaviorEnum.IGNORE_NULL)) {
                return;
            }
            for (Object value : databaseEntityValues.values()) {
                this.saveNodeDelete(entity, value, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode, true);
            }
        }
    }

    private void valueObjectEntityInsertUpdate(DatabaseEntityValues databaseEntityValues, Object selfEntity, Object targetEntity, EntityMetadata selfEntityMetadata, EntityMetadata targetEntityMetadata, NavigateMetadata navigateMetadata, SaveNode saveNode) {
        EntityState entityState = null;
        String newNavigateEntityKey = databaseEntityValues.getTrackKey(targetEntity);
        if (newNavigateEntityKey == null || !databaseEntityValues.containsKey(newNavigateEntityKey)) {
            this.saveNodeInsert(selfEntity, targetEntity, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
            entityState = this.currentTrackContext.getTrackEntityState(targetEntity);
        } else {
            databaseEntityValues.remove(newNavigateEntityKey);
            EntityState trackEntityState = this.currentTrackContext.getTrackEntityState(navigateMetadata.getNavigatePropertyType(), newNavigateEntityKey);
            Objects.requireNonNull(trackEntityState, "trackEntityState cant be null,trackKey:" + newNavigateEntityKey);
            if (targetEntity != trackEntityState.getCurrentValue()) {
                this.mergeEntityWithTrackEntity(targetEntity, trackEntityState.getCurrentValue(), targetEntityMetadata);
            }
            this.saveNodeUpdate(trackEntityState, selfEntity, trackEntityState.getCurrentValue(), selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
            entityState = this.currentTrackContext.getTrackEntityState(trackEntityState.getCurrentValue());
        }
        if (navigateMetadata.getRelationType() != RelationTypeEnum.ManyToMany && navigateMetadata.getCascade() == CascadeTypeEnum.DELETE) {
            this.saveSelf(targetEntity, entityState, targetEntityMetadata, saveNode.getIndex() + 1);
        }
    }

    private void mergeEntityIfUpdate(DatabaseEntityValues databaseEntityValues, Object targetEntity, EntityMetadata targetEntityMetadata) {
        String newNavigateEntityKey = databaseEntityValues.getTrackKey(targetEntity);
        if (newNavigateEntityKey != null && databaseEntityValues.containsKey(newNavigateEntityKey)) {
            databaseEntityValues.remove(newNavigateEntityKey);
            EntityState trackEntityState = this.currentTrackContext.getTrackEntityState(targetEntityMetadata.getEntityClass(), newNavigateEntityKey);
            Objects.requireNonNull(trackEntityState, "trackEntityState cant be null,trackKey:" + newNavigateEntityKey);
            if (targetEntity != trackEntityState.getCurrentValue()) {
                this.mergeEntityWithTrackEntity(targetEntity, trackEntityState.getCurrentValue(), targetEntityMetadata);
            }
        }
    }

    private void mergeEntityWithTrackEntity(Object source, Object currentEntity, EntityMetadata entityMetadata) {
        for (Map.Entry propColumn : entityMetadata.getProperty2ColumnMap().entrySet()) {
            String key = (String)propColumn.getKey();
            ColumnMetadata columnMetadata = (ColumnMetadata)propColumn.getValue();
            Object sourceValue = columnMetadata.getGetterCaller().apply(source);
            boolean keyProperty = entityMetadata.isKeyProperty(key);
            if (keyProperty) {
                if (sourceValue != null) continue;
                Object value = columnMetadata.getGetterCaller().apply(currentEntity);
                columnMetadata.getSetterCaller().call(source, value);
                continue;
            }
            columnMetadata.getSetterCaller().call(currentEntity, sourceValue);
        }
    }

    private void saveNodeDelete(Object selfEntity, Object targetEntity, EntityMetadata selfEntityMetadata, EntityMetadata targetEntityMetadata, NavigateMetadata navigateMetadata, SaveNode saveNode, boolean first) {
        if (navigateMetadata.getCascade() == CascadeTypeEnum.NO_ACTION) {
            return;
        }
        if (navigateMetadata.getRelationType() == RelationTypeEnum.ManyToMany) {
            if (navigateMetadata.getMappingClass() == null) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "." + navigateMetadata.getPropertyName() + "] many to many relation must have mapping class");
            }
            EntityMetadata mappingClassEntityMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getMappingClass());
            Object mappingEntity = mappingClassEntityMetadata.getBeanConstructorCreator().get();
            this.setMappingEntity(selfEntity, targetEntity, mappingEntity, selfEntityMetadata, navigateMetadata, targetEntityMetadata, mappingClassEntityMetadata);
            saveNode.getDeleteBys().add(mappingEntity);
        } else {
            if (navigateMetadata.getCascade() == CascadeTypeEnum.AUTO || navigateMetadata.getCascade() == CascadeTypeEnum.SET_NULL) {
                boolean prosHasKey = this.targetAnyPropsIsKey(selfEntityMetadata, navigateMetadata);
                if (prosHasKey) {
                    throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)selfEntityMetadata.getEntityClass()) + "." + navigateMetadata.getPropertyName() + "] targetProperty has key props,cascade cant use set null");
                }
                saveNode.putDeleteItem(new MemoryAddressCompareValue(targetEntity), selfEntity, t -> this.setTargetNullValue(TargetValueTypeEnum.VALUE_OBJECT, selfEntity, targetEntity, selfEntityMetadata, navigateMetadata, targetEntityMetadata), SaveNodeDbTypeEnum.UPDATE);
            }
            if (navigateMetadata.getCascade() == CascadeTypeEnum.DELETE) {
                MemoryAddressCompareValue deleteEntity = new MemoryAddressCompareValue(targetEntity);
                saveNode.putDeleteItem(deleteEntity, null, null, SaveNodeDbTypeEnum.DELETE);
                if (first) {
                    DeleteValueObject deleteValueObject = new DeleteValueObject(targetEntity, targetEntityMetadata, saveNode);
                    this.deleteValueObjectMap.computeIfAbsent(deleteEntity, k -> deleteValueObject);
                }
            }
        }
    }

    private void saveNodeUpdate(EntityState trackEntityState, Object selfEntity, Object targetEntity, EntityMetadata selfEntityMetadata, EntityMetadata targetEntityMetadata, NavigateMetadata navigateMetadata, SaveNode saveNode) {
        if (navigateMetadata.getCascade() == CascadeTypeEnum.NO_ACTION) {
            return;
        }
        if (navigateMetadata.getRelationType() == RelationTypeEnum.ManyToMany) {
            if (navigateMetadata.getMappingClass() == null) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "." + navigateMetadata.getPropertyName() + "] many to many relation must have mapping class");
            }
            return;
        }
        boolean hasChanged = false;
        for (Map.Entry propColumn : targetEntityMetadata.getProperty2ColumnMap().entrySet()) {
            EntityValueState entityValueState = trackEntityState.getEntityValueState((ColumnMetadata)propColumn.getValue());
            if (!entityValueState.isChanged()) continue;
            hasChanged = true;
            break;
        }
        if (hasChanged) {
            saveNode.putUpdateItem(new MemoryAddressCompareValue(targetEntity), selfEntity, t -> this.setTargetValue(TargetValueTypeEnum.VALUE_OBJECT, selfEntity, t, selfEntityMetadata, navigateMetadata, targetEntityMetadata));
        } else {
            saveNode.putIgnoreUpdateItem(new MemoryAddressCompareValue(targetEntity), selfEntity, null);
        }
    }

    private void saveNodeInsert(Object selfEntity, Object targetEntity, EntityMetadata selfEntityMetadata, EntityMetadata targetEntityMetadata, NavigateMetadata navigateMetadata, SaveNode saveNode) {
        if (navigateMetadata.getCascade() == CascadeTypeEnum.NO_ACTION) {
            return;
        }
        if (navigateMetadata.getRelationType() == RelationTypeEnum.ManyToMany) {
            if (navigateMetadata.getMappingClass() == null) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "." + navigateMetadata.getPropertyName() + "] many to many relation must have mapping class");
            }
            if (navigateMetadata.getCascade() == CascadeTypeEnum.DELETE) {
                EntityMetadata mappingClassEntityMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getMappingClass());
                Object mappingEntity = mappingClassEntityMetadata.getBeanConstructorCreator().get();
                saveNode.putInsertItem(new MemoryAddressCompareValue(mappingEntity), selfEntity, t -> this.setMappingEntity(selfEntity, targetEntity, t, selfEntityMetadata, navigateMetadata, targetEntityMetadata, mappingClassEntityMetadata));
            }
        } else if (navigateMetadata.getCascade() == CascadeTypeEnum.AUTO || navigateMetadata.getCascade() == CascadeTypeEnum.SET_NULL) {
            String trackKey = EasyTrackUtil.getTrackKey((EntityMetadata)targetEntityMetadata, (Object)targetEntity);
            if (trackKey == null) {
                throw new EasyQueryInvalidOperationException("entity:[" + selfEntityMetadata.getEntityClass() + "." + navigateMetadata.getPropertyName() + "] track key is null,entity:[" + targetEntity + "]");
            }
            EntityState trackEntityState = this.currentTrackContext.getTrackEntityState(targetEntityMetadata.getEntityClass(), trackKey);
            if (trackEntityState == null) {
                throw new EasyQueryInvalidOperationException("entity:[" + selfEntityMetadata.getEntityClass() + "." + navigateMetadata.getPropertyName() + "] track key:[" + trackKey + "] not found in track context");
            }
            saveNode.putUpdateItem(new MemoryAddressCompareValue(targetEntity), selfEntity, t -> this.setTargetValue(TargetValueTypeEnum.VALUE_OBJECT, selfEntity, t, selfEntityMetadata, navigateMetadata, targetEntityMetadata));
        } else if (navigateMetadata.getCascade() == CascadeTypeEnum.DELETE) {
            String trackKey = EasyTrackUtil.getTrackKey((EntityMetadata)targetEntityMetadata, (Object)targetEntity);
            EntityState trackEntityState = this.currentTrackContext.getTrackEntityState(targetEntityMetadata.getEntityClass(), trackKey);
            if (trackEntityState != null) {
                Object currentValue = trackEntityState.getCurrentValue();
                if (targetEntity != currentValue) {
                    this.mergeEntityWithTrackEntity(targetEntity, currentValue, targetEntityMetadata);
                }
                saveNode.putInsertItem(new MemoryAddressCompareValue(currentValue), selfEntity, t -> this.setTargetValue(TargetValueTypeEnum.VALUE_OBJECT, selfEntity, t, selfEntityMetadata, navigateMetadata, targetEntityMetadata));
            } else {
                saveNode.putInsertItem(new MemoryAddressCompareValue(targetEntity), selfEntity, t -> this.setTargetValue(TargetValueTypeEnum.VALUE_OBJECT, selfEntity, t, selfEntityMetadata, navigateMetadata, targetEntityMetadata));
            }
        } else {
            throw new EasyQueryInvalidOperationException("value object un support operate cascade:" + navigateMetadata.getCascade());
        }
    }
}

