/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy;

import com.easy.query.core.annotation.Nullable;
import com.easy.query.core.context.EmptyQueryRuntimeContext;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.implicit.EntityRelationPropertyProvider;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.sql.builder.EntityExpressionBuilder;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.proxy.ProxyEntity;
import com.easy.query.core.proxy.available.EntitySQLContextAvailable;
import com.easy.query.core.proxy.columns.SQLAnyColumn;
import com.easy.query.core.proxy.columns.SQLBooleanColumn;
import com.easy.query.core.proxy.columns.SQLDateTimeColumn;
import com.easy.query.core.proxy.columns.SQLManyQueryable;
import com.easy.query.core.proxy.columns.SQLNumberColumn;
import com.easy.query.core.proxy.columns.SQLStringColumn;
import com.easy.query.core.proxy.columns.SubQueryContext;
import com.easy.query.core.proxy.columns.impl.PropertySQLManyQueryable;
import com.easy.query.core.proxy.columns.impl.SQLAnyColumnImpl;
import com.easy.query.core.proxy.columns.impl.SQLBooleanColumnImpl;
import com.easy.query.core.proxy.columns.impl.SQLDateTimeColumnImpl;
import com.easy.query.core.proxy.columns.impl.SQLNumberColumnImpl;
import com.easy.query.core.proxy.columns.impl.SQLStringColumnImpl;
import com.easy.query.core.proxy.columns.types.SQLAnyTypeColumn;
import com.easy.query.core.proxy.columns.types.SQLBigDecimalTypeColumn;
import com.easy.query.core.proxy.columns.types.SQLBooleanTypeColumn;
import com.easy.query.core.proxy.columns.types.SQLByteTypeColumn;
import com.easy.query.core.proxy.columns.types.SQLDateTypeColumn;
import com.easy.query.core.proxy.columns.types.SQLDoubleTypeColumn;
import com.easy.query.core.proxy.columns.types.SQLFloatTypeColumn;
import com.easy.query.core.proxy.columns.types.SQLIntegerTypeColumn;
import com.easy.query.core.proxy.columns.types.SQLLocalDateTimeTypeColumn;
import com.easy.query.core.proxy.columns.types.SQLLocalDateTypeColumn;
import com.easy.query.core.proxy.columns.types.SQLLocalTimeTypeColumn;
import com.easy.query.core.proxy.columns.types.SQLLongTypeColumn;
import com.easy.query.core.proxy.columns.types.SQLShortTypeColumn;
import com.easy.query.core.proxy.columns.types.SQLStringTypeColumn;
import com.easy.query.core.proxy.columns.types.SQLTimeTypeColumn;
import com.easy.query.core.proxy.columns.types.SQLTimestampTypeColumn;
import com.easy.query.core.proxy.columns.types.SQLUUIDTypeColumn;
import com.easy.query.core.proxy.columns.types.SQLUtilDateTypeColumn;
import com.easy.query.core.proxy.columns.types.impl.SQLAnyTypeColumnImpl;
import com.easy.query.core.proxy.columns.types.impl.SQLBigDecimalTypeColumnImpl;
import com.easy.query.core.proxy.columns.types.impl.SQLBooleanTypeColumnImpl;
import com.easy.query.core.proxy.columns.types.impl.SQLByteTypeColumnImpl;
import com.easy.query.core.proxy.columns.types.impl.SQLDateTypeColumnImpl;
import com.easy.query.core.proxy.columns.types.impl.SQLDoubleTypeColumnImpl;
import com.easy.query.core.proxy.columns.types.impl.SQLFloatTypeColumnImpl;
import com.easy.query.core.proxy.columns.types.impl.SQLIntegerTypeColumnImpl;
import com.easy.query.core.proxy.columns.types.impl.SQLLocalDateTimeTypeColumnImpl;
import com.easy.query.core.proxy.columns.types.impl.SQLLocalDateTypeColumnImpl;
import com.easy.query.core.proxy.columns.types.impl.SQLLocalTimeTypeColumnImpl;
import com.easy.query.core.proxy.columns.types.impl.SQLLongTypeColumnImpl;
import com.easy.query.core.proxy.columns.types.impl.SQLShortTypeColumnImpl;
import com.easy.query.core.proxy.columns.types.impl.SQLStringTypeColumnImpl;
import com.easy.query.core.proxy.columns.types.impl.SQLTimeTypeColumnImpl;
import com.easy.query.core.proxy.columns.types.impl.SQLTimestampTypeColumnImpl;
import com.easy.query.core.proxy.columns.types.impl.SQLUUIDTypeColumnImpl;
import com.easy.query.core.proxy.columns.types.impl.SQLUtilDateTypeColumnImpl;
import com.easy.query.core.proxy.core.ColumnSelectSQLContext;
import com.easy.query.core.proxy.core.EntitySQLContext;
import com.easy.query.core.util.EasyObjectUtil;
import com.easy.query.core.util.EasyRelationalUtil;
import java.util.Objects;

public abstract class AbstractBaseProxyEntity<TProxy extends ProxyEntity<TProxy, TEntity>, TEntity>
implements ProxyEntity<TProxy, TEntity>,
EntitySQLContextAvailable {
    protected TableAvailable table;
    protected EntitySQLContext entitySQLContext = new ColumnSelectSQLContext();
    private String propValue;

    @Override
    public String getNavValue() {
        return this.propValue;
    }

    @Override
    public void setNavValue(String val) {
        this.propValue = val;
    }

    @Nullable
    public TableAvailable getTable() {
        return this.table;
    }

    @Override
    public TableAvailable getTableOrNull() {
        return this.table;
    }

    @Override
    public EntitySQLContext getEntitySQLContext() {
        Objects.requireNonNull(this.entitySQLContext, "cant found entitySQLContext in sql context");
        return this.entitySQLContext;
    }

    @Override
    public TProxy create(TableAvailable table, EntitySQLContext entitySQLContext) {
        this.table = table;
        this.entitySQLContext = entitySQLContext;
        return (TProxy)((ProxyEntity)EasyObjectUtil.typeCastNullable((Object)this));
    }

    protected <TProperty> SQLDateTimeColumn<TProxy, TProperty> getDateTimeColumn(String property, @Nullable Class<TProperty> propType) {
        SQLDateTimeColumnImpl<TProxy, TProperty> column = new SQLDateTimeColumnImpl<TProxy, TProperty>(this.entitySQLContext, this.table, property, propType);
        column._setProxy(this.castChain());
        return column;
    }

    protected <TProperty> SQLNumberColumn<TProxy, TProperty> getNumberColumn(String property, @Nullable Class<TProperty> propType) {
        SQLNumberColumnImpl<TProxy, TProperty> column = new SQLNumberColumnImpl<TProxy, TProperty>(this.entitySQLContext, this.table, property, propType);
        column._setProxy(this.castChain());
        return column;
    }

    protected <TProperty> SQLStringColumn<TProxy, TProperty> getStringColumn(String property, @Nullable Class<TProperty> propType) {
        SQLStringColumnImpl<TProxy, TProperty> column = new SQLStringColumnImpl<TProxy, TProperty>(this.entitySQLContext, this.table, property, propType);
        column._setProxy(this.castChain());
        return column;
    }

    protected <TProperty> SQLBooleanColumn<TProxy, TProperty> getBooleanColumn(String property, @Nullable Class<TProperty> propType) {
        SQLBooleanColumnImpl<TProxy, TProperty> column = new SQLBooleanColumnImpl<TProxy, TProperty>(this.entitySQLContext, this.table, property, propType);
        column._setProxy(this.castChain());
        return column;
    }

    protected <TProperty> SQLAnyColumn<TProxy, TProperty> getAnyColumn(String property, @Nullable Class<TProperty> propType) {
        SQLAnyColumnImpl<TProxy, TProperty> column = new SQLAnyColumnImpl<TProxy, TProperty>(this.entitySQLContext, this.table, property, propType);
        column._setProxy(this.castChain());
        return column;
    }

    protected <TProperty> SQLAnyTypeColumn<TProxy, TProperty> getAnyTypeColumn(String property, @Nullable Class<TProperty> propType) {
        SQLAnyTypeColumnImpl column = new SQLAnyTypeColumnImpl(this.entitySQLContext, this.table, property, propType);
        column._setProxy(this.castChain());
        column.setNavValue(this.getFullNavValue(property));
        return column;
    }

    protected SQLBigDecimalTypeColumn<TProxy> getBigDecimalTypeColumn(String property) {
        SQLBigDecimalTypeColumnImpl column = new SQLBigDecimalTypeColumnImpl(this.entitySQLContext, this.table, property);
        column._setProxy(this.castChain());
        column.setNavValue(this.getFullNavValue(property));
        return column;
    }

    protected SQLBooleanTypeColumn<TProxy> getBooleanTypeColumn(String property) {
        SQLBooleanTypeColumnImpl column = new SQLBooleanTypeColumnImpl(this.entitySQLContext, this.table, property);
        column._setProxy(this.castChain());
        column.setNavValue(this.getFullNavValue(property));
        return column;
    }

    protected SQLByteTypeColumn<TProxy> getByteTypeColumn(String property) {
        SQLByteTypeColumnImpl column = new SQLByteTypeColumnImpl(this.entitySQLContext, this.table, property);
        column._setProxy(this.castChain());
        column.setNavValue(this.getFullNavValue(property));
        return column;
    }

    protected SQLDateTypeColumn<TProxy> getSQLDateTypeColumn(String property) {
        SQLDateTypeColumnImpl column = new SQLDateTypeColumnImpl(this.entitySQLContext, this.table, property);
        column._setProxy(this.castChain());
        column.setNavValue(this.getFullNavValue(property));
        return column;
    }

    protected SQLDoubleTypeColumn<TProxy> getDoubleTypeColumn(String property) {
        SQLDoubleTypeColumnImpl column = new SQLDoubleTypeColumnImpl(this.entitySQLContext, this.table, property);
        column._setProxy(this.castChain());
        column.setNavValue(this.getFullNavValue(property));
        return column;
    }

    protected SQLFloatTypeColumn<TProxy> getFloatTypeColumn(String property) {
        SQLFloatTypeColumnImpl column = new SQLFloatTypeColumnImpl(this.entitySQLContext, this.table, property);
        column._setProxy(this.castChain());
        column.setNavValue(this.getFullNavValue(property));
        return column;
    }

    protected SQLIntegerTypeColumn<TProxy> getIntegerTypeColumn(String property) {
        SQLIntegerTypeColumnImpl column = new SQLIntegerTypeColumnImpl(this.entitySQLContext, this.table, property);
        column._setProxy(this.castChain());
        column.setNavValue(this.getFullNavValue(property));
        return column;
    }

    protected SQLLocalDateTimeTypeColumn<TProxy> getLocalDateTimeTypeColumn(String property) {
        SQLLocalDateTimeTypeColumnImpl column = new SQLLocalDateTimeTypeColumnImpl(this.entitySQLContext, this.table, property);
        column._setProxy(this.castChain());
        column.setNavValue(this.getFullNavValue(property));
        return column;
    }

    protected SQLLocalDateTypeColumn<TProxy> getLocalDateTypeColumn(String property) {
        SQLLocalDateTypeColumnImpl column = new SQLLocalDateTypeColumnImpl(this.entitySQLContext, this.table, property);
        column._setProxy(this.castChain());
        column.setNavValue(this.getFullNavValue(property));
        return column;
    }

    protected SQLLocalTimeTypeColumn<TProxy> getLocalTimeTypeColumn(String property) {
        SQLLocalTimeTypeColumnImpl column = new SQLLocalTimeTypeColumnImpl(this.entitySQLContext, this.table, property);
        column._setProxy(this.castChain());
        column.setNavValue(this.getFullNavValue(property));
        return column;
    }

    protected SQLLongTypeColumn<TProxy> getLongTypeColumn(String property) {
        SQLLongTypeColumnImpl column = new SQLLongTypeColumnImpl(this.entitySQLContext, this.table, property);
        column._setProxy(this.castChain());
        column.setNavValue(this.getFullNavValue(property));
        return column;
    }

    protected SQLShortTypeColumn<TProxy> getShortTypeColumn(String property) {
        SQLShortTypeColumnImpl column = new SQLShortTypeColumnImpl(this.entitySQLContext, this.table, property);
        column._setProxy(this.castChain());
        column.setNavValue(this.getFullNavValue(property));
        return column;
    }

    protected SQLStringTypeColumn<TProxy> getStringTypeColumn(String property) {
        SQLStringTypeColumnImpl column = new SQLStringTypeColumnImpl(this.entitySQLContext, this.table, property);
        column._setProxy(this.castChain());
        column.setNavValue(this.getFullNavValue(property));
        return column;
    }

    protected SQLTimestampTypeColumn<TProxy> getTimestampTypeColumn(String property) {
        SQLTimestampTypeColumnImpl column = new SQLTimestampTypeColumnImpl(this.entitySQLContext, this.table, property);
        column._setProxy(this.castChain());
        column.setNavValue(this.getFullNavValue(property));
        return column;
    }

    protected SQLTimeTypeColumn<TProxy> getTimeTypeColumn(String property) {
        SQLTimeTypeColumnImpl column = new SQLTimeTypeColumnImpl(this.entitySQLContext, this.table, property);
        column._setProxy(this.castChain());
        column.setNavValue(this.getFullNavValue(property));
        return column;
    }

    protected SQLUtilDateTypeColumn<TProxy> getUtilDateTypeColumn(String property) {
        SQLUtilDateTypeColumnImpl column = new SQLUtilDateTypeColumnImpl(this.entitySQLContext, this.table, property);
        column._setProxy(this.castChain());
        column.setNavValue(this.getFullNavValue(property));
        return column;
    }

    protected SQLUUIDTypeColumn<TProxy> getUUIDTypeColumn(String property) {
        SQLUUIDTypeColumnImpl column = new SQLUUIDTypeColumnImpl(this.entitySQLContext, this.table, property);
        column._setProxy(this.castChain());
        column.setNavValue(this.getFullNavValue(property));
        return column;
    }

    protected <TPropertyProxy extends ProxyEntity<TPropertyProxy, TProperty>, TProperty> TPropertyProxy getNavigate(String property, TPropertyProxy propertyProxy) {
        Objects.requireNonNull(this.entitySQLContext, "entitySQLContext is null");
        EntityExpressionBuilder entityExpressionBuilder = this.entitySQLContext.getEntityExpressionBuilder();
        if (entityExpressionBuilder == null || this.entitySQLContext.methodIsInclude() || entityExpressionBuilder.getRuntimeContext() instanceof EmptyQueryRuntimeContext) {
            ProxyEntity tPropertyProxy = (ProxyEntity)propertyProxy.create(this.getTable(), this.getEntitySQLContext());
            tPropertyProxy.setNavValue(this.getFullNavValue(property));
            return (TPropertyProxy)tPropertyProxy;
        }
        TableAvailable leftTable = this.getTable();
        if (leftTable == null) {
            throw new EasyQueryInvalidOperationException(String.format("getNavigate %s cant not found table", property));
        }
        NavigateMetadata navigateMetadata = leftTable.getEntityMetadata().getNavigateNotNull(property);
        if (navigateMetadata.getLimit() == 0L) {
            EntityRelationPropertyProvider entityRelationToImplicitProvider = navigateMetadata.getEntityRelationPropertyProvider();
            if (entityRelationToImplicitProvider == null) {
                throw new EasyQueryInvalidOperationException("entityRelationToImplicitProvider is null,Navigate property in non entity plz set supportNonEntity = true.");
            }
            TableAvailable relationTable = entityRelationToImplicitProvider.toImplicitJoin(entityExpressionBuilder, leftTable, property);
            ProxyEntity tPropertyProxy = (ProxyEntity)propertyProxy.create(relationTable, this.getEntitySQLContext());
            String fullName = this.getFullNavValue(property);
            tPropertyProxy.setNavValue(fullName);
            return (TPropertyProxy)tPropertyProxy;
        }
        return this.getNavigateMany(property, propertyProxy).first();
    }

    protected <TPropertyProxy extends ProxyEntity<TPropertyProxy, TProperty>, TProperty> SQLManyQueryable<TProxy, TPropertyProxy, TProperty> getNavigateMany(String property, TPropertyProxy propertyProxy) {
        Objects.requireNonNull(this.entitySQLContext, "entitySQLContext is null");
        EntityExpressionBuilder entityExpressionBuilder = this.entitySQLContext.getEntityExpressionBuilder();
        String fullName = this.getFullNavValue(property);
        return new PropertySQLManyQueryable(new SubQueryContext(entityExpressionBuilder, this.getEntitySQLContext(), this.getTable(), property, fullName, propertyProxy, this));
    }

    private String getFullNavValue(String navValue) {
        String parentNavValue = this.getNavValue();
        if (parentNavValue == null) {
            return navValue;
        }
        return parentNavValue + "." + navValue;
    }

    protected TProxy castChain() {
        return (TProxy)this;
    }

    public SQLAnyTypeColumn<TProxy, Object> anyColumn(String property) {
        return this.anyColumn(property, Object.class);
    }

    public <TProperty> SQLAnyTypeColumn<TProxy, TProperty> anyColumn(String property, @Nullable Class<TProperty> propType) {
        EasyRelationalUtil.TableOrRelationTable tableOrRelationalTable = EasyRelationalUtil.getTableOrRelationalTable((EntityExpressionBuilder)this.getEntitySQLContext().getEntityExpressionBuilder(), (TableAvailable)this.getTable(), (String)property);
        SQLAnyTypeColumnImpl column = new SQLAnyTypeColumnImpl(this.getEntitySQLContext(), tableOrRelationalTable.table, tableOrRelationalTable.property, propType);
        column._setProxy(this.castChain());
        column.setNavValue(this.getFullNavValue(property));
        return column;
    }
}

