/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy.extension.functions;

import com.easy.query.core.func.SQLFunc;
import com.easy.query.core.func.SQLFunction;
import com.easy.query.core.proxy.PropTypeColumn;
import com.easy.query.core.proxy.SQLSelectAsExpression;
import com.easy.query.core.proxy.extension.functions.ColumnObjectFunctionAvailable;
import com.easy.query.core.proxy.extension.functions.cast.ColumnFunctionCastBooleanAvailable;
import com.easy.query.core.proxy.extension.functions.cast.ColumnFunctionCastDateTimeAvailable;
import com.easy.query.core.proxy.extension.functions.cast.ColumnFunctionCastNumberAvailable;
import com.easy.query.core.proxy.extension.functions.cast.ColumnFunctionCastStringAvailable;
import com.easy.query.core.proxy.extension.functions.type.AnyTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.BooleanTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.DateTimeTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.JSONArrayTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.JSONObjectTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.NumberTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.StringTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.impl.AnyTypeExpressionImpl;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.function.Function;

public interface ColumnJSONArrayFunctionAvailable<TProperty>
extends ColumnObjectFunctionAvailable<TProperty, AnyTypeExpression<TProperty>>,
SQLSelectAsExpression,
PropTypeColumn<TProperty>,
ColumnFunctionCastStringAvailable<TProperty>,
ColumnFunctionCastBooleanAvailable<TProperty>,
ColumnFunctionCastNumberAvailable<TProperty>,
ColumnFunctionCastDateTimeAvailable<TProperty> {
    @Override
    default public AnyTypeExpression<TProperty> createChainExpression(Function<SQLFunc, SQLFunction> func, Class<?> propType) {
        return new AnyTypeExpressionImpl(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), func, propType);
    }

    default public AnyTypeExpression<Object> getElement(int index) {
        return new AnyTypeExpressionImpl<Object>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.jsonArrayByIndex(s -> {
            PropTypeColumn.columnFuncSelector(s, this);
            s.format((Object)index);
        }), Objects.class);
    }

    default public StringTypeExpression<String> getString(int index) {
        return this.getElement(index).toStr();
    }

    default public BooleanTypeExpression<Boolean> getBoolean(int index) {
        return this.getElement(index).toBoolean();
    }

    default public NumberTypeExpression<Integer> getInteger(int index) {
        return this.getElement(index).toNumber(Integer.class);
    }

    default public NumberTypeExpression<Long> getLong(int index) {
        return this.getElement(index).toNumber(Long.class);
    }

    default public NumberTypeExpression<BigDecimal> getBigDecimal(int index) {
        return this.getElement(index).toNumber(BigDecimal.class);
    }

    default public DateTimeTypeExpression<LocalDateTime> getLocalDateTime(int index) {
        return this.getElement(index).toDateTime(LocalDateTime.class);
    }

    default public DateTimeTypeExpression<LocalDate> getLocalDate(int index) {
        return this.getElement(index).toDateTime(LocalDate.class);
    }

    default public AnyTypeExpression<TProperty> getJSONElement(int index) {
        return new AnyTypeExpressionImpl(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.jsonArrayExtractByIndex(s -> {
            PropTypeColumn.columnFuncSelector(s, this);
            s.format((Object)index);
        }), Objects.class);
    }

    default public JSONObjectTypeExpression<Object> getJSONObject(int index) {
        return this.getJSONElement(index).asJSONObject();
    }

    default public JSONArrayTypeExpression<Object> getJSONOArray(int index) {
        return this.getJSONElement(index).asJSONArray();
    }
}

