/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy.extension.functions;

import com.easy.query.core.expression.lambda.SQLActionExpression1;
import com.easy.query.core.expression.lambda.SQLFuncExpression2;
import com.easy.query.core.expression.parser.core.SQLTableOwner;
import com.easy.query.core.func.SQLFunc;
import com.easy.query.core.func.SQLFunction;
import com.easy.query.core.func.column.ColumnFuncSelector;
import com.easy.query.core.proxy.PropTypeColumn;
import com.easy.query.core.proxy.extension.ColumnFuncComparableExpression;
import com.easy.query.core.proxy.extension.functions.ColumnAggregateFilterFunctionAvailable;
import com.easy.query.core.proxy.extension.functions.ColumnObjectFunctionAvailable;
import com.easy.query.core.proxy.extension.functions.cast.ColumnFunctionCastBooleanAvailable;
import com.easy.query.core.proxy.extension.functions.cast.ColumnFunctionCastDateTimeAvailable;
import com.easy.query.core.proxy.extension.functions.cast.ColumnFunctionCastJSONAvailable;
import com.easy.query.core.proxy.extension.functions.cast.ColumnFunctionCastNumberAvailable;
import com.easy.query.core.proxy.extension.functions.entry.ConcatExpressionSelector;
import com.easy.query.core.proxy.extension.functions.entry.ConcatExpressionSelectorImpl;
import com.easy.query.core.proxy.extension.functions.type.NumberTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.StringTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.filter.StringFilterTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.filter.impl.StringFilterTypeExpressionImpl;
import com.easy.query.core.proxy.extension.functions.type.impl.NumberTypeExpressionImpl;
import com.easy.query.core.proxy.extension.functions.type.impl.StringTypeExpressionImpl;
import com.easy.query.core.proxy.func.column.ProxyColumnFuncSelector;
import com.easy.query.core.proxy.impl.SQLColumnFunctionCompareComparableExpressionImpl;
import com.easy.query.core.proxy.predicate.aggregate.DSLSQLFunctionAvailable;
import java.util.function.Function;

public interface ColumnStringFunctionAvailable<TProperty>
extends ColumnObjectFunctionAvailable<TProperty, StringTypeExpression<TProperty>>,
ColumnAggregateFilterFunctionAvailable<TProperty, StringFilterTypeExpression<TProperty>>,
ColumnFunctionCastNumberAvailable<TProperty>,
ColumnFunctionCastDateTimeAvailable<TProperty>,
ColumnFunctionCastBooleanAvailable<TProperty>,
ColumnFunctionCastJSONAvailable<TProperty> {
    @Override
    default public StringFilterTypeExpression<TProperty> max() {
        return this.createFilterChainExpression((self, fx) -> fx.max(x -> PropTypeColumn.acceptAnyValue(x, self)), this.getPropertyType());
    }

    @Override
    default public StringFilterTypeExpression<TProperty> min() {
        return this.createFilterChainExpression((self, fx) -> fx.min(x -> PropTypeColumn.acceptAnyValue(x, self)), this.getPropertyType());
    }

    default public StringTypeExpression<TProperty> concat(PropTypeColumn<String> propTypeColumn) {
        return this.concat((SQLActionExpression1<ConcatExpressionSelector>)((SQLActionExpression1)x -> x.expression(propTypeColumn)));
    }

    default public StringTypeExpression<TProperty> concat(String value) {
        return this.concat((SQLActionExpression1<ConcatExpressionSelector>)((SQLActionExpression1)x -> x.value(value)));
    }

    default public StringTypeExpression<TProperty> concat(SQLActionExpression1<ConcatExpressionSelector> stringExpressions) {
        SQLActionExpression1 selector = o -> stringExpressions.apply((Object)new ConcatExpressionSelectorImpl(this.getEntitySQLContext().getRuntimeContext().fx(), (ColumnFuncSelector)o));
        return new StringTypeExpressionImpl(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.concat(o -> {
            PropTypeColumn.columnFuncSelector(o, this);
            selector.apply(o);
        }), String.class);
    }

    default public StringTypeExpression<TProperty> nullOrEmpty() {
        return (StringTypeExpression)this.nullOrDefault((SQLActionExpression1<ProxyColumnFuncSelector>)((SQLActionExpression1)o -> o.value("")));
    }

    default public StringTypeExpression<String> toLower() {
        return new StringTypeExpressionImpl<String>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> {
            if (this instanceof DSLSQLFunctionAvailable) {
                SQLFunction sqlFunction = ((DSLSQLFunctionAvailable)((Object)this)).func().apply((SQLFunc)fx);
                return fx.toLower(sqlFunction);
            }
            return fx.toLower(this.getValue());
        }, String.class);
    }

    default public StringTypeExpression<String> toUpper() {
        return new StringTypeExpressionImpl<String>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> {
            if (this instanceof DSLSQLFunctionAvailable) {
                SQLFunction sqlFunction = ((DSLSQLFunctionAvailable)((Object)this)).func().apply((SQLFunc)fx);
                return fx.toUpper(sqlFunction);
            }
            return fx.toUpper(this.getValue());
        }, String.class);
    }

    default public StringTypeExpression<String> subString(int begin, int length) {
        if (begin < 0) {
            throw new IllegalArgumentException("begin must be greater than 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length must be greater than 0");
        }
        return new StringTypeExpressionImpl<String>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> {
            if (this instanceof DSLSQLFunctionAvailable) {
                SQLFunction sqlFunction = ((DSLSQLFunctionAvailable)((Object)this)).func().apply((SQLFunc)fx);
                return fx.subString(sqlFunction, begin, length);
            }
            return fx.subString(this.getValue(), begin, length);
        }, String.class);
    }

    default public <T extends Number> StringTypeExpression<String> subString(PropTypeColumn<T> begin, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be greater than 0");
        }
        return new StringTypeExpressionImpl<String>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.subString(selector -> {
            PropTypeColumn.columnFuncSelector(selector, this);
            PropTypeColumn.columnFuncSelector(selector, begin);
            selector.format((Object)length);
        }), String.class);
    }

    default public <T1 extends Number, T2 extends Number> StringTypeExpression<String> subString(PropTypeColumn<T1> begin, PropTypeColumn<T2> length) {
        return new StringTypeExpressionImpl<String>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.subString(selector -> {
            PropTypeColumn.columnFuncSelector(selector, this);
            PropTypeColumn.columnFuncSelector(selector, begin);
            PropTypeColumn.columnFuncSelector(selector, length);
        }), String.class);
    }

    default public <T extends Number> StringTypeExpression<String> subString(int begin, PropTypeColumn<T> length) {
        return new StringTypeExpressionImpl<String>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.subString(selector -> {
            PropTypeColumn.columnFuncSelector(selector, this);
            selector.format((Object)begin);
            PropTypeColumn.columnFuncSelector(selector, length);
        }), String.class);
    }

    default public StringTypeExpression<String> trim() {
        return new StringTypeExpressionImpl<String>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> {
            if (this instanceof DSLSQLFunctionAvailable) {
                SQLFunction sqlFunction = ((DSLSQLFunctionAvailable)((Object)this)).func().apply((SQLFunc)fx);
                return fx.trim(sqlFunction);
            }
            return fx.trim(this.getValue());
        }, String.class);
    }

    default public StringTypeExpression<String> ltrim() {
        return new StringTypeExpressionImpl<String>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> {
            if (this instanceof DSLSQLFunctionAvailable) {
                SQLFunction sqlFunction = ((DSLSQLFunctionAvailable)((Object)this)).func().apply((SQLFunc)fx);
                return fx.trimStart(sqlFunction);
            }
            return fx.trimStart(this.getValue());
        }, String.class);
    }

    default public StringTypeExpression<String> rtrim() {
        return new StringTypeExpressionImpl<String>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> {
            if (this instanceof DSLSQLFunctionAvailable) {
                SQLFunction sqlFunction = ((DSLSQLFunctionAvailable)((Object)this)).func().apply((SQLFunc)fx);
                return fx.trimEnd(sqlFunction);
            }
            return fx.trimEnd(this.getValue());
        }, String.class);
    }

    default public StringTypeExpression<String> replace(String oldValue, String newValue) {
        return new StringTypeExpressionImpl<String>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> {
            if (this instanceof DSLSQLFunctionAvailable) {
                SQLFunction sqlFunction = ((DSLSQLFunctionAvailable)((Object)this)).func().apply((SQLFunc)fx);
                return fx.replace(sqlFunction, oldValue, newValue);
            }
            return fx.replace(this.getValue(), oldValue, newValue);
        }, String.class);
    }

    default public StringTypeExpression<String> leftPad(int totalWidth) {
        return new StringTypeExpressionImpl<String>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> {
            if (this instanceof DSLSQLFunctionAvailable) {
                SQLFunction sqlFunction = ((DSLSQLFunctionAvailable)((Object)this)).func().apply((SQLFunc)fx);
                return fx.leftPad(sqlFunction, totalWidth);
            }
            return fx.leftPad(this.getValue(), totalWidth);
        }, String.class);
    }

    default public StringTypeExpression<String> leftPad(int totalWidth, char paddingChar) {
        return new StringTypeExpressionImpl<String>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> {
            if (this instanceof DSLSQLFunctionAvailable) {
                SQLFunction sqlFunction = ((DSLSQLFunctionAvailable)((Object)this)).func().apply((SQLFunc)fx);
                return fx.leftPad(sqlFunction, totalWidth, paddingChar);
            }
            return fx.leftPad(this.getValue(), totalWidth, paddingChar);
        }, String.class);
    }

    default public StringTypeExpression<String> rightPad(int totalWidth) {
        return new StringTypeExpressionImpl<String>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> {
            if (this instanceof DSLSQLFunctionAvailable) {
                SQLFunction sqlFunction = ((DSLSQLFunctionAvailable)((Object)this)).func().apply((SQLFunc)fx);
                return fx.rightPad(sqlFunction, totalWidth);
            }
            return fx.rightPad(this.getValue(), totalWidth);
        }, String.class);
    }

    default public StringTypeExpression<String> rightPad(int totalWidth, char paddingChar) {
        return new StringTypeExpressionImpl<String>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> {
            if (this instanceof DSLSQLFunctionAvailable) {
                SQLFunction sqlFunction = ((DSLSQLFunctionAvailable)((Object)this)).func().apply((SQLFunc)fx);
                return fx.rightPad(sqlFunction, totalWidth, paddingChar);
            }
            return fx.rightPad(this.getValue(), totalWidth, paddingChar);
        }, String.class);
    }

    default public StringFilterTypeExpression<TProperty> joining(String delimiter) {
        return this.joining(delimiter, false);
    }

    default public StringFilterTypeExpression<TProperty> joining(String delimiter, boolean distinct) {
        return this.createFilterChainExpression((self, fx) -> fx.joining(x -> {
            x.value((Object)delimiter);
            PropTypeColumn.acceptAnyValue(x, self);
        }, distinct), (Class)String.class);
    }

    default public NumberTypeExpression<Integer> length() {
        return new NumberTypeExpressionImpl<Integer>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> {
            if (this instanceof DSLSQLFunctionAvailable) {
                SQLFunction sqlFunction = ((DSLSQLFunctionAvailable)((Object)this)).func().apply((SQLFunc)fx);
                return fx.length(sqlFunction);
            }
            return fx.length(this.getValue());
        }, Integer.class);
    }

    @Override
    default public StringTypeExpression<TProperty> createChainExpression(Function<SQLFunc, SQLFunction> func, Class<?> propType) {
        return new StringTypeExpressionImpl(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), func, propType);
    }

    default public ColumnFuncComparableExpression<Integer> compareTo(String comparedValue) {
        return new SQLColumnFunctionCompareComparableExpressionImpl<Integer>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> {
            if (this instanceof DSLSQLFunctionAvailable) {
                SQLFunction sqlFunction = ((DSLSQLFunctionAvailable)((Object)this)).func().apply((SQLFunc)fx);
                return fx.stringCompareTo(sqlFunction, comparedValue);
            }
            return fx.stringCompareTo(this.getValue(), comparedValue);
        }, Integer.class);
    }

    default public ColumnFuncComparableExpression<Integer> compareTo(PropTypeColumn<TProperty> otherColumn) {
        return new SQLColumnFunctionCompareComparableExpressionImpl<Integer>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> {
            if (this instanceof DSLSQLFunctionAvailable) {
                SQLFunction sqlFunction = ((DSLSQLFunctionAvailable)((Object)this)).func().apply((SQLFunc)fx);
                if (otherColumn instanceof DSLSQLFunctionAvailable) {
                    SQLFunction columnFunction = ((DSLSQLFunctionAvailable)((Object)otherColumn)).func().apply((SQLFunc)fx);
                    return fx.stringCompareTo(sqlFunction, columnFunction);
                }
                return fx.stringCompareTo(sqlFunction, (SQLTableOwner)otherColumn, otherColumn.getValue());
            }
            if (otherColumn instanceof DSLSQLFunctionAvailable) {
                SQLFunction columnFunction = ((DSLSQLFunctionAvailable)((Object)otherColumn)).func().apply((SQLFunc)fx);
                return fx.stringCompareTo(this.getValue(), columnFunction);
            }
            return fx.stringCompareTo(this.getValue(), (SQLTableOwner)otherColumn, otherColumn.getValue());
        }, Integer.class);
    }

    default public NumberTypeExpression<Integer> indexOf(String val) {
        String property = this.getValue();
        return new NumberTypeExpressionImpl<Integer>(this.getCurrentEntitySQLContext(), this.getTable(), property, fx -> {
            if (this instanceof DSLSQLFunctionAvailable) {
                SQLFunction sqlFunction = ((DSLSQLFunctionAvailable)((Object)this)).func().apply((SQLFunc)fx);
                return fx.indexOf(s -> s.sqlFunc(sqlFunction).value((Object)val));
            }
            return fx.indexOf(s -> s.column(property).value((Object)val));
        }, Integer.class);
    }

    default public NumberTypeExpression<Integer> indexOf(PropTypeColumn<TProperty> stringSegment) {
        String property = this.getValue();
        return new NumberTypeExpressionImpl<Integer>(this.getCurrentEntitySQLContext(), this.getTable(), property, fx -> fx.indexOf(s -> {
            PropTypeColumn.columnFuncSelector(s, this);
            PropTypeColumn.columnFuncSelector(s, stringSegment);
        }), Integer.class);
    }

    @Override
    default public StringFilterTypeExpression<TProperty> createFilterChainExpression(SQLFuncExpression2<PropTypeColumn<?>, SQLFunc, SQLFunction> func, Class<?> propType) {
        return new StringFilterTypeExpressionImpl(this.getCurrentEntitySQLContext(), this, this.getTable(), this.getValue(), func, propType);
    }
}

