/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy.sql;

import com.easy.query.api.proxy.base.ClassProxy;
import com.easy.query.api.proxy.base.MapTypeAvailable;
import com.easy.query.api.proxy.entity.select.EntityQueryable;
import com.easy.query.api.proxy.entity.select.impl.EasyEntityQueryable;
import com.easy.query.core.basic.api.select.ClientQueryable;
import com.easy.query.core.basic.jdbc.executor.ResultColumnMetadata;
import com.easy.query.core.basic.jdbc.executor.impl.def.EntityResultColumnMetadata;
import com.easy.query.core.basic.jdbc.executor.impl.def.TypeResultColumnMetadata;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.proxy.ProxyEntity;
import com.easy.query.core.proxy.SQLColumn;
import com.easy.query.core.proxy.SQLSelectAsExpression;
import com.easy.query.core.proxy.SQLSelectExpression;
import com.easy.query.core.proxy.core.FlatEntitySQLContext;
import com.easy.query.core.proxy.core.draft.proxy.DraftProxy;
import com.easy.query.core.proxy.impl.SQLSelectAs2Impl;
import com.easy.query.core.proxy.part.proxy.PartProxy;
import com.easy.query.core.proxy.sql.Draft;
import com.easy.query.core.proxy.sql.SQLPart;
import com.easy.query.core.proxy.sql.Tuple;
import com.easy.query.core.util.EasyArrayUtil;
import java.util.Objects;

public class Select {
    public static Draft DRAFT = new Draft();
    public static Tuple TUPLE = new Tuple();
    public static SQLPart PART = new SQLPart();

    public static SQLSelectExpression of(boolean condition, SQLSelectExpression ... selects) {
        if (condition) {
            return Select.of(selects);
        }
        return SQLSelectExpression.empty;
    }

    public static <T> ClassProxy<T> of(Class<T> entityClass, SQLSelectAsExpression ... selects) {
        return ClassProxy.of(entityClass).columns(selects);
    }

    public static SQLSelectExpression of(SQLSelectExpression ... selects) {
        if (EasyArrayUtil.isNotEmpty((Object[])selects)) {
            SQLSelectExpression firstSQLSelectAs = selects[0];
            for (int i = 1; i < selects.length; ++i) {
                firstSQLSelectAs = firstSQLSelectAs._concat(selects[i]);
            }
            return firstSQLSelectAs;
        }
        return SQLSelectExpression.empty;
    }

    public static SQLSelectAsExpression of(SQLSelectAsExpression ... selectAss) {
        if (EasyArrayUtil.isNotEmpty((Object[])selectAss)) {
            SQLSelectAsExpression firstSQLSelectAs = selectAss[0];
            if (selectAss.length == 1) {
                return firstSQLSelectAs;
            }
            SQLSelectAsExpression secondSQLSelectAs = selectAss[1];
            SQLSelectAs2Impl resultExpression = new SQLSelectAs2Impl(firstSQLSelectAs, secondSQLSelectAs);
            for (int i = 2; i < selectAss.length; ++i) {
                resultExpression = new SQLSelectAs2Impl(resultExpression, selectAss[i]);
            }
            return resultExpression;
        }
        return SQLSelectAsExpression.empty;
    }

    public static <TR, TRProxy> void setDraftPropTypes(ClientQueryable<TR> select, TRProxy trProxy) {
        ExpressionContext expressionContext = select.getSQLEntityExpressionBuilder().getExpressionContext();
        if (trProxy instanceof DraftProxy) {
            DraftProxy draftProxy = (DraftProxy)trProxy;
            expressionContext.setResultPropTypes(draftProxy.getDraftPropTypes());
        } else if (trProxy instanceof MapTypeAvailable) {
            MapTypeAvailable mapTypeAvailable = (MapTypeAvailable)trProxy;
            expressionContext.setResultPropTypes((ResultColumnMetadata[])mapTypeAvailable._getResultPropTypes().entrySet().stream().map(x -> new TypeResultColumnMetadata((String)x.getKey(), (Class)x.getValue())).toArray(ResultColumnMetadata[]::new));
        } else if (trProxy instanceof SQLColumn) {
            EntityMetadata entityMetadata;
            ColumnMetadata columnMetadata;
            SQLColumn sqlColumn = (SQLColumn)trProxy;
            if (sqlColumn.getTable() != null && Objects.equals(sqlColumn.getPropertyType(), Object.class) && (columnMetadata = (entityMetadata = sqlColumn.getTable().getEntityMetadata()).getColumnOrNull(sqlColumn.getValue())) != null) {
                expressionContext.setResultPropTypes((ResultColumnMetadata[])new EntityResultColumnMetadata[]{new EntityResultColumnMetadata(0, entityMetadata, columnMetadata)});
            }
        } else if (expressionContext.getResultPropTypes() != null) {
            expressionContext.setResultPropTypes(null);
        }
    }

    public static <TRProxy extends ProxyEntity<TRProxy, TR>, TR> EntityQueryable<TRProxy, TR> selectProxy(TRProxy resultProxy, ClientQueryable<?> queryable) {
        Objects.requireNonNull(resultProxy, "select null result class");
        if (resultProxy.getEntitySQLContext() instanceof FlatEntitySQLContext) {
            throw new EasyQueryInvalidOperationException("The [flatElement] method is not allowed to be used inside the select function. If you wish to retrieve from the [flatElement] function, please use it within the [toList] function. eg. toList(o->o.users().flatElement()) ");
        }
        QueryRuntimeContext runtimeContext = queryable.getSQLEntityExpressionBuilder().getRuntimeContext();
        SQLSelectAsExpression selectAsExpression = resultProxy.getEntitySQLContext().getSelectAsExpression();
        if (selectAsExpression == null) {
            TableAvailable tableOrNull = resultProxy.getTableOrNull();
            if (tableOrNull == null) {
                ClientQueryable select = queryable.select(resultProxy.getEntityClass());
                Select.setDraftPropTypes(select, resultProxy);
                return new EasyEntityQueryable(resultProxy, select);
            }
            EntityMetadata resultEntityMetadata = Select.getResultProxyEntityMetadata(resultProxy, runtimeContext);
            if (resultProxy instanceof SQLSelectExpression) {
                SQLSelectExpression resultProxySelectExpression = (SQLSelectExpression)((Object)resultProxy);
                ClientQueryable select = queryable.select(resultProxy.getEntityClass(), resultEntityMetadata, columnAsSelector -> resultProxySelectExpression.accept(columnAsSelector.getAsSelector()));
                Select.setDraftPropTypes(select, resultProxy);
                return new EasyEntityQueryable(resultProxy, select);
            }
            ClientQueryable select = queryable.select(resultProxy.getEntityClass(), resultEntityMetadata, columnAsSelector -> columnAsSelector.getAsSelector().columnAll(tableOrNull));
            Select.setDraftPropTypes(select, resultProxy);
            return new EasyEntityQueryable(resultProxy, select);
        }
        EntityMetadata resultEntityMetadata = Select.getResultProxyEntityMetadata(resultProxy, runtimeContext);
        ClientQueryable select = queryable.select(resultProxy.getEntityClass(), resultEntityMetadata, columnAsSelector -> {
            if (resultProxy instanceof PartProxy) {
                PartProxy resultProxy1 = (PartProxy)((Object)resultProxy);
                resultProxy1.accept(columnAsSelector.getAsSelector());
            }
            selectAsExpression.accept(columnAsSelector.getAsSelector());
        });
        Select.setDraftPropTypes(select, resultProxy);
        return new EasyEntityQueryable(resultProxy, select);
    }

    private static <TRProxy extends ProxyEntity<TRProxy, TR>, TR> EntityMetadata getResultProxyEntityMetadata(TRProxy resultProxy, QueryRuntimeContext runtimeContext) {
        EntityMetadata entityMetadata = resultProxy.getEntityMetadata();
        if (entityMetadata != null && entityMetadata.getEntityClass().equals(resultProxy.getEntityClass())) {
            return entityMetadata;
        }
        return runtimeContext.getEntityMetadataManager().getEntityMetadata(resultProxy.getEntityClass());
    }
}

