/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.pgsql.expression;

import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.EasyBehaviorEnum;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.SQLEntitySegment;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.expression.segment.builder.SQLBuilderSegment;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.expression.sql.expression.EntityTableSQLExpression;
import com.easy.query.core.expression.sql.expression.impl.EntitySQLExpressionMetadata;
import com.easy.query.core.expression.sql.expression.impl.InsertSQLExpressionImpl;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasySQLExpressionUtil;
import com.easy.query.core.util.EasyStringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class PostgresSQLInsertSQLExpression
extends InsertSQLExpressionImpl {
    public PostgresSQLInsertSQLExpression(EntitySQLExpressionMetadata entitySQLExpressionMetadata, EntityTableSQLExpression table) {
        super(entitySQLExpressionMetadata, table);
    }

    public String toSQL(ToSQLContext toSQLContext) {
        EasySQLExpressionUtil.expressionInvokeRoot((ToSQLContext)toSQLContext);
        EntityTableSQLExpression easyTableSQLExpression = (EntityTableSQLExpression)this.tables.get(0);
        String tableName = easyTableSQLExpression.toSQL(toSQLContext);
        List sqlSegments = this.columns.getSQLSegments();
        int insertColumns = sqlSegments.size();
        StringBuilder sql = new StringBuilder("INSERT INTO ");
        sql.append(tableName).append(" (").append(this.columns.toSQL(toSQLContext)).append(") VALUES (");
        sql.append("?");
        for (int i = 0; i < insertColumns - 1; ++i) {
            sql.append(",?");
        }
        sql.append(")");
        ExpressionContext expressionContext = this.entitySQLExpressionMetadata.getExpressionContext();
        if (expressionContext.getBehavior().hasBehavior(EasyBehaviorEnum.ON_DUPLICATE_KEY_IGNORE)) {
            sql.append(" ON CONFLICT DO NOTHING");
        } else if (expressionContext.getBehavior().hasBehavior(EasyBehaviorEnum.ON_DUPLICATE_KEY_UPDATE)) {
            QueryRuntimeContext runtimeContext = this.getRuntimeContext();
            EntityMetadata entityMetadata = easyTableSQLExpression.getEntityMetadata();
            TableAvailable entityTable = easyTableSQLExpression.getEntityTable();
            Collection keyProperties = entityMetadata.getKeyProperties();
            String constraintPropertyName = this.getConstraintPropertyName(keyProperties);
            StringBuilder duplicateKeyUpdateSql = new StringBuilder();
            SQLBuilderSegment realDuplicateKeyUpdateColumns = this.getRealDuplicateKeyUpdateColumns();
            List realDuplicateKeyUpdateColumnsSQLSegments = realDuplicateKeyUpdateColumns.getSQLSegments();
            Set duplicateKeyUpdateColumnsSet = this.getColumnsSet(this.columns);
            for (SQLSegment sqlSegment : realDuplicateKeyUpdateColumnsSQLSegments) {
                if (!(sqlSegment instanceof SQLEntitySegment)) {
                    throw new EasyQueryInvalidOperationException("insert not support:" + EasyBehaviorEnum.ON_DUPLICATE_KEY_UPDATE.name() + ",column type:" + EasyClassUtil.getSimpleName(sqlSegment.getClass()));
                }
                SQLEntitySegment sqlEntitySegment = (SQLEntitySegment)sqlSegment;
                String propertyName = sqlEntitySegment.getPropertyName();
                if (Objects.equals(propertyName, constraintPropertyName) || keyProperties.contains(propertyName) || !duplicateKeyUpdateColumnsSet.contains(propertyName)) continue;
                if (duplicateKeyUpdateSql.length() != 0) {
                    duplicateKeyUpdateSql.append(", ");
                }
                String columnName = entityTable.getColumnName(propertyName);
                String quoteName = EasySQLExpressionUtil.getQuoteName((QueryRuntimeContext)runtimeContext, (String)columnName);
                duplicateKeyUpdateSql.append(quoteName).append(" = ").append("EXCLUDED.").append(quoteName);
            }
            if (duplicateKeyUpdateSql.length() > 0) {
                String keyColumnName = entityTable.getColumnName(constraintPropertyName);
                String quoteKeyName = EasySQLExpressionUtil.getQuoteName((QueryRuntimeContext)runtimeContext, (String)keyColumnName);
                sql.append(" ON CONFLICT (").append(quoteKeyName).append(") DO UPDATE SET ").append((CharSequence)duplicateKeyUpdateSql);
            }
        }
        return sql.toString();
    }

    protected String getConstraintPropertyName(Collection<String> keyProperties) {
        boolean noDuplicateKey = EasyStringUtil.isBlank((String)this.duplicateKey);
        if (noDuplicateKey) {
            if (EasyCollectionUtil.isNotSingle(keyProperties)) {
                throw new EasyQueryInvalidOperationException("not found single key, cant use:" + EasyBehaviorEnum.ON_DUPLICATE_KEY_UPDATE.name());
            }
            return (String)EasyCollectionUtil.first(keyProperties);
        }
        return this.duplicateKey;
    }
}

