/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.pgsql.func;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.parser.core.base.scec.core.SQLNativeChainExpressionContext;
import com.easy.query.core.func.def.AbstractSQLFunction;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PgSQLDateTimeFormatSQLFunction
extends AbstractSQLFunction {
    private final TableAvailable table;
    private final String property;
    private final String javaFormat;

    public PgSQLDateTimeFormatSQLFunction(TableAvailable table, String property, String javaFormat) {
        this.table = table;
        this.property = property;
        this.javaFormat = javaFormat;
    }

    public String sqlSegment(TableAvailable defaultTable) {
        return this.getSQLSegment();
    }

    public int paramMarks() {
        return 1;
    }

    protected void consume0(SQLNativeChainExpressionContext context) {
        if (this.table == null) {
            context.expression(this.property);
        } else {
            context.expression(this.table, this.property);
        }
    }

    public String getSQLSegment() {
        if (this.javaFormat != null) {
            String format;
            switch (format = this.javaFormat) {
                case "yyyy-MM-dd HH:mm:ss": {
                    return "TO_CHAR({0},'YYYY-MM-DD HH24:MI:SS')";
                }
                case "yyyy-MM-dd HH:mm": {
                    return "TO_CHAR({0},'YYYY-MM-DD HH24:MI')";
                }
                case "yyyy-MM-dd HH": {
                    return "TO_CHAR({0},'YYYY-MM-DD HH24')";
                }
                case "yyyy-MM-dd": {
                    return "TO_CHAR({0},'YYYY-MM-DD')";
                }
                case "yyyy-MM": {
                    return "TO_CHAR({0},'YYYY-MM')";
                }
                case "yyyyMMddHHmmss": {
                    return "TO_CHAR({0},'YYYYMMDDHH24MISS')";
                }
                case "yyyyMMddHHmm": {
                    return "TO_CHAR({0},'YYYYMMDDHH24MI')";
                }
                case "yyyyMMddHH": {
                    return "TO_CHAR({0},'YYYYMMDDHH24')";
                }
                case "yyyyMMdd": {
                    return "TO_CHAR({0},'YYYYMMDD')";
                }
                case "yyyyMM": {
                    return "TO_CHAR({0},'YYYYMM')";
                }
                case "yyyy": {
                    return "TO_CHAR({0},'YYYY')";
                }
                case "HH:mm:ss": {
                    return "TO_CHAR({0},'HH24:MI:SS')";
                }
            }
            format = this.replaceFormat(format);
            String[] argsFinds = new String[]{"YYYY", "YY", "%_a1", "%_a2", "%_a3", "%_a4", "SS", "%_a5"};
            String[] argsSpts = format.split("(M|d|H|hh|h|m|s|t)");
            block48: for (int a2 = 0; a2 < argsSpts.length; ++a2) {
                switch (argsSpts[a2]) {
                    case "M": {
                        argsSpts[a2] = "LTRIM(TO_CHAR({0},'MM'),'0')";
                        continue block48;
                    }
                    case "d": {
                        argsSpts[a2] = "CASE WHEN SUBSTR(TO_CHAR({0},'DD'),1,1) = '0' THEN SUBSTR(TO_CHAR({0},'DD'),2,1) ELSE TO_CHAR({0},'DD') END";
                        continue block48;
                    }
                    case "H": {
                        argsSpts[a2] = "CASE WHEN SUBSTR(TO_CHAR({0},'HH24'),1,1) = '0' THEN SUBSTR(TO_CHAR({0},'HH24'),2,1) ELSE TO_CHAR({0},'HH24') END";
                        continue block48;
                    }
                    case "hh": {
                        argsSpts[a2] = "CASE mod(cast(CASE WHEN SUBSTR(TO_CHAR({0},'HH24'),1,1) = '0' THEN SUBSTR(TO_CHAR({0},'HH24'),2,1) ELSE TO_CHAR({0},'HH24') END as number),12) WHEN 0 THEN '12' WHEN 1 THEN '01' WHEN 2 THEN '02' WHEN 3 THEN '03' WHEN 4 THEN '04' WHEN 5 THEN '05' WHEN 6 THEN '06' WHEN 7 THEN '07' WHEN 8 THEN '08' WHEN 9 THEN '09' WHEN 10 THEN '10' WHEN 11 THEN '11' END";
                        continue block48;
                    }
                    case "h": {
                        argsSpts[a2] = "CASE mod(cast(CASE WHEN SUBSTR(TO_CHAR({0},'HH24'),1,1) = '0' THEN SUBSTR(TO_CHAR({0},'HH24'),2,1) ELSE TO_CHAR({0},'HH24') END as number),12) WHEN 0 THEN '12' WHEN 1 THEN '1' WHEN 2 THEN '2' WHEN 3 THEN '3' WHEN 4 THEN '4' WHEN 5 THEN '5' WHEN 6 THEN '6' WHEN 7 THEN '7' WHEN 8 THEN '8' WHEN 9 THEN '9' WHEN 10 THEN '10' WHEN 11 THEN '11' END";
                        continue block48;
                    }
                    case "m": {
                        argsSpts[a2] = "CASE WHEN SUBSTR(TO_CHAR({0},'MI'),1,1) = '0' THEN SUBSTR(TO_CHAR({0},'MI'),2,1) ELSE TO_CHAR({0},'MI') END";
                        continue block48;
                    }
                    case "s": {
                        argsSpts[a2] = "CASE WHEN SUBSTR(TO_CHAR({0},'SS'),1,1) = '0' THEN SUBSTR(TO_CHAR({0},'SS'),2,1) ELSE TO_CHAR({0},'SS') END";
                        continue block48;
                    }
                    case "t": {
                        argsSpts[a2] = "rtrim(TO_CHAR({0},'AM'),'M')";
                        continue block48;
                    }
                    default: {
                        String argsSptsA = argsSpts[a2];
                        if (argsSptsA.startsWith("'")) {
                            argsSptsA = argsSptsA.substring(1);
                        }
                        if (argsSptsA.endsWith("'")) {
                            argsSptsA = argsSptsA.substring(0, argsSptsA.length() - 1);
                        }
                        argsSpts[a2] = Arrays.stream(argsFinds).anyMatch(argsSptsA::contains) ? "TO_CHAR({0},'" + argsSptsA + "')" : "'" + argsSptsA + "'";
                    }
                }
            }
            if (argsSpts.length == 1) {
                format = argsSpts[0];
            } else if (argsSpts.length > 1) {
                format = "(" + String.join((CharSequence)" || ", (CharSequence[])Arrays.stream(argsSpts).filter(a -> !a.equals("''")).toArray(String[]::new)) + ")";
            }
            return format.replace("%_a1", "MM").replace("%_a2", "DD").replace("%_a3", "HH24").replace("%_a4", "MI").replace("%_a5", "AM");
        }
        return "TO_CHAR({0},'YYYY-MM-DD HH24:MI:SS.US')";
    }

    protected String replaceFormat(String format) {
        String pattern = "(yyyy|yy|MM|dd|HH|hh|mm|ss|tt)";
        Pattern r = Pattern.compile(pattern);
        Matcher matcher = r.matcher(format);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String match;
            switch (match = matcher.group(1)) {
                case "yyyy": {
                    matcher.appendReplacement(result, "YYYY");
                    break;
                }
                case "yy": {
                    matcher.appendReplacement(result, "YY");
                    break;
                }
                case "MM": {
                    matcher.appendReplacement(result, "%_a1");
                    break;
                }
                case "dd": {
                    matcher.appendReplacement(result, "%_a2");
                    break;
                }
                case "HH": {
                    matcher.appendReplacement(result, "%_a3");
                    break;
                }
                case "mm": {
                    matcher.appendReplacement(result, "%_a4");
                    break;
                }
                case "ss": {
                    matcher.appendReplacement(result, "SS");
                    break;
                }
                case "tt": {
                    matcher.appendReplacement(result, "%_a5");
                }
            }
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

