/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.pgsql.func;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import com.easy.query.core.func.def.enums.DateTimeUnitEnum;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.List;

public class PgSQLDateTimePropertySQLFunction
extends AbstractExpressionSQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final DateTimeUnitEnum dateTimeUnitEnum;

    public PgSQLDateTimePropertySQLFunction(List<ColumnExpression> columnExpressions, DateTimeUnitEnum dateTimeUnitEnum) {
        this.columnExpressions = columnExpressions;
        this.dateTimeUnitEnum = dateTimeUnitEnum;
    }

    public String sqlSegment(TableAvailable defaultTable) {
        if (EasyCollectionUtil.isEmpty(this.columnExpressions)) {
            throw new IllegalArgumentException("columnExpressions is empty");
        }
        switch (this.dateTimeUnitEnum) {
            case DayOfYear: {
                return "extract(doy from ({0})::timestamp)";
            }
            case DayOfWeek: {
                return "extract(dow from ({0})::timestamp)";
            }
            case Year: {
                return "extract(year from ({0})::timestamp)";
            }
            case Month: {
                return "extract(month from ({0})::timestamp)";
            }
            case Day: {
                return "extract(day from ({0})::timestamp)";
            }
            case Hour: {
                return "extract(hour from ({0})::timestamp)";
            }
            case Minute: {
                return "extract(minute from ({0})::timestamp)";
            }
            case Second: {
                return "extract(second from ({0})::timestamp)";
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u5f53\u524d\u5c5e\u6027\u83b7\u53d6:" + this.dateTimeUnitEnum);
    }

    public int paramMarks() {
        return this.columnExpressions.size();
    }

    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

