/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.pgsql.func;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import com.easy.query.core.func.def.enums.DateTimeDurationEnum;
import java.util.List;

public class PgSQLDateTimeDurationSQLFunction
extends AbstractExpressionSQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final DateTimeDurationEnum durationEnum;

    public PgSQLDateTimeDurationSQLFunction(List<ColumnExpression> columnExpressions, DateTimeDurationEnum durationEnum) {
        this.columnExpressions = columnExpressions;
        this.durationEnum = durationEnum;
    }

    public String sqlSegment(TableAvailable defaultTable) {
        if (this.columnExpressions.size() != 2) {
            throw new IllegalArgumentException("date time duration sql arguments != 2");
        }
        switch (this.durationEnum) {
            case Days: {
                return "(extract(epoch from ({0})::timestamp-({1})::timestamp)/86400)::int";
            }
            case Hours: {
                return "(extract(epoch from ({0})::timestamp-({1})::timestamp)/3600)::int";
            }
            case Minutes: {
                return "(extract(epoch from ({0})::timestamp-({1})::timestamp)/60)::int";
            }
            case Seconds: {
                return "(extract(epoch from ({0})::timestamp-({1})::timestamp))::int";
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u5f53\u524d\u5c5e\u6027\u83b7\u53d6:" + this.durationEnum);
    }

    public int paramMarks() {
        return this.columnExpressions.size();
    }

    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

