/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.pgsql.func;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import java.util.List;

public class PgSQLJoinSQLFunction
extends AbstractExpressionSQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final boolean distinct;

    public PgSQLJoinSQLFunction(List<ColumnExpression> columnExpressions, boolean distinct) {
        this.columnExpressions = columnExpressions;
        this.distinct = distinct;
    }

    public String sqlSegment(TableAvailable defaultTable) {
        if (this.columnExpressions.size() != 2) {
            throw new IllegalArgumentException("join arguments != 2");
        }
        if (this.distinct) {
            return "STRING_AGG(DISTINCT ({1})::TEXT, {0})";
        }
        return "STRING_AGG(({1})::TEXT, {0})";
    }

    public int paramMarks() {
        return this.columnExpressions.size();
    }

    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

