/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.pgsql.expression;

import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.EasyBehaviorEnum;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.InsertUpdateSetColumnSQLSegment;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.expression.segment.builder.SQLBuilderSegment;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.expression.sql.expression.EntityTableSQLExpression;
import com.easy.query.core.expression.sql.expression.impl.EntitySQLExpressionMetadata;
import com.easy.query.core.expression.sql.expression.impl.InsertSQLExpressionImpl;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasySQLExpressionUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class PostgresSQLInsertSQLExpression
extends InsertSQLExpressionImpl {
    public PostgresSQLInsertSQLExpression(EntitySQLExpressionMetadata entitySQLExpressionMetadata, EntityTableSQLExpression table) {
        super(entitySQLExpressionMetadata, table);
    }

    public String toSQL(ToSQLContext toSQLContext) {
        EasySQLExpressionUtil.expressionInvokeRoot((ToSQLContext)toSQLContext);
        EntityTableSQLExpression easyTableSQLExpression = (EntityTableSQLExpression)this.tables.get(0);
        String tableName = easyTableSQLExpression.toSQL(toSQLContext);
        StringBuilder sql = new StringBuilder("INSERT INTO ");
        sql.append(tableName).append(" (");
        Iterator iterator = this.columns.getSQLSegments().iterator();
        SQLSegment firstColumn = (SQLSegment)iterator.next();
        sql.append(this.getColumnNameWithOwner(firstColumn, toSQLContext));
        while (iterator.hasNext()) {
            SQLSegment next = (SQLSegment)iterator.next();
            sql.append(",").append(this.getColumnNameWithOwner(next, toSQLContext));
        }
        sql.append(") VALUES (").append(this.columns.toSQL(toSQLContext)).append(")");
        ExpressionContext expressionContext = this.entitySQLExpressionMetadata.getExpressionContext();
        if (expressionContext.getBehavior().hasBehavior(EasyBehaviorEnum.ON_DUPLICATE_KEY_IGNORE)) {
            sql.append(" ON CONFLICT DO NOTHING");
        } else if (expressionContext.getBehavior().hasBehavior(EasyBehaviorEnum.ON_DUPLICATE_KEY_UPDATE)) {
            QueryRuntimeContext runtimeContext = this.getRuntimeContext();
            EntityMetadata entityMetadata = easyTableSQLExpression.getEntityMetadata();
            TableAvailable entityTable = easyTableSQLExpression.getEntityTable();
            Collection keyProperties = entityMetadata.getKeyProperties();
            Collection<String> constraintPropertyNames = this.getConstraintPropertyName(entityMetadata, keyProperties);
            StringBuilder duplicateKeyUpdateSql = new StringBuilder();
            SQLBuilderSegment realDuplicateKeyUpdateColumns = this.getRealDuplicateKeyUpdateColumns();
            List realDuplicateKeyUpdateColumnsSQLSegments = realDuplicateKeyUpdateColumns.getSQLSegments();
            Set duplicateKeyUpdateColumnsSet = this.getColumnsSet(this.columns);
            for (SQLSegment sqlSegment : realDuplicateKeyUpdateColumnsSQLSegments) {
                if (!(sqlSegment instanceof InsertUpdateSetColumnSQLSegment)) {
                    throw new EasyQueryInvalidOperationException("insert not support:" + EasyBehaviorEnum.ON_DUPLICATE_KEY_UPDATE.name() + ",column type:" + EasyClassUtil.getSimpleName(sqlSegment.getClass()));
                }
                InsertUpdateSetColumnSQLSegment sqlEntitySegment = (InsertUpdateSetColumnSQLSegment)sqlSegment;
                String propertyName = sqlEntitySegment.getPropertyName();
                if (constraintPropertyNames.contains(propertyName) || keyProperties.contains(propertyName) || !duplicateKeyUpdateColumnsSet.contains(propertyName)) continue;
                if (duplicateKeyUpdateSql.length() != 0) {
                    duplicateKeyUpdateSql.append(", ");
                }
                String quoteName = sqlEntitySegment.getColumnNameWithOwner(toSQLContext);
                duplicateKeyUpdateSql.append(quoteName).append(" = ").append("EXCLUDED.").append(quoteName);
            }
            if (duplicateKeyUpdateSql.length() > 0) {
                sql.append(" ON CONFLICT (");
                Iterator<String> constraintPropertyIterator = constraintPropertyNames.iterator();
                String firstConstraintProperty = constraintPropertyIterator.next();
                sql.append(this.getQuoteName(entityTable, runtimeContext, firstConstraintProperty));
                while (constraintPropertyIterator.hasNext()) {
                    String nextConstraintProperty = constraintPropertyIterator.next();
                    sql.append(",").append(this.getQuoteName(entityTable, runtimeContext, nextConstraintProperty));
                }
                sql.append(") DO UPDATE SET ").append((CharSequence)duplicateKeyUpdateSql);
            }
        }
        return sql.toString();
    }

    private String getQuoteName(TableAvailable entityTable, QueryRuntimeContext runtimeContext, String constraintProperty) {
        String keyColumnName = entityTable.getColumnName(constraintProperty);
        return EasySQLExpressionUtil.getQuoteName((QueryRuntimeContext)runtimeContext, (String)keyColumnName);
    }

    protected Collection<String> getConstraintPropertyName(EntityMetadata entityMetadata, Collection<String> keyProperties) {
        if (EasyCollectionUtil.isEmpty((Collection)this.duplicateKeys)) {
            return this.getConstraintPropertyName0(entityMetadata, keyProperties);
        }
        return this.getConstraintPropertyName0(entityMetadata, this.duplicateKeys);
    }

    private Collection<String> getConstraintPropertyName0(EntityMetadata entityMetadata, Collection<String> columns) {
        Set<String> constraintKeys = columns.stream().filter(o -> !entityMetadata.getColumnNotNull(o).isGeneratedKey()).collect(Collectors.toSet());
        if (EasyCollectionUtil.isEmpty(constraintKeys)) {
            throw new EasyQueryInvalidOperationException(EasyClassUtil.getSimpleName((Class)entityMetadata.getEntityClass()) + " no constraint property");
        }
        return constraintKeys;
    }
}

