/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.pgsql.func;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.column.impl.ColumnFuncFormatExpressionImpl;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class PgSQLDateTimePlusSQLFunction
extends AbstractExpressionSQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final long duration;
    private final TimeUnit timeUnit;

    public PgSQLDateTimePlusSQLFunction(List<ColumnExpression> columnExpressions, long duration, TimeUnit timeUnit) {
        this.columnExpressions = columnExpressions;
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    public String sqlSegment(TableAvailable defaultTable) {
        if (EasyCollectionUtil.isEmpty(this.columnExpressions)) {
            throw new IllegalArgumentException("columnExpressions is empty");
        }
        ColumnExpression columnExpression = this.columnExpressions.get(0);
        this.columnExpressions.clear();
        this.columnExpressions.add(columnExpression);
        long seconds = this.timeUnit.toSeconds(this.duration);
        this.columnExpressions.add((ColumnExpression)new ColumnFuncFormatExpressionImpl((Object)seconds));
        return "({0} + INTERVAL '{1} second')";
    }

    public int paramMarks() {
        return this.columnExpressions.size();
    }

    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

