/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.pgsql.migration;

import com.easy.query.core.configuration.dialect.SQLKeyword;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.migration.AbstractDatabaseMigrationProvider;
import com.easy.query.core.migration.ColumnDbTypeResult;
import com.easy.query.core.migration.EntityMigrationMetadata;
import com.easy.query.core.migration.MigrationCommand;
import com.easy.query.core.migration.MigrationEntityParser;
import com.easy.query.core.migration.TableForeignKeyResult;
import com.easy.query.core.migration.TableIndexResult;
import com.easy.query.core.migration.commands.DefaultMigrationCommand;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyDatabaseUtil;
import com.easy.query.core.util.EasyStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public class PgSQLDatabaseMigrationProvider
extends AbstractDatabaseMigrationProvider {
    public PgSQLDatabaseMigrationProvider(DataSource dataSource, SQLKeyword sqlKeyword, MigrationEntityParser migrationEntityParser) {
        super(dataSource, sqlKeyword, migrationEntityParser);
    }

    public String databaseExistSQL(String databaseName) {
        return String.format("select 1 from pg_namespace where nspname = '%s'", databaseName);
    }

    public String createDatabaseSQL(String databaseName) {
        return "CREATE SCHEMA IF NOT EXISTS " + this.getQuoteSQLName(databaseName) + ";";
    }

    public boolean tableExists(String schema, String tableName) {
        ArrayList<String> sqlParameters = new ArrayList<String>();
        if (EasyStringUtil.isBlank((String)schema)) {
            sqlParameters.add("public");
        } else {
            sqlParameters.add(schema);
        }
        sqlParameters.add(tableName);
        List maps = EasyDatabaseUtil.sqlQuery((DataSource)this.dataSource, (String)"select 1 from pg_tables a inner join pg_namespace b on b.nspname = a.schemaname where b.nspname =? and a.tablename = ?", sqlParameters);
        return EasyCollectionUtil.isNotEmpty((Collection)maps);
    }

    public MigrationCommand renameTable(EntityMigrationMetadata entityMigrationMetadata) {
        EntityMetadata entityMetadata = entityMigrationMetadata.getEntityMetadata();
        String sql = "ALTER TABLE " + this.getQuoteSQLName(entityMetadata.getSchemaOrNull(), entityMetadata.getOldTableName()) + " RENAME TO " + this.getQuoteSQLName(entityMetadata.getSchemaOrNull(), entityMetadata.getTableName()) + ";";
        return new DefaultMigrationCommand(entityMetadata, sql);
    }

    public MigrationCommand createTable(EntityMigrationMetadata entityMigrationMetadata) {
        EntityMetadata entityMetadata = entityMigrationMetadata.getEntityMetadata();
        StringBuilder sql = new StringBuilder();
        StringBuilder columnCommentSQL = new StringBuilder();
        String tableComment = this.getTableComment(entityMigrationMetadata, "'");
        if (EasyStringUtil.isNotBlank((String)tableComment)) {
            columnCommentSQL.append(newLine).append("COMMENT ON TABLE ").append(this.getQuoteSQLName(entityMetadata.getSchemaOrNull(), entityMetadata.getTableName())).append(" IS ").append(tableComment).append(";");
        }
        sql.append("CREATE TABLE IF NOT EXISTS ").append(this.getQuoteSQLName(entityMetadata.getSchemaOrNull(), entityMetadata.getTableName())).append(" ( ");
        for (ColumnMetadata column : entityMetadata.getColumns()) {
            sql.append(newLine).append(this.getQuoteSQLName(column.getName())).append(" ");
            ColumnDbTypeResult columnDbTypeResult = this.getColumnDbType(entityMigrationMetadata, column);
            sql.append(columnDbTypeResult.columnType);
            boolean nullable = this.migrationEntityParser.isNullable(entityMigrationMetadata, column);
            if (nullable) {
                sql.append(" NULL ");
            } else {
                sql.append(" NOT NULL ");
            }
            if (column.isGeneratedKey()) {
                sql.append(" GENERATED BY DEFAULT AS IDENTITY");
            } else if (EasyStringUtil.isNotBlank((String)columnDbTypeResult.defValue)) {
                sql.append(" DEFAULT ").append(columnDbTypeResult.defValue);
            }
            String columnComment = this.getColumnComment(entityMigrationMetadata, column, "'");
            if (EasyStringUtil.isNotBlank((String)columnComment)) {
                columnCommentSQL.append(newLine).append("COMMENT ON COLUMN ").append(this.getQuoteSQLName(entityMetadata.getSchemaOrNull(), entityMetadata.getTableName())).append(".").append(this.getQuoteSQLName(column.getName())).append(" IS ").append(columnComment).append(";");
            }
            sql.append(",");
        }
        Collection keyProperties = entityMetadata.getKeyProperties();
        if (EasyCollectionUtil.isNotEmpty((Collection)keyProperties)) {
            sql.append(" ").append(newLine).append(" PRIMARY KEY (");
            int i = keyProperties.size();
            for (String keyProperty : keyProperties) {
                ColumnMetadata keyColumn = entityMetadata.getColumnNotNull(keyProperty);
                sql.append(this.getQuoteSQLName(keyColumn.getName()));
                if (--i > 0) {
                    sql.append(", ");
                    continue;
                }
                sql.append(")");
            }
        } else {
            sql.deleteCharAt(sql.length() - 1);
        }
        sql.append(newLine).append(");");
        if (columnCommentSQL.length() > 0) {
            sql.append(newLine).append((CharSequence)columnCommentSQL);
        }
        return new DefaultMigrationCommand(entityMetadata, sql.toString());
    }

    protected MigrationCommand renameColumn(EntityMigrationMetadata entityMigrationMetadata, String renameFrom, ColumnMetadata column) {
        EntityMetadata entityMetadata = entityMigrationMetadata.getEntityMetadata();
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ").append(this.getQuoteSQLName(entityMetadata.getSchemaOrNull(), entityMetadata.getTableName())).append(" RENAME COLUMN ").append(this.getQuoteSQLName(renameFrom)).append(" TO ").append(this.getQuoteSQLName(column.getName())).append(";");
        String columnComment = this.getColumnComment(entityMigrationMetadata, column, "'");
        if (EasyStringUtil.isNotBlank((String)columnComment)) {
            sql.append(newLine);
            sql.append(" COMMENT ON COLUMN ").append(this.getQuoteSQLName(entityMetadata.getSchemaOrNull(), entityMetadata.getTableName())).append(" IS ").append(columnComment);
            sql.append(";");
        }
        return new DefaultMigrationCommand(entityMetadata, sql.toString());
    }

    protected MigrationCommand addColumn(EntityMigrationMetadata entityMigrationMetadata, ColumnMetadata column) {
        EntityMetadata entityMetadata = entityMigrationMetadata.getEntityMetadata();
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ").append(this.getQuoteSQLName(entityMetadata.getSchemaOrNull(), entityMetadata.getTableName())).append(" ADD ").append(this.getQuoteSQLName(column.getName())).append(" ");
        ColumnDbTypeResult columnDbTypeResult = this.getColumnDbType(entityMigrationMetadata, column);
        sql.append(columnDbTypeResult.columnType);
        if (this.migrationEntityParser.isNullable(entityMigrationMetadata, column)) {
            sql.append(" NULL");
        } else {
            sql.append(" NOT NULL");
        }
        if (EasyStringUtil.isNotBlank((String)columnDbTypeResult.defValue)) {
            sql.append(" DEFAULT ").append(columnDbTypeResult.defValue);
        }
        sql.append(";");
        String columnComment = this.getColumnComment(entityMigrationMetadata, column, "'");
        if (EasyStringUtil.isNotBlank((String)columnComment)) {
            sql.append(newLine);
            sql.append(" COMMENT ON COLUMN ").append(this.getQuoteSQLName(entityMetadata.getSchemaOrNull(), entityMetadata.getTableName())).append(" IS ").append(columnComment);
            sql.append(";");
        }
        return new DefaultMigrationCommand(entityMetadata, sql.toString());
    }

    protected MigrationCommand createIndex(EntityMigrationMetadata entityMigrationMetadata, TableIndexResult tableIndex) {
        EntityMetadata entityMetadata = entityMigrationMetadata.getEntityMetadata();
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE ");
        if (tableIndex.unique) {
            sql.append("UNIQUE INDEX ");
        } else {
            sql.append("INDEX ");
        }
        sql.append(tableIndex.indexName);
        sql.append(" ON ").append(this.getQuoteSQLName(entityMetadata.getSchemaOrNull(), entityMetadata.getTableName()));
        sql.append(" (");
        StringJoiner joiner = new StringJoiner(",");
        for (int i = 0; i < tableIndex.fields.size(); ++i) {
            TableIndexResult.EntityField entityField = (TableIndexResult.EntityField)tableIndex.fields.get(i);
            String column = this.getQuoteSQLName(entityField.columnName) + " " + (entityField.asc ? "ASC" : "DESC");
            joiner.add(column);
        }
        sql.append(joiner);
        sql.append(");");
        return new DefaultMigrationCommand(entityMetadata, sql.toString());
    }

    public MigrationCommand dropTable(EntityMigrationMetadata entityMigrationMetadata) {
        EntityMetadata entityMetadata = entityMigrationMetadata.getEntityMetadata();
        return new DefaultMigrationCommand(entityMetadata, "DROP TABLE " + this.getQuoteSQLName(entityMetadata.getSchemaOrNull(), entityMetadata.getTableName()) + ";");
    }

    protected MigrationCommand createTableForeignKey(EntityMigrationMetadata entityMigrationMetadata, TableForeignKeyResult tableForeignKeyResult) {
        EntityMetadata entityMetadata = entityMigrationMetadata.getEntityMetadata();
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ");
        sql.append(this.getQuoteSQLName(entityMetadata.getSchemaOrNull(), entityMetadata.getTableName()));
        sql.append(" ADD CONSTRAINT ").append(tableForeignKeyResult.name);
        sql.append(" FOREIGN KEY (");
        String selfColumns = Arrays.stream(tableForeignKeyResult.selfColumn).map(self -> this.getQuoteSQLName((String)self)).collect(Collectors.joining(","));
        sql.append(selfColumns);
        sql.append(") REFERENCES ");
        sql.append(this.getQuoteSQLName(tableForeignKeyResult.targetTable));
        sql.append(" (");
        String targetColumns = Arrays.stream(tableForeignKeyResult.targetColumn).map(target -> this.getQuoteSQLName((String)target)).collect(Collectors.joining(","));
        sql.append(targetColumns);
        sql.append(")");
        if (EasyStringUtil.isNotBlank((String)tableForeignKeyResult.action)) {
            sql.append(" ").append(tableForeignKeyResult.action).append(" ");
        }
        sql.append(";");
        return new DefaultMigrationCommand(entityMetadata, sql.toString());
    }
}

