/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.pgsql.func;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import com.easy.query.core.func.def.enums.TimeUnitEnum;
import java.util.List;

public class PgSQLDateTime2PlusSQLFunction
extends AbstractExpressionSQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final TimeUnitEnum timeUnit;

    public PgSQLDateTime2PlusSQLFunction(List<ColumnExpression> columnExpressions, TimeUnitEnum timeUnit) {
        this.columnExpressions = columnExpressions;
        this.timeUnit = timeUnit;
    }

    public String sqlSegment(TableAvailable defaultTable) {
        if (this.columnExpressions.size() != 2) {
            throw new IllegalArgumentException("columnExpressions.size() != 2");
        }
        switch (this.timeUnit) {
            case MILLISECONDS: {
                return "(({0})::timestamp+(({1})||' milliseconds')::interval)";
            }
            case SECONDS: {
                return "(({0})::timestamp+(({1})||' second')::interval)";
            }
            case MINUTES: {
                return "(({0})::timestamp+(({1})||' minute')::interval)";
            }
            case HOURS: {
                return "(({0})::timestamp+(({1})||' hour')::interval)";
            }
            case DAYS: {
                return "(({0})::timestamp+(({1})||' day')::interval)";
            }
            case MONTHS: {
                return "(({0})::timestamp+(({1})||' month')::interval)";
            }
            case YEARS: {
                return "(({0})::timestamp+(({1})||' year')::interval)";
            }
        }
        throw new UnsupportedOperationException("not support current function PgSQLDateTime2PlusSQLFunction:" + this.timeUnit);
    }

    public int paramMarks() {
        return this.columnExpressions.size();
    }

    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

