/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.pgsql.func;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import com.easy.query.core.func.def.enums.MathMethodEnum;
import java.util.List;

public class PgSQLMathSQLFunction
extends AbstractExpressionSQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final MathMethodEnum mathMethodEnum;

    public PgSQLMathSQLFunction(List<ColumnExpression> columnExpressions, MathMethodEnum mathMethodEnum) {
        this.columnExpressions = columnExpressions;
        this.mathMethodEnum = mathMethodEnum;
    }

    public String sqlSegment(TableAvailable defaultTable) {
        switch (this.mathMethodEnum) {
            case Abs: {
                return "ABS({0})";
            }
            case Signum: {
                return "SIGN({0})";
            }
            case Floor: {
                return "FLOOR({0})";
            }
            case Ceiling: {
                return "CEILING({0})";
            }
            case Round: {
                if (this.columnExpressions.size() > 1) {
                    return "ROUND({0},{1})";
                }
                return "ROUND({0})";
            }
            case Exp: {
                return "EXP({0})";
            }
            case Log: {
                return "LN({0})";
            }
            case Log10: {
                return "LOG10({0})";
            }
            case Pow: {
                if (this.columnExpressions.size() < 2) {
                    throw new IllegalArgumentException("pow\u65b9\u6cd5\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u53c2\u6570");
                }
                return "POW({0},{1})";
            }
            case Sqrt: {
                return "SQRT({0})";
            }
            case Cos: {
                return "COS({0})";
            }
            case Sin: {
                return "SIN({0})";
            }
            case Tan: {
                return "TAN({0})";
            }
            case Acos: {
                return "ACOS({0})";
            }
            case Asin: {
                return "ASIN({0})";
            }
            case Atan: {
                return "ATAN({0})";
            }
            case Atan2: {
                if (this.columnExpressions.size() < 2) {
                    throw new IllegalArgumentException("Atan2\u65b9\u6cd5\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u53c2\u6570");
                }
                return "ATAN2({0},{1})";
            }
            case Truncate: {
                return "TRUNC({0},0)";
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u5f53\u524d\u51fd\u6570PgSQLMathSQLFunction:" + this.mathMethodEnum);
    }

    public int paramMarks() {
        return this.columnExpressions.size();
    }

    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

