/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.pgsql.migration;

import com.easy.query.core.configuration.dialect.SQLKeyword;
import com.easy.query.core.migration.AbstractDatabaseMigrationProvider;
import com.easy.query.core.migration.ColumnDbTypeResult;
import com.easy.query.core.migration.MigrationCommand;
import com.easy.query.core.migration.MigrationEntityParser;
import com.easy.query.core.migration.commands.DefaultMigrationCommand;
import com.easy.query.core.migration.data.ColumnMigrationData;
import com.easy.query.core.migration.data.ForeignKeyMigrationData;
import com.easy.query.core.migration.data.IndexMigrationData;
import com.easy.query.core.migration.data.TableMigrationData;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyDatabaseUtil;
import com.easy.query.core.util.EasyStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public class PgSQLDatabaseMigrationProvider
extends AbstractDatabaseMigrationProvider {
    public PgSQLDatabaseMigrationProvider(DataSource dataSource, SQLKeyword sqlKeyword, MigrationEntityParser migrationEntityParser) {
        super(dataSource, sqlKeyword, migrationEntityParser);
    }

    public String databaseExistSQL(String databaseName) {
        return String.format("select 1 from pg_namespace where nspname = '%s'", databaseName);
    }

    public String createDatabaseSQL(String databaseName) {
        return "CREATE SCHEMA IF NOT EXISTS " + this.getQuoteSQLName(databaseName) + ";";
    }

    public boolean tableExists(String schema, String tableName) {
        ArrayList<String> sqlParameters = new ArrayList<String>();
        if (EasyStringUtil.isBlank((String)schema)) {
            sqlParameters.add("public");
        } else {
            sqlParameters.add(schema);
        }
        sqlParameters.add(tableName);
        List maps = EasyDatabaseUtil.sqlQuery((DataSource)this.dataSource, (String)"select 1 from pg_tables a inner join pg_namespace b on b.nspname = a.schemaname where b.nspname =? and a.tablename = ?", sqlParameters);
        return EasyCollectionUtil.isNotEmpty((Collection)maps);
    }

    public MigrationCommand renameTable(TableMigrationData tableMigrationData) {
        String sql = "ALTER TABLE " + this.getQuoteSQLName(tableMigrationData.getSchema(), tableMigrationData.getOldTableName()) + " RENAME TO " + this.getQuoteSQLName(tableMigrationData.getSchema(), tableMigrationData.getTableName()) + ";";
        return new DefaultMigrationCommand(sql);
    }

    public MigrationCommand createTable(TableMigrationData tableMigrationData) {
        StringBuilder sql = new StringBuilder();
        StringBuilder columnCommentSQL = new StringBuilder();
        String tableComment = this.getTableComment(tableMigrationData, "'");
        if (EasyStringUtil.isNotBlank((String)tableComment)) {
            columnCommentSQL.append(newLine).append("COMMENT ON TABLE ").append(this.getQuoteSQLName(tableMigrationData.getSchema(), tableMigrationData.getTableName())).append(" IS ").append(tableComment).append(";");
        }
        sql.append("CREATE TABLE IF NOT EXISTS ").append(this.getQuoteSQLName(tableMigrationData.getSchema(), tableMigrationData.getTableName())).append(" ( ");
        for (ColumnMigrationData column : tableMigrationData.getColumns()) {
            sql.append(newLine).append(this.getQuoteSQLName(column.getName())).append(" ");
            ColumnDbTypeResult columnDbTypeResult = new ColumnDbTypeResult(column.getDbType(), column.getDefValue());
            sql.append(columnDbTypeResult.columnType);
            if (column.isNotNull()) {
                sql.append(" NOT NULL ");
            } else {
                sql.append(" NULL ");
            }
            if (column.isGeneratedKey()) {
                sql.append(" GENERATED BY DEFAULT AS IDENTITY");
            } else if (EasyStringUtil.isNotBlank((String)columnDbTypeResult.defValue)) {
                sql.append(" DEFAULT ").append(columnDbTypeResult.defValue);
            }
            String columnComment = this.getColumnComment(column, "'");
            if (EasyStringUtil.isNotBlank((String)columnComment)) {
                columnCommentSQL.append(newLine).append("COMMENT ON COLUMN ").append(this.getQuoteSQLName(tableMigrationData.getSchema(), tableMigrationData.getTableName())).append(".").append(this.getQuoteSQLName(column.getName())).append(" IS ").append(columnComment).append(";");
            }
            sql.append(",");
        }
        List keys = EasyCollectionUtil.filter((List)tableMigrationData.getColumns(), s -> s.isPrimary());
        if (EasyCollectionUtil.isNotEmpty((Collection)keys)) {
            sql.append(" ").append(newLine).append(" PRIMARY KEY (");
            int i = keys.size();
            for (ColumnMigrationData keyColumn : keys) {
                sql.append(this.getQuoteSQLName(keyColumn.getName()));
                if (--i > 0) {
                    sql.append(", ");
                    continue;
                }
                sql.append(")");
            }
        } else {
            sql.deleteCharAt(sql.length() - 1);
        }
        sql.append(newLine).append(");");
        if (columnCommentSQL.length() > 0) {
            sql.append(newLine).append((CharSequence)columnCommentSQL);
        }
        return new DefaultMigrationCommand(sql.toString());
    }

    protected MigrationCommand renameColumn(TableMigrationData table, String renameFrom, ColumnMigrationData column) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ").append(this.getQuoteSQLName(table.getSchema(), table.getTableName())).append(" RENAME COLUMN ").append(this.getQuoteSQLName(renameFrom)).append(" TO ").append(this.getQuoteSQLName(column.getName())).append(";");
        String columnComment = this.getColumnComment(column, "'");
        if (EasyStringUtil.isNotBlank((String)columnComment)) {
            sql.append(newLine);
            sql.append(" COMMENT ON COLUMN ").append(this.getQuoteSQLName(table.getSchema(), table.getTableName())).append(" IS ").append(columnComment);
            sql.append(";");
        }
        return new DefaultMigrationCommand(sql.toString());
    }

    protected MigrationCommand addColumn(TableMigrationData table, ColumnMigrationData column) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ").append(this.getQuoteSQLName(table.getSchema(), table.getTableName())).append(" ADD ").append(this.getQuoteSQLName(column.getName())).append(" ");
        ColumnDbTypeResult columnDbTypeResult = new ColumnDbTypeResult(column.getDbType(), column.getDefValue());
        sql.append(columnDbTypeResult.columnType);
        if (column.isNotNull()) {
            sql.append(" NOT NULL");
        } else {
            sql.append(" NULL");
        }
        if (EasyStringUtil.isNotBlank((String)columnDbTypeResult.defValue)) {
            sql.append(" DEFAULT ").append(columnDbTypeResult.defValue);
        }
        sql.append(";");
        String columnComment = this.getColumnComment(column, "'");
        if (EasyStringUtil.isNotBlank((String)columnComment)) {
            sql.append(newLine);
            sql.append(" COMMENT ON COLUMN ").append(this.getQuoteSQLName(table.getSchema(), table.getTableName())).append(" IS ").append(columnComment);
            sql.append(";");
        }
        return new DefaultMigrationCommand(sql.toString());
    }

    protected MigrationCommand createIndex(TableMigrationData table, IndexMigrationData tableIndex) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE ");
        if (tableIndex.isUnique()) {
            sql.append("UNIQUE INDEX ");
        } else {
            sql.append("INDEX ");
        }
        sql.append(tableIndex.getIndexName());
        sql.append(" ON ").append(this.getQuoteSQLName(table.getSchema(), table.getTableName()));
        sql.append(" (");
        StringJoiner joiner = new StringJoiner(",");
        for (int i = 0; i < tableIndex.getFields().size(); ++i) {
            IndexMigrationData.EntityField entityField = (IndexMigrationData.EntityField)tableIndex.getFields().get(i);
            String column = this.getQuoteSQLName(entityField.getColumnName()) + " " + (entityField.isAsc() ? "ASC" : "DESC");
            joiner.add(column);
        }
        sql.append(joiner);
        sql.append(");");
        return new DefaultMigrationCommand(sql.toString());
    }

    public MigrationCommand dropTable(TableMigrationData table) {
        return new DefaultMigrationCommand("DROP TABLE " + this.getQuoteSQLName(table.getSchema(), table.getTableName()) + ";");
    }

    protected MigrationCommand createTableForeignKey(TableMigrationData table, ForeignKeyMigrationData foreignKey) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ");
        sql.append(this.getQuoteSQLName(table.getSchema(), table.getTableName()));
        sql.append(" ADD CONSTRAINT ").append(foreignKey.getName());
        sql.append(" FOREIGN KEY (");
        String selfColumns = Arrays.stream(foreignKey.getSelfColumn()).map(self -> this.getQuoteSQLName((String)self)).collect(Collectors.joining(","));
        sql.append(selfColumns);
        sql.append(") REFERENCES ");
        sql.append(this.getQuoteSQLName(foreignKey.getTargetTable()));
        sql.append(" (");
        String targetColumns = Arrays.stream(foreignKey.getTargetColumn()).map(target -> this.getQuoteSQLName((String)target)).collect(Collectors.joining(","));
        sql.append(targetColumns);
        sql.append(")");
        if (EasyStringUtil.isNotBlank((String)foreignKey.getAction())) {
            sql.append(" ").append(foreignKey.getAction()).append(" ");
        }
        sql.append(";");
        return new DefaultMigrationCommand(sql.toString());
    }
}

